/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.lootchests;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;

public class WeightedItemStack {
    private String itemName;
    private int minCount;
    private int maxCount;
    private int weight;
    private boolean enchant = false;
    private boolean treasure;
    private int damage;
    private int minLvl;
    private int maxLvl;
    private int enchantChance;

    public WeightedItemStack(String itemName, int damage, int minItems, int maxItems, int weight, boolean enchant, int minEnchantLevel, int maxEnchantLevel, boolean isTreasure, int enchantChance) {
        this.itemName = itemName;
        this.damage = damage;
        this.minCount = minItems;
        this.maxCount = maxItems;
        this.weight = weight;
        this.enchant = enchant;
        this.minLvl = minEnchantLevel;
        this.maxLvl = maxEnchantLevel;
        this.treasure = isTreasure;
        this.enchantChance = enchantChance;
    }

    public int getWeight() {
        return this.weight;
    }

    public LootPool getAsSingleLootPool(int indx) {
        RandomChance condition = new RandomChance(new Float(this.weight).floatValue() / 100.0f);
        LootCondition[] conditionA = new LootCondition[]{condition};
        RandomChance condition3 = new RandomChance(1.0f);
        LootCondition[] conditionC = new LootCondition[]{condition3};
        ArrayList<Object> functions = new ArrayList<Object>();
        functions.add(new SetCount(null, new RandomValueRange((float)this.minCount, (float)this.maxCount)));
        if (this.enchant) {
            LootCondition[] enchConds = null;
            if (this.enchantChance > 0) {
                enchConds = new LootCondition[]{new RandomChance(new Float(this.enchantChance).floatValue() / 100.0f)};
            }
            if (this.treasure) {
                functions.add(new EnchantWithLevels(enchConds, new RandomValueRange((float)(this.minLvl * 2), (float)(this.maxLvl * 2)), true));
            } else {
                functions.add(new EnchantWithLevels(enchConds, new RandomValueRange((float)this.minLvl, (float)this.maxLvl), false));
            }
        }
        if (this.damage != 0 && this.damage > 0) {
            functions.add(new SetMetadata(null, new RandomValueRange((float)this.damage)));
        }
        LootEntryItem entry = new LootEntryItem(Item.func_111206_d((String)this.itemName), this.weight, 0, functions.toArray(new LootFunction[0]), conditionC, "entry_" + indx + this.itemName);
        LootEntry[] entryA = new LootEntry[]{entry};
        LootPool pool = new LootPool(entryA, conditionA, new RandomValueRange(1.0f), new RandomValueRange(0.0f), "item_" + indx);
        return pool;
    }

    public LootEntry getAsLootEntry(int indx) {
        RandomChance condition = new RandomChance(new Float(this.weight).floatValue() / 100.0f);
        LootCondition[] conditionA = new LootCondition[]{condition};
        ArrayList<Object> functions = new ArrayList<Object>();
        functions.add(new SetCount(null, new RandomValueRange((float)this.minCount, (float)this.maxCount)));
        if (this.enchant) {
            LootCondition[] enchConds = null;
            if (this.enchantChance > 0) {
                enchConds = new LootCondition[]{new RandomChance(new Float(this.enchantChance).floatValue() / 100.0f)};
            }
            if (this.treasure) {
                functions.add(new EnchantWithLevels(enchConds, new RandomValueRange((float)(this.minLvl * 2), (float)(this.maxLvl * 2)), this.treasure));
            } else {
                functions.add(new EnchantWithLevels(enchConds, new RandomValueRange((float)this.minLvl, (float)this.maxLvl), false));
            }
        }
        if (this.damage != 0 && this.damage > 0) {
            functions.add(new SetMetadata(null, new RandomValueRange((float)this.damage)));
        }
        LootEntryItem entry = new LootEntryItem(Item.func_111206_d((String)this.itemName), this.weight, 0, functions.toArray(new LootFunction[0]), conditionA, "entry_" + indx + this.itemName);
        return entry;
    }

    public WeightedItemStack setChance(int chance) {
        if (chance != this.weight) {
            this.weight = Math.abs(chance);
        }
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }
}

