/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoBanner;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoBoss;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoEmpty;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoForceFieldNexus;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoLootChest;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoMap;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoSpawner;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structuregen.structurefile.IGeneratable;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;

public abstract class AbstractBlockInfo
implements IGeneratable {
    protected static final Random RANDOM = new Random();
    protected static final BlockPos.MutableBlockPos MUTABLE_POS = new BlockPos.MutableBlockPos();
    public static final byte NULL_INFO_ID = -1;
    public static final byte EMPTY_INFO_ID = 0;
    public static final byte BLOCK_INFO_ID = 1;
    public static final byte BANNER_INFO_ID = 2;
    public static final byte BOSS_INFO_ID = 3;
    public static final byte NEXUS_INFO_ID = 4;
    public static final byte CHEST_INFO_ID = 5;
    public static final byte SPAWNER_INFO_ID = 6;
    public static final byte MAP_INFO_ID = 7;
    private short x;
    private short y;
    private short z;

    public AbstractBlockInfo(int x, int y, int z) {
        this.x = (short)x;
        this.y = (short)y;
        this.z = (short)z;
    }

    public AbstractBlockInfo(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void generate(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion) {
        BlockPos.MutableBlockPos transformedPos = this.getTransformedMutableBlockPos(dungeonPartPos, settings.func_186212_b(), settings.func_186215_c(), MUTABLE_POS);
        if (world.func_175701_a((BlockPos)transformedPos)) {
            this.clearInventoryAt(world, (BlockPos)transformedPos);
            this.generateAt(world, dungeonPos, dungeonPartPos, settings, dungeonMob, protectedRegion, (BlockPos)transformedPos);
        }
    }

    protected void clearInventoryAt(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity != null) {
            if (tileentity instanceof IInventory) {
                ((IInventory)tileentity).func_174888_l();
            }
            if (tileentity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler itemhandler = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (int i = 0; i < itemhandler.getSlots(); ++i) {
                    itemhandler.extractItem(i, Integer.MAX_VALUE, false);
                }
            }
        }
    }

    protected abstract void generateAt(World var1, BlockPos var2, BlockPos var3, PlacementSettings var4, DungeonInhabitant var5, ProtectedRegion var6, BlockPos var7);

    public abstract byte getId();

    public final void writeToByteBuf(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        buf.writeByte((int)this.getId());
        this.writeToByteBufInternal(buf, blockStatePalette, compoundTagList);
    }

    public final void readFromByteBuf(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        byte id = buf.readByte();
        if (id != this.getId()) {
            throw new IllegalArgumentException(String.format("Invalid id to read %s. Expected %d but got %d.", this.getClass().getSimpleName(), this.getId(), (int)id));
        }
        this.readFromByteBufInternal(buf, blockStatePalette, compoundTagList);
    }

    protected abstract void writeToByteBufInternal(ByteBuf var1, BlockStatePalette var2, NBTTagList var3);

    protected abstract void readFromByteBufInternal(ByteBuf var1, BlockStatePalette var2, NBTTagList var3);

    @Nullable
    public static AbstractBlockInfo create(BlockPos pos, ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        return AbstractBlockInfo.create(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), buf, blockStatePalette, compoundTagList);
    }

    @Nullable
    public static AbstractBlockInfo create(int x, int y, int z, ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        AbstractBlockInfo blockInfo;
        byte id = buf.readByte();
        switch (id) {
            case -1: {
                return null;
            }
            case 0: {
                blockInfo = new BlockInfoEmpty(x, y, z);
                break;
            }
            case 1: {
                blockInfo = new BlockInfo(x, y, z);
                break;
            }
            case 2: {
                blockInfo = new BlockInfoBanner(x, y, z);
                break;
            }
            case 3: {
                blockInfo = new BlockInfoBoss(x, y, z);
                break;
            }
            case 4: {
                blockInfo = new BlockInfoForceFieldNexus(x, y, z);
                break;
            }
            case 5: {
                blockInfo = new BlockInfoLootChest(x, y, z);
                break;
            }
            case 6: {
                blockInfo = new BlockInfoSpawner(x, y, z);
                break;
            }
            case 7: {
                blockInfo = new BlockInfoMap(x, y, z);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Can't create AbstractBlockInfo with id %d", id));
            }
        }
        blockInfo.readFromByteBufInternal(buf, blockStatePalette, compoundTagList);
        return blockInfo;
    }

    public BlockPos getPos() {
        return new BlockPos((int)this.x, (int)this.y, (int)this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos getTransformedBlockPos(BlockPos origin, Mirror mirrorIn, Rotation rotationIn) {
        short i = this.x;
        short j = this.y;
        short k = this.z;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return origin.func_177982_a((int)k, (int)j, (int)(-i));
            }
            case CLOCKWISE_90: {
                return origin.func_177982_a((int)(-k), (int)j, (int)i);
            }
            case CLOCKWISE_180: {
                return origin.func_177982_a((int)(-i), (int)j, (int)(-k));
            }
        }
        return origin.func_177982_a((int)i, (int)j, (int)k);
    }

    public BlockPos.MutableBlockPos getTransformedMutableBlockPos(BlockPos origin, Mirror mirrorIn, Rotation rotationIn, BlockPos.MutableBlockPos mutablePos) {
        short i = this.x;
        short j = this.y;
        short k = this.z;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return mutablePos.func_181079_c(origin.func_177958_n() + k, origin.func_177956_o() + j, origin.func_177952_p() - i);
            }
            case CLOCKWISE_90: {
                return mutablePos.func_181079_c(origin.func_177958_n() - k, origin.func_177956_o() + j, origin.func_177952_p() + i);
            }
            case CLOCKWISE_180: {
                return mutablePos.func_181079_c(origin.func_177958_n() - i, origin.func_177956_o() + j, origin.func_177952_p() - k);
            }
        }
        return mutablePos.func_181079_c(origin.func_177958_n() + i, origin.func_177956_o() + j, origin.func_177952_p() + k);
    }

    public BlockPos.PooledMutableBlockPos getTransformedPooledMutableBlockPos(BlockPos origin, Mirror mirrorIn, Rotation rotationIn) {
        short i = this.x;
        short j = this.y;
        short k = this.z;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return BlockPos.PooledMutableBlockPos.func_185339_c((int)(origin.func_177958_n() + k), (int)(origin.func_177956_o() + j), (int)(origin.func_177952_p() - i));
            }
            case CLOCKWISE_90: {
                return BlockPos.PooledMutableBlockPos.func_185339_c((int)(origin.func_177958_n() - k), (int)(origin.func_177956_o() + j), (int)(origin.func_177952_p() + i));
            }
            case CLOCKWISE_180: {
                return BlockPos.PooledMutableBlockPos.func_185339_c((int)(origin.func_177958_n() - i), (int)(origin.func_177956_o() + j), (int)(origin.func_177952_p() - k));
            }
        }
        return BlockPos.PooledMutableBlockPos.func_185339_c((int)(origin.func_177958_n() + i), (int)(origin.func_177956_o() + j), (int)(origin.func_177952_p() + k));
    }

    @Deprecated
    public static AbstractBlockInfo create(int x, int y, int z, NBTTagIntArray nbtTagIntArray, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        if (nbtTagIntArray.func_150302_c().length == 0) {
            return new BlockInfoEmpty(x, y, z);
        }
        switch (nbtTagIntArray.func_150302_c()[0]) {
            case 0: {
                return new BlockInfo(x, y, z, nbtTagIntArray, blockStatePalette, compoundTagList);
            }
            case 1: {
                return new BlockInfoBanner(x, y, z, nbtTagIntArray, blockStatePalette, compoundTagList);
            }
            case 2: {
                return new BlockInfoBoss(x, y, z);
            }
            case 3: {
                return new BlockInfoForceFieldNexus(x, y, z);
            }
            case 4: {
                return new BlockInfoLootChest(x, y, z, nbtTagIntArray);
            }
            case 5: {
                return new BlockInfoSpawner(x, y, z, nbtTagIntArray, blockStatePalette, compoundTagList);
            }
        }
        return new BlockInfoEmpty(x, y, z);
    }
}

