/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.util.BlockPlacingHelper;

public class BlockInfo
extends AbstractBlockInfo {
    protected IBlockState blockstate;
    protected NBTTagCompound tileentityData;

    public BlockInfo(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockInfo(BlockPos pos) {
        super(pos);
    }

    public BlockInfo(int x, int y, int z, IBlockState blockstate, @Nullable NBTTagCompound tileentityData) {
        super(x, y, z);
        this.blockstate = blockstate;
        this.tileentityData = tileentityData;
        if (this.tileentityData != null) {
            this.tileentityData.func_82580_o("x");
            this.tileentityData.func_82580_o("y");
            this.tileentityData.func_82580_o("z");
        }
    }

    public BlockInfo(BlockPos pos, IBlockState blockstate, @Nullable NBTTagCompound tileentityData) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), blockstate, tileentityData);
    }

    @Override
    public void generateAt(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, BlockPos pos) {
        TileEntity tileentity;
        IBlockState iblockstate = this.blockstate.func_185902_a(settings.func_186212_b()).func_185907_a(settings.func_186215_c());
        BlockPlacingHelper.setBlockState(world, pos, iblockstate, 18, false);
        if (this.tileentityData != null && (tileentity = world.func_175625_s(pos)) != null) {
            this.tileentityData.func_74768_a("x", pos.func_177958_n());
            this.tileentityData.func_74768_a("y", pos.func_177956_o());
            this.tileentityData.func_74768_a("z", pos.func_177952_p());
            tileentity.func_145839_a(this.tileentityData);
            this.tileentityData.func_82580_o("x");
            this.tileentityData.func_82580_o("y");
            this.tileentityData.func_82580_o("z");
            tileentity.func_189668_a(settings.func_186212_b());
            tileentity.func_189667_a(settings.func_186215_c());
        }
    }

    @Override
    public byte getId() {
        return 1;
    }

    @Override
    protected void writeToByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        int i = blockStatePalette.idFor(this.blockstate) << 1 | (this.tileentityData != null ? 1 : 0);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)i, (int)5);
        if (this.tileentityData != null) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)compoundTagList.func_74745_c(), (int)5);
            compoundTagList.func_74742_a((NBTBase)this.tileentityData);
        }
    }

    @Override
    protected void readFromByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        int i = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.blockstate = blockStatePalette.stateFor(i >>> 1);
        if ((i & 1) == 1) {
            this.tileentityData = compoundTagList.func_150305_b(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5));
        }
    }

    public IBlockState getBlockstate() {
        return this.blockstate;
    }

    public NBTTagCompound getTileentityData() {
        return this.tileentityData;
    }

    @Deprecated
    public BlockInfo(int x, int y, int z, NBTTagIntArray nbtTagIntArray, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        super(x, y, z);
        int[] ints = nbtTagIntArray.func_150302_c();
        this.blockstate = blockStatePalette.stateFor(ints[1]);
        if (ints.length > 2) {
            this.tileentityData = compoundTagList.func_150305_b(ints[2]);
        }
    }
}

