/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.tileentity.TileEntityBoss;
import team.cqr.cqrepoured.util.BlockPlacingHelper;

public class BlockInfoBoss
extends AbstractBlockInfo {
    private NBTTagCompound bossTag;

    public BlockInfoBoss(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockInfoBoss(BlockPos pos) {
        super(pos);
    }

    public BlockInfoBoss(int x, int y, int z, NBTTagCompound bossTag) {
        this(x, y, z);
        this.bossTag = bossTag;
    }

    public BlockInfoBoss(BlockPos pos, NBTTagCompound bossTag) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), bossTag);
    }

    public BlockInfoBoss(int x, int y, int z, TileEntityBoss tileEntityBoss) {
        this(x, y, z);
        NBTTagCompound stackTag;
        ItemStack stack;
        if (tileEntityBoss.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (stack = ((IItemHandler)tileEntityBoss.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0)).func_77942_o() && (stackTag = stack.func_77978_p()).func_150297_b("EntityIn", 10)) {
            this.bossTag = stackTag.func_74775_l("EntityIn");
        }
    }

    public BlockInfoBoss(BlockPos pos, TileEntityBoss tileEntityBoss) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tileEntityBoss);
    }

    @Override
    public void generateAt(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, BlockPos pos) {
        BlockPlacingHelper.setBlockState(world, pos, Blocks.field_150350_a.func_176223_P(), 18, false);
        if (this.bossTag != null) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)this.bossTag, (World)world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_110163_bv();
                if (entity instanceof AbstractEntityCQR) {
                    ((AbstractEntityCQR)entity).onSpawnFromCQRSpawnerInDungeon(dungeonPos, settings, dungeonMob);
                    ((AbstractEntityCQR)entity).enableBossBar();
                }
            }
            world.func_72838_d(entity);
            if (protectedRegion != null) {
                protectedRegion.addEntityDependency(entity.getPersistentID());
            }
        } else if (dungeonMob.getBossID() != null) {
            Entity entity = EntityList.func_188429_b((ResourceLocation)dungeonMob.getBossID(), (World)world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(pos), null);
                ((EntityLiving)entity).func_110163_bv();
                if (entity instanceof AbstractEntityCQR) {
                    ((AbstractEntityCQR)entity).onSpawnFromCQRSpawnerInDungeon(dungeonPos, settings, dungeonMob);
                    ((AbstractEntityCQR)entity).enableBossBar();
                }
            }
            world.func_72838_d(entity);
            if (protectedRegion != null) {
                protectedRegion.addEntityDependency(entity.getPersistentID());
            }
        } else if (dungeonMob.getEntityID() != null) {
            Entity entity = EntityList.func_188429_b((ResourceLocation)dungeonMob.getEntityID(), (World)world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            entity.func_96094_a("Temporary Boss");
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(pos), null);
                ((EntityLiving)entity).func_110163_bv();
                if (entity instanceof AbstractEntityCQR) {
                    ((AbstractEntityCQR)entity).onSpawnFromCQRSpawnerInDungeon(dungeonPos, settings, dungeonMob);
                    ((AbstractEntityCQR)entity).setSizeVariation(1.1f);
                    ((AbstractEntityCQR)entity).enableBossBar();
                }
                ((EntityLiving)entity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
                ((EntityLiving)entity).func_70606_j(((EntityLiving)entity).func_110138_aP());
                ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(CQRItems.GREAT_SWORD_DIAMOND));
                ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(dungeonMob.getShieldReplacement()));
                ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(CQRItems.HELMET_HEAVY_DIAMOND));
                ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(CQRItems.CHESTPLATE_HEAVY_DIAMOND));
                ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(CQRItems.LEGGINGS_HEAVY_DIAMOND));
                ((EntityLiving)entity).func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(CQRItems.BOOTS_HEAVY_DIAMOND));
            }
            world.func_72838_d(entity);
            if (protectedRegion != null) {
                protectedRegion.addEntityDependency(entity.getPersistentID());
            }
        }
    }

    @Override
    public byte getId() {
        return 3;
    }

    @Override
    protected void writeToByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(this.bossTag != null ? compoundTagList.func_74745_c() << 1 | 1 : 0), (int)5);
        if (this.bossTag != null) {
            compoundTagList.func_74742_a((NBTBase)this.bossTag);
        }
    }

    @Override
    protected void readFromByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        int i = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        if ((i & 1) == 1) {
            this.bossTag = compoundTagList.func_150305_b(i >>> 1);
        }
    }
}

