/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.structuregen.WorldDungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.util.BlockPlacingHelper;

public class BlockInfoLootChest
extends AbstractBlockInfo {
    protected ResourceLocation lootTable = LootTableList.field_186419_a;
    protected EnumFacing facing = EnumFacing.NORTH;

    public BlockInfoLootChest(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockInfoLootChest(BlockPos pos) {
        super(pos);
    }

    public BlockInfoLootChest(int x, int y, int z, ResourceLocation lootTable, EnumFacing facing) {
        super(x, y, z);
        this.lootTable = lootTable;
        this.facing = facing;
    }

    public BlockInfoLootChest(BlockPos pos, ResourceLocation lootTable, EnumFacing facing) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), lootTable, facing);
    }

    @Override
    public void generateAt(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, BlockPos pos) {
        IBlockState iblockstate = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)this.facing).func_185902_a(settings.func_186212_b()).func_185907_a(settings.func_186215_c());
        BlockPlacingHelper.setBlockState(world, pos, iblockstate, 18, false);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityChest) {
            long seed = WorldDungeonGenerator.getSeed(world, pos.func_177958_n(), pos.func_177952_p());
            ((TileEntityChest)tileEntity).func_189404_a(this.lootTable, seed);
        } else {
            CQRMain.logger.warn("Failed to place loot chest at {}", (Object)pos);
        }
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    protected void writeToByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.lootTable.toString());
        buf.writeByte(this.facing.func_176736_b());
    }

    @Override
    protected void readFromByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        this.lootTable = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.facing = EnumFacing.func_176731_b((int)buf.readByte());
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    @Deprecated
    public BlockInfoLootChest(int x, int y, int z, NBTTagIntArray nbtTagIntArray) {
        super(x, y, z);
        int[] ints = nbtTagIntArray.func_150302_c();
        this.lootTable = this.getLootTableFromId(ints[1]);
        this.facing = EnumFacing.func_176731_b((int)ints[2]);
    }

    @Deprecated
    private ResourceLocation getLootTableFromId(int id) {
        switch (id) {
            case 0: {
                return CQRLoottables.CHESTS_FOOD;
            }
            case 1: {
                return CQRLoottables.CHESTS_EQUIPMENT;
            }
            case 2: {
                return CQRLoottables.CHESTS_TREASURE;
            }
            case 3: {
                return CQRLoottables.CHESTS_MATERIAL;
            }
            case 32: {
                return CQRLoottables.CHESTS_CLUTTER;
            }
            case 4: {
                return LootTableList.field_186424_f;
            }
            case 5: {
                return LootTableList.field_186429_k;
            }
            case 6: {
                return LootTableList.field_186421_c;
            }
            case 7: {
                return LootTableList.field_186431_m;
            }
            case 8: {
                return LootTableList.field_186430_l;
            }
            case 9: {
                return LootTableList.field_189420_m;
            }
            case 10: {
                return LootTableList.field_186425_g;
            }
            case 11: {
                return LootTableList.field_186420_b;
            }
            case 12: {
                return LootTableList.field_186428_j;
            }
            case 13: {
                return LootTableList.field_186427_i;
            }
            case 14: {
                return LootTableList.field_186426_h;
            }
            case 15: {
                return LootTableList.field_186423_e;
            }
            case 16: {
                return LootTableList.field_191192_o;
            }
            case 17: {
                return LootTableList.field_186422_d;
            }
        }
        if (id >= 18 && id <= 31) {
            return new ResourceLocation("cqrepoured", "chests/custom_" + (id - 17));
        }
        CQRMain.logger.warn("Failed to read loottable for id {}!", (Object)id);
        return CQRLoottables.CHESTS_FOOD;
    }
}

