/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.tileentity.TileEntityMap;
import team.cqr.cqrepoured.util.BlockPlacingHelper;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class BlockInfoMap
extends AbstractBlockInfo {
    private EnumFacing facing = EnumFacing.NORTH;
    private int scale = 0;
    private EnumFacing orientation = EnumFacing.NORTH;
    private boolean lockOrientation = false;
    private int originX = 0;
    private int originZ = 0;
    private int offsetX = 0;
    private int offsetZ = 0;
    private boolean fillMap = false;
    private int fillRadius = 256;

    public BlockInfoMap(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockInfoMap(BlockPos pos) {
        super(pos);
    }

    public BlockInfoMap(int x, int y, int z, EnumFacing facing, int scale, EnumFacing orientation, boolean lockOrientation, int originX, int originZ, int offsetX, int offsetZ, boolean fillMap, int fillRadius) {
        super(x, y, z);
        this.facing = facing;
        this.scale = scale;
        this.orientation = orientation;
        this.lockOrientation = lockOrientation;
        this.originX = originX;
        this.originZ = originZ;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
        this.fillMap = fillMap;
        this.fillRadius = fillRadius;
    }

    public BlockInfoMap(BlockPos pos, EnumFacing facing, int scale, EnumFacing orientation, boolean lockOrientation, int originX, int originZ, int offsetX, int offsetZ, boolean fillMap, int fillRadius) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing, scale, orientation, lockOrientation, originX, originZ, offsetX, offsetZ, fillMap, fillRadius);
    }

    public BlockInfoMap(int x, int y, int z, EnumFacing facing, TileEntityMap tileEntity) {
        this(x, y, z, facing, tileEntity.getScale(), tileEntity.getOrientation(), tileEntity.lockOrientation(), tileEntity.getOriginX(), tileEntity.getOriginZ(), tileEntity.getOffsetX(), tileEntity.getOffsetZ(), tileEntity.fillMap(), tileEntity.getFillRadius());
    }

    public BlockInfoMap(BlockPos pos, EnumFacing facing, TileEntityMap tileEntity) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), facing, tileEntity);
    }

    @Override
    public void generateAt(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, BlockPos pos) {
        BlockPlacingHelper.setBlockState(world, pos, Blocks.field_150350_a.func_176223_P(), 18, false);
        EnumFacing transformedFacing = settings.func_186215_c().func_185831_a(settings.func_186212_b().func_185803_b(this.facing));
        EntityItemFrame entity = new EntityItemFrame(world, pos.func_185334_h(), transformedFacing);
        if (!this.lockOrientation) {
            switch (this.orientation) {
                case EAST: {
                    entity.func_82336_g(entity.func_82333_j() + 3);
                    break;
                }
                case SOUTH: {
                    entity.func_82336_g(entity.func_82333_j() + 2);
                    break;
                }
                case WEST: {
                    entity.func_82336_g(entity.func_82333_j() + 1);
                    break;
                }
            }
        }
        int x1 = this.offsetX * (128 << this.scale);
        int z1 = this.offsetZ * (128 << this.scale);
        int x2 = this.originX;
        int z2 = this.originZ;
        switch (settings.func_186212_b()) {
            case LEFT_RIGHT: {
                entity.func_82336_g(entity.func_82333_j() + 2);
                z1 = -z1;
                z2 = -z2;
                break;
            }
            case FRONT_BACK: {
                x1 = -x1;
                x2 = -x2;
                break;
            }
        }
        int x3 = x1;
        int z3 = z1;
        int x4 = x2;
        int z4 = z2;
        switch (settings.func_186215_c()) {
            case COUNTERCLOCKWISE_90: {
                entity.func_82336_g(entity.func_82333_j() + 1);
                x1 = z3;
                z1 = -x3;
                x2 = z4;
                z2 = -x4;
                break;
            }
            case CLOCKWISE_90: {
                entity.func_82336_g(entity.func_82333_j() + 3);
                x1 = -z3;
                z1 = x3;
                x2 = -z4;
                z2 = x4;
                break;
            }
            case CLOCKWISE_180: {
                entity.func_82336_g(entity.func_82333_j() + 2);
                x1 = -x3;
                z1 = -z3;
                x2 = -x4;
                z2 = -z4;
                break;
            }
        }
        ItemStack stack = ItemMap.func_190906_a((World)world, (double)(pos.func_177958_n() + x1 + x2), (double)(pos.func_177952_p() + z1 + z2), (byte)((byte)this.scale), (boolean)true, (boolean)true);
        if (this.fillMap) {
            BlockInfoMap.updateMapData(world, pos.func_177958_n() + x1 + x2, pos.func_177952_p() + z1 + z2, this.fillRadius, ((ItemMap)stack.func_77973_b()).func_77873_a(stack, world));
        }
        entity.func_82334_a(stack);
        world.func_72838_d((Entity)entity);
    }

    @Override
    public byte getId() {
        return 7;
    }

    @Override
    protected void writeToByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("facing", (byte)this.facing.func_176736_b());
        compound.func_74774_a("scale", (byte)this.scale);
        compound.func_74774_a("orientation", (byte)this.orientation.func_176736_b());
        compound.func_74757_a("lockOrientation", this.lockOrientation);
        compound.func_74774_a("originX", (byte)this.originX);
        compound.func_74774_a("originZ", (byte)this.originZ);
        compound.func_74774_a("offsetX", (byte)this.offsetX);
        compound.func_74774_a("offsetZ", (byte)this.offsetZ);
        compound.func_74757_a("fillMap", this.fillMap);
        compound.func_74777_a("fillRadius", (short)this.fillRadius);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)compoundTagList.func_74745_c(), (int)5);
        compoundTagList.func_74742_a((NBTBase)compound);
    }

    @Override
    protected void readFromByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        NBTTagCompound compound = compoundTagList.func_150305_b(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5));
        this.facing = EnumFacing.func_176731_b((int)compound.func_74762_e("facing"));
        this.scale = compound.func_74771_c("scale");
        this.orientation = EnumFacing.func_176731_b((int)compound.func_74762_e("orientation"));
        this.lockOrientation = compound.func_74767_n("lockOrientation");
        this.originX = compound.func_74771_c("originX");
        this.originZ = compound.func_74771_c("originZ");
        this.offsetX = compound.func_74771_c("offsetX");
        this.offsetZ = compound.func_74771_c("offsetZ");
        this.fillMap = compound.func_74767_n("fillMap");
        this.fillRadius = compound.func_74765_d("fillRadius");
    }

    private static void updateMapData(World worldIn, int x, int z, int radius, MapData data) {
        if (worldIn.field_73011_w.getDimension() == data.field_76200_c) {
            int scale = 1 << data.field_76197_d;
            int xCenter = data.field_76201_a;
            int zCenter = data.field_76199_b;
            HashMultiset multiset = HashMultiset.create();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int k1 = 0; k1 < 128; ++k1) {
                double d0 = 0.0;
                for (int l1 = -1; l1 < 128; ++l1) {
                    byte b1;
                    byte b0;
                    MapColor mapcolor;
                    int k2 = xCenter + (k1 - 64) * scale;
                    int l2 = zCenter + (l1 - 64) * scale;
                    multiset.clear();
                    Chunk chunk = worldIn.func_72964_e(k2 >> 4, l2 >> 4);
                    if (chunk.func_76621_g()) continue;
                    int i3 = k2 & 0xF;
                    int j3 = l2 & 0xF;
                    int k3 = 0;
                    double d1 = 0.0;
                    if (worldIn.field_73011_w.func_177495_o()) {
                        int l3 = k2 + l2 * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT).func_185909_g((IBlockAccess)worldIn, BlockPos.field_177992_a), 10);
                        } else {
                            multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE).func_185909_g((IBlockAccess)worldIn, BlockPos.field_177992_a), 100);
                        }
                        d1 = 100.0;
                    } else {
                        for (int i4 = 0; i4 < scale; ++i4) {
                            for (int j4 = 0; j4 < scale; ++j4) {
                                int k4 = chunk.func_76611_b(i4 + i3, j4 + j3) + 1;
                                IBlockState iblockstate = Blocks.field_150350_a.func_176223_P();
                                if (k4 <= 1) {
                                    iblockstate = Blocks.field_150357_h.func_176223_P();
                                } else {
                                    do {
                                        iblockstate = chunk.func_186032_a(i4 + i3, --k4, j4 + j3);
                                        mutablePos.func_181079_c((chunk.field_76635_g << 4) + i4 + i3, k4, (chunk.field_76647_h << 4) + j4 + j3);
                                    } while (iblockstate.func_185909_g((IBlockAccess)worldIn, (BlockPos)mutablePos) == MapColor.field_151660_b && k4 > 0);
                                    if (k4 > 0 && iblockstate.func_185904_a().func_76224_d()) {
                                        IBlockState iblockstate1;
                                        int l4 = k4 - 1;
                                        do {
                                            iblockstate1 = chunk.func_186032_a(i4 + i3, l4--, j4 + j3);
                                            ++k3;
                                        } while (l4 > 0 && iblockstate1.func_185904_a().func_76224_d());
                                    }
                                }
                                d1 += (double)k4 / (double)(scale * scale);
                                multiset.add((Object)iblockstate.func_185909_g((IBlockAccess)worldIn, (BlockPos)mutablePos));
                            }
                        }
                    }
                    k3 /= scale * scale;
                    double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(k1 + l1 & 1) - 0.5) * 0.4;
                    int i5 = 1;
                    if (d2 > 0.6) {
                        i5 = 2;
                    }
                    if (d2 < -0.6) {
                        i5 = 0;
                    }
                    if ((mapcolor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.field_151660_b)) == MapColor.field_151662_n) {
                        d2 = (double)k3 * 0.1 + (double)(k1 + l1 & 1) * 0.2;
                        i5 = 1;
                        if (d2 < 0.5) {
                            i5 = 2;
                        }
                        if (d2 > 0.9) {
                            i5 = 0;
                        }
                    }
                    d0 = d1;
                    if (l1 < 0 || !DungeonGenUtils.isInsideCircle(k2 - x, l2 - z, radius) || (b0 = data.field_76198_e[k1 + l1 * 128]) == (b1 = (byte)(mapcolor.field_76290_q * 4 + i5))) continue;
                    data.field_76198_e[k1 + l1 * 128] = b1;
                    data.func_176053_a(k1, l1);
                }
            }
        }
    }
}

