/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.factories.SpawnerFactory;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.tileentity.TileEntitySpawner;
import team.cqr.cqrepoured.util.BlockPlacingHelper;
import team.cqr.cqrepoured.util.CQRConfig;

public class BlockInfoSpawner
extends AbstractBlockInfo {
    protected NBTTagCompound tileentityData;

    public BlockInfoSpawner(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockInfoSpawner(BlockPos pos) {
        super(pos);
    }

    public BlockInfoSpawner(int x, int y, int z, NBTTagCompound tileentityData) {
        super(x, y, z);
        this.tileentityData = tileentityData;
    }

    public BlockInfoSpawner(BlockPos pos, NBTTagCompound tileentityData) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tileentityData);
    }

    public BlockInfoSpawner(int x, int y, int z, Entity ... entities) {
        this(x, y, z, BlockInfoSpawner.getNBTTagCompoundFromEntityList(entities));
    }

    public BlockInfoSpawner(BlockPos pos, Entity ... entities) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BlockInfoSpawner.getNBTTagCompoundFromEntityList(entities));
    }

    public BlockInfoSpawner(int x, int y, int z, List<Entity> entityList) {
        this(x, y, z, BlockInfoSpawner.getNBTTagCompoundFromEntityList(entityList.toArray(new Entity[entityList.size()])));
    }

    public BlockInfoSpawner(BlockPos pos, List<Entity> entityList) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), BlockInfoSpawner.getNBTTagCompoundFromEntityList(entityList.toArray(new Entity[entityList.size()])));
    }

    @Override
    public void generateAt(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, BlockPos pos) {
        if (this.tileentityData == null) {
            BlockPlacingHelper.setBlockState(world, pos, Blocks.field_150350_a.func_176223_P(), 18, false);
        } else if (this.tileentityData.func_74767_n("vanillaSpawner")) {
            BlockPlacingHelper.setBlockState(world, pos, Blocks.field_150474_ac.func_176223_P(), 18, false);
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof TileEntityMobSpawner) {
                this.vanillaSpawnerReadFromNBT(world, dungeonPos, dungeonPartPos, settings, dungeonMob, protectedRegion, (TileEntityMobSpawner)tileentity, this.tileentityData);
            } else {
                CQRMain.logger.warn("Failed to place vanilla spawner at {}", (Object)pos);
            }
        } else {
            BlockPlacingHelper.setBlockState(world, pos, CQRBlocks.SPAWNER.func_176223_P(), 18, false);
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof TileEntitySpawner) {
                this.cqrSpawnerReadFromNBT(world, dungeonPos, dungeonPartPos, settings, dungeonMob, protectedRegion, (TileEntitySpawner)tileentity, this.tileentityData);
            } else {
                CQRMain.logger.warn("Failed to place cqr spawner at {}", (Object)pos);
            }
        }
    }

    @Override
    public byte getId() {
        return 6;
    }

    @Override
    protected void writeToByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)compoundTagList.func_74745_c(), (int)5);
        compoundTagList.func_74742_a((NBTBase)this.tileentityData);
    }

    @Override
    protected void readFromByteBufInternal(ByteBuf buf, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        this.tileentityData = compoundTagList.func_150305_b(ByteBufUtils.readVarInt((ByteBuf)buf, (int)5));
    }

    public NBTTagCompound getTileentityData() {
        return this.tileentityData;
    }

    private static NBTTagCompound getNBTTagCompoundFromEntityList(Entity ... entities) {
        TileEntitySpawner tileEntitySpawner = new TileEntitySpawner();
        for (int i = 0; i < entities.length && i < tileEntitySpawner.inventory.getSlots(); ++i) {
            if (entities[i] == null) continue;
            tileEntitySpawner.inventory.setStackInSlot(i, SpawnerFactory.getSoulBottleItemStackForEntity(entities[i]));
        }
        return tileEntitySpawner.func_189515_b(new NBTTagCompound());
    }

    private void vanillaSpawnerReadFromNBT(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, TileEntityMobSpawner tileEntityMobSpawner, NBTTagCompound tileentityData) {
        MobSpawnerBaseLogic spawnerBaseLogic = tileEntityMobSpawner.func_145881_a();
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("Delay", (short)20);
        if (tileentityData.func_150297_b("MinSpawnDelay", 99)) {
            compound.func_74777_a("MinSpawnDelay", tileentityData.func_74765_d("MinSpawnDelay"));
            compound.func_74777_a("MaxSpawnDelay", tileentityData.func_74765_d("MaxSpawnDelay"));
            compound.func_74777_a("SpawnCount", tileentityData.func_74765_d("SpawnCount"));
        }
        if (tileentityData.func_150297_b("MaxNearbyEntities", 99)) {
            compound.func_74777_a("MaxNearbyEntities", tileentityData.func_74765_d("MaxNearbyEntities"));
            compound.func_74777_a("RequiredPlayerRange", tileentityData.func_74765_d("RequiredPlayerRange"));
        }
        if (tileentityData.func_150297_b("SpawnRange", 99)) {
            compound.func_74777_a("SpawnRange", tileentityData.func_74765_d("SpawnRange"));
        }
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagList items = tileentityData.func_74775_l("inventory").func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            NBTTagCompound entityTag = itemTag.func_74775_l("tag").func_74775_l("EntityIn");
            Entity entity = this.createEntityFromTag(world, dungeonPos, dungeonPartPos, settings, dungeonMob, protectedRegion, entityTag);
            if (entity == null) continue;
            NBTTagCompound newEntityTag = new NBTTagCompound();
            entity.func_184198_c(newEntityTag);
            newEntityTag.func_82580_o("UUIDLeast");
            newEntityTag.func_82580_o("UUIDMost");
            newEntityTag.func_82580_o("Pos");
            if (nbttaglist.func_82582_d()) {
                compound.func_74782_a("SpawnData", (NBTBase)newEntityTag);
            }
            nbttaglist.func_74742_a((NBTBase)new WeightedSpawnerEntity((int)itemTag.func_74771_c("Count"), newEntityTag).func_185278_a());
        }
        compound.func_74782_a("SpawnPotentials", (NBTBase)nbttaglist);
        spawnerBaseLogic.func_98270_a(compound);
    }

    private void cqrSpawnerReadFromNBT(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, TileEntitySpawner tileEntitySpawner, NBTTagCompound tileentityData) {
        NBTTagList items = tileentityData.func_74775_l("inventory").func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c() && i < tileEntitySpawner.inventory.getSlots(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            NBTTagCompound entityTag = itemTag.func_74775_l("tag").func_74775_l("EntityIn");
            Entity entity = this.createEntityFromTag(world, dungeonPos, dungeonPartPos, settings, dungeonMob, protectedRegion, entityTag);
            if (entity == null) continue;
            NBTTagCompound newEntityTag = new NBTTagCompound();
            entity.func_184198_c(newEntityTag);
            newEntityTag.func_82580_o("UUIDLeast");
            newEntityTag.func_82580_o("UUIDMost");
            newEntityTag.func_82580_o("Pos");
            ItemStack stack = new ItemStack(CQRItems.SOUL_BOTTLE, (int)itemTag.func_74771_c("Count"));
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74782_a("EntityIn", (NBTBase)newEntityTag);
            stack.func_77982_d(stackTag);
            tileEntitySpawner.inventory.insertItem(i, stack, false);
        }
    }

    private Entity createEntityFromTag(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion, NBTTagCompound entityTag) {
        if (entityTag.func_82582_d()) {
            return null;
        }
        entityTag.func_82580_o("UUIDLeast");
        entityTag.func_82580_o("UUIDMost");
        entityTag.func_82580_o("Pos");
        String id = entityTag.func_74779_i("id");
        if (id.equals("cqrepoured:dummy")) {
            entityTag.func_74778_a("id", dungeonMob.getEntityID().toString());
        }
        Entity entity = EntityList.func_75615_a((NBTTagCompound)entityTag, (World)world);
        entityTag.func_74778_a("id", id);
        if (entity != null) {
            BlockPos pos = this.getTransformedBlockPos(dungeonPartPos, settings.func_186212_b(), settings.func_186215_c());
            entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p());
            if (entity instanceof EntityLiving) {
                if (CQRConfig.general.mobsFromCQSpawnerDontDespawn) {
                    ((EntityLiving)entity).func_110163_bv();
                }
                if (entity instanceof AbstractEntityCQR) {
                    ((AbstractEntityCQR)entity).onSpawnFromCQRSpawnerInDungeon(dungeonPos, settings, dungeonMob);
                }
            }
            NBTTagList passengers = entityTag.func_150295_c("Passengers", 10);
            for (NBTBase passengerNBT : passengers) {
                Entity passenger = this.createEntityFromTag(world, dungeonPos, dungeonPartPos, settings, dungeonMob, protectedRegion, (NBTTagCompound)passengerNBT);
                passenger.func_184220_m(entity);
            }
        }
        return entity;
    }

    @Deprecated
    public BlockInfoSpawner(int x, int y, int z, NBTTagIntArray nbtTagIntArray, BlockStatePalette blockStatePalette, NBTTagList compoundTagList) {
        super(x, y, z);
        int[] ints = nbtTagIntArray.func_150302_c();
        if (ints.length > 2) {
            this.tileentityData = compoundTagList.func_150305_b(ints[2]);
        }
    }
}

