/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTHelper;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.objects.banners.BannerHelper;
import team.cqr.cqrepoured.objects.blocks.BlockExporterChest;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartEntity;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoBanner;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoBoss;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoEmpty;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoForceFieldNexus;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoLootChest;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoMap;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoSpawner;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structuregen.structurefile.EntityInfo;
import team.cqr.cqrepoured.tileentity.TileEntityMap;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.ChunkUtil;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class CQStructure {
    public static final Comparator<AbstractBlockInfo> SORT_FOR_EXPORTATION = (b1, b2) -> {
        if (b1.getX() < b2.getX()) {
            return -1;
        }
        if (b1.getX() > b2.getX()) {
            return 1;
        }
        if (b1.getY() < b2.getY()) {
            return -1;
        }
        if (b1.getY() > b2.getY()) {
            return 1;
        }
        if (b1.getZ() < b2.getZ()) {
            return -1;
        }
        if (b1.getZ() > b2.getZ()) {
            return 1;
        }
        return 0;
    };
    public static final Comparator<AbstractBlockInfo> SORT_FOR_GENERATION = (blockInfo1, blockInfo2) -> {
        boolean isNormalBlock2;
        boolean isNormalBlock1 = blockInfo1.getClass() == BlockInfo.class;
        boolean bl = isNormalBlock2 = blockInfo2.getClass() == BlockInfo.class;
        if (isNormalBlock1 && isNormalBlock2) {
            boolean hasSpecialShape2;
            boolean hasTileEntity1 = ((BlockInfo)blockInfo1).tileentityData != null;
            boolean hasTileEntity2 = ((BlockInfo)blockInfo2).tileentityData != null;
            boolean hasSpecialShape1 = !((BlockInfo)blockInfo1).blockstate.func_185913_b() && !((BlockInfo)blockInfo1).blockstate.func_185917_h();
            boolean bl2 = hasSpecialShape2 = !((BlockInfo)blockInfo2).blockstate.func_185913_b() && !((BlockInfo)blockInfo2).blockstate.func_185917_h();
            if (hasTileEntity1 == hasTileEntity2 && hasSpecialShape1 == hasSpecialShape2) {
                return 0;
            }
            if (!hasTileEntity1 && !hasSpecialShape1 && (hasTileEntity2 || hasSpecialShape2)) {
                return -1;
            }
            if ((hasTileEntity1 || hasSpecialShape1) && !hasTileEntity2 && !hasSpecialShape2) {
                return 1;
            }
            if (!hasTileEntity1 && hasTileEntity2) {
                return -1;
            }
            if (hasTileEntity1 && !hasTileEntity2) {
                return 1;
            }
            if (!hasSpecialShape1 && hasSpecialShape2) {
                return -1;
            }
            if (hasSpecialShape1 && !hasSpecialShape2) {
                return 1;
            }
        } else {
            if (isNormalBlock1 && !isNormalBlock2) {
                return -1;
            }
            if (!isNormalBlock1 && isNormalBlock2) {
                return 1;
            }
        }
        return 0;
    };
    private static final Map<File, CQStructure> CACHED_STRUCTURES = new HashMap<File, CQStructure>();
    public static final String CQR_FILE_VERSION = "1.2.0";
    private static final Set<Block> SPECIAL_BLOCKS = new HashSet<Block>();
    private static final Set<ResourceLocation> SPECIAL_ENTITIES = new HashSet<ResourceLocation>();
    private final List<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
    private final List<AbstractBlockInfo> specialBlockInfoList = new ArrayList<AbstractBlockInfo>();
    private final List<EntityInfo> entityInfoList = new ArrayList<EntityInfo>();
    private final IntList unprotectedBlockList = new IntArrayList();
    private BlockPos size = BlockPos.field_177992_a;
    private String author = "";

    private CQStructure() {
    }

    public static void cacheFiles() {
        CACHED_STRUCTURES.clear();
        if (!CQRConfig.advanced.cacheStructureFiles) {
            return;
        }
        ArrayList fileList = new ArrayList(FileUtils.listFiles((File)CQRMain.CQ_STRUCTURE_FILES_FOLDER, (String[])new String[]{"nbt"}, (boolean)true));
        fileList.sort((file1, file2) -> {
            if (file1.length() > file2.length()) {
                return -1;
            }
            if (file1.length() < file2.length()) {
                return 1;
            }
            return 0;
        });
        long fileSizeSum = 0L;
        for (int i = 0; i < fileList.size() && i < CQRConfig.advanced.cachedStructureFilesMaxAmount; ++i) {
            File file = (File)fileList.get(i);
            long fileSize = file.length();
            if (fileSizeSum + fileSize >= (long)(CQRConfig.advanced.cachedStructureFilesMaxSize * 1000)) continue;
            CACHED_STRUCTURES.put(file, CQStructure.createFromFile(file));
            fileSizeSum += fileSize;
        }
    }

    public static void clearCache() {
        CACHED_STRUCTURES.clear();
    }

    public static CQStructure createFromFile(File file) {
        if (CACHED_STRUCTURES.containsKey(file)) {
            return CACHED_STRUCTURES.get(file);
        }
        CQStructure structure = new CQStructure();
        structure.readFromFile(file);
        return structure;
    }

    public static CQStructure createFromWorld(World world, BlockPos startPos, BlockPos endPos, boolean ignoreBasicEntities, Collection<BlockPos> unprotectedBlocks, String author) {
        CQStructure structure = new CQStructure();
        structure.author = author;
        structure.takeBlocksAndEntitiesFromWorld(world, startPos, endPos, ignoreBasicEntities, unprotectedBlocks);
        return structure;
    }

    public boolean isEmpty() {
        return this.blockInfoList.isEmpty() && this.specialBlockInfoList.isEmpty() && this.entityInfoList.isEmpty();
    }

    public boolean writeToFile(File file) {
        try {
            if (file.isDirectory()) {
                throw new FileNotFoundException();
            }
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(), (OutputStream)outputStream);
            }
            return true;
        }
        catch (Exception e) {
            CQRMain.logger.error(String.format("Failed to write structure to file %s", file.getName()), (Throwable)e);
            return false;
        }
    }

    private boolean readFromFile(File file) {
        try {
            try (FileInputStream inputStream = new FileInputStream(file);){
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)inputStream));
            }
            return true;
        }
        catch (Exception e) {
            CQRMain.logger.error(String.format("Failed to read structure from file %s", file.getName()), (Throwable)e);
            return false;
        }
    }

    private NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("cqr_file_version", CQR_FILE_VERSION);
        compound.func_74778_a("author", this.author);
        compound.func_74782_a("size", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.size));
        BlockStatePalette blockStatePalette = new BlockStatePalette();
        NBTTagList compoundTagList = new NBTTagList();
        ByteBuf buf = Unpooled.buffer((int)(this.blockInfoList.size() * 2));
        for (AbstractBlockInfo abstractBlockInfo : this.blockInfoList) {
            abstractBlockInfo.writeToByteBuf(buf, blockStatePalette, compoundTagList);
        }
        compound.func_74782_a("blockInfoList", (NBTBase)new NBTTagByteArray(Arrays.copyOf(buf.array(), buf.writerIndex())));
        buf.clear();
        buf.writeInt(this.specialBlockInfoList.size());
        for (AbstractBlockInfo abstractBlockInfo : this.specialBlockInfoList) {
            buf.writeShort(abstractBlockInfo.getX());
            buf.writeShort(abstractBlockInfo.getY());
            buf.writeShort(abstractBlockInfo.getZ());
            abstractBlockInfo.writeToByteBuf(buf, blockStatePalette, compoundTagList);
        }
        compound.func_74782_a("specialBlockInfoList", (NBTBase)new NBTTagByteArray(Arrays.copyOf(buf.array(), buf.writerIndex())));
        NBTTagList nbtTagList3 = new NBTTagList();
        for (EntityInfo entityInfo : this.entityInfoList) {
            nbtTagList3.func_74742_a((NBTBase)entityInfo.getEntityData());
        }
        compound.func_74782_a("entityInfoList", (NBTBase)nbtTagList3);
        NBTTagList nBTTagList = new NBTTagList();
        for (IBlockState state : blockStatePalette) {
            nBTTagList.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)state));
        }
        compound.func_74782_a("palette", (NBTBase)nBTTagList);
        compound.func_74782_a("compoundTagList", (NBTBase)compoundTagList);
        compound.func_74782_a("unprotectedBlockList", (NBTBase)new NBTTagIntArray(this.unprotectedBlockList.toIntArray()));
        return compound;
    }

    private void readFromNBT(NBTTagCompound compound) {
        String cqrFileVersion = compound.func_74779_i("cqr_file_version");
        if (!cqrFileVersion.equals(CQR_FILE_VERSION)) {
            if (cqrFileVersion.equals("1.1.0")) {
                CQRMain.logger.warn("Structure nbt is deprecated! Expected {} but got {}.", (Object)CQR_FILE_VERSION, (Object)cqrFileVersion);
                this.readFromDeprecatedNBT(compound);
                return;
            }
            throw new IllegalArgumentException(String.format("Structure nbt is too old! Expected %s but got %s.", CQR_FILE_VERSION, cqrFileVersion));
        }
        this.author = compound.func_74779_i("author");
        this.size = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("size"));
        this.blockInfoList.clear();
        this.specialBlockInfoList.clear();
        this.entityInfoList.clear();
        BlockStatePalette blockStatePalette = new BlockStatePalette();
        NBTTagList compoundTagList = compound.func_150295_c("compoundTagList", 10);
        int blockStateIndex = 0;
        for (NBTBase nbt : compound.func_150295_c("palette", 10)) {
            blockStatePalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)nbt)), blockStateIndex++);
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("blockInfoList"));
        for (int x = 0; x < this.size.func_177958_n(); ++x) {
            for (int y = 0; y < this.size.func_177956_o(); ++y) {
                for (int z = 0; z < this.size.func_177952_p(); ++z) {
                    AbstractBlockInfo blockInfo = AbstractBlockInfo.create(x, y, z, buf, blockStatePalette, compoundTagList);
                    if (blockInfo == null) continue;
                    this.blockInfoList.add(blockInfo);
                }
            }
        }
        buf = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("specialBlockInfoList"));
        int specialBlockCount = buf.readInt();
        for (int i = 0; i < specialBlockCount; ++i) {
            short x = buf.readShort();
            short y = buf.readShort();
            short z = buf.readShort();
            this.specialBlockInfoList.add(AbstractBlockInfo.create((int)x, (int)y, (int)z, buf, blockStatePalette, compoundTagList));
        }
        for (NBTBase nbt : compound.func_150295_c("entityInfoList", 10)) {
            this.entityInfoList.add(new EntityInfo((NBTTagCompound)nbt));
        }
        this.unprotectedBlockList.clear();
        this.unprotectedBlockList.addElements(0, compound.func_74759_k("unprotectedBlockList"));
    }

    private void takeBlocksAndEntitiesFromWorld(World world, BlockPos startPos, BlockPos endPos, boolean ignoreBasicEntities, Collection<BlockPos> unprotectedBlocks) {
        BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
        BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
        this.size = pos2.func_177973_b((Vec3i)pos1).func_177982_a(1, 1, 1);
        ForgeChunkManager.Ticket chunkTicket = ChunkUtil.getTicket(world, pos1, pos2, true);
        this.takeBlocksFromWorld(world, pos1, pos2);
        this.takeEntitiesFromWorld(world, pos1, pos2, ignoreBasicEntities);
        if (chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)chunkTicket);
        }
        this.unprotectedBlockList.clear();
        for (BlockPos pos : unprotectedBlocks) {
            if (pos.func_177958_n() < pos1.func_177958_n() && pos.func_177956_o() < pos1.func_177956_o() && pos.func_177952_p() < pos1.func_177952_p() || pos.func_177958_n() > pos2.func_177958_n() && pos.func_177956_o() > pos2.func_177956_o() && pos.func_177952_p() > pos2.func_177952_p()) continue;
            this.unprotectedBlockList.add((pos.func_177958_n() - pos1.func_177958_n() & 0xFFF) << 20 | (pos.func_177956_o() - pos1.func_177956_o() & 0xFF) << 12 | pos.func_177952_p() - pos1.func_177952_p() & 0xFFF);
        }
    }

    private void takeBlocksFromWorld(World world, BlockPos pos1, BlockPos pos2) {
        this.blockInfoList.clear();
        this.specialBlockInfoList.clear();
        for (BlockPos.MutableBlockPos mutablePos : BlockPos.func_177975_b((BlockPos)pos1, (BlockPos)pos2)) {
            IBlockState state = world.func_180495_p((BlockPos)mutablePos);
            Block block = state.func_177230_c();
            if (block == Blocks.field_180401_cv || block instanceof BlockCommandBlock || block == Blocks.field_185779_df || block == CQRBlocks.EXPORTER) {
                CQRMain.logger.warn("Exporting unexpected block: {} from {}", (Object)block, (Object)mutablePos);
            }
            BlockPos pos = mutablePos.func_177973_b((Vec3i)pos1);
            TileEntity tileEntity = world.func_175625_s((BlockPos)mutablePos);
            if (block == Blocks.field_189881_dj || block == CQRBlocks.NULL_BLOCK) {
                this.blockInfoList.add(new BlockInfoEmpty(pos));
                continue;
            }
            if (SPECIAL_BLOCKS.contains(block)) {
                this.blockInfoList.add(new BlockInfoEmpty(pos));
                this.specialBlockInfoList.add(new BlockInfo(pos, state, this.writeTileEntityToNBT(tileEntity)));
                continue;
            }
            if ((block == Blocks.field_180393_cK || block == Blocks.field_180394_cL) && tileEntity instanceof TileEntityBanner && BannerHelper.isCQBanner((TileEntityBanner)tileEntity)) {
                this.blockInfoList.add(new BlockInfoBanner(pos, state, this.writeTileEntityToNBT(tileEntity)));
                continue;
            }
            if (block == CQRBlocks.SPAWNER) {
                this.blockInfoList.add(new BlockInfoSpawner(pos, this.writeTileEntityToNBT(tileEntity)));
                continue;
            }
            if (block instanceof BlockExporterChest) {
                this.blockInfoList.add(new BlockInfoLootChest(pos, ((BlockExporterChest)block).getLootTable(world, (BlockPos)mutablePos), (EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a)));
                continue;
            }
            if (block == CQRBlocks.FORCE_FIELD_NEXUS) {
                this.blockInfoList.add(new BlockInfoForceFieldNexus(pos));
                continue;
            }
            if (block == CQRBlocks.BOSS_BLOCK) {
                this.blockInfoList.add(new BlockInfoBoss(pos));
                continue;
            }
            if (block == CQRBlocks.MAP_PLACEHOLDER) {
                this.blockInfoList.add(new BlockInfoMap(pos, (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D), (TileEntityMap)tileEntity));
                continue;
            }
            this.blockInfoList.add(new BlockInfo(pos, state, this.writeTileEntityToNBT(tileEntity)));
        }
        this.blockInfoList.sort(SORT_FOR_EXPORTATION);
    }

    private NBTTagCompound writeTileEntityToNBT(@Nullable TileEntity tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound compound = tileEntity.func_189515_b(new NBTTagCompound());
        compound.func_82580_o("x");
        compound.func_82580_o("y");
        compound.func_82580_o("z");
        return compound;
    }

    private void takeEntitiesFromWorld(World world, BlockPos pos1, BlockPos pos2, boolean ignoreBasicEntities) {
        this.entityInfoList.clear();
        for (Entity entity : world.func_175647_a(Entity.class, new AxisAlignedBB(pos1, pos2.func_177982_a(1, 1, 1)), input -> !(input instanceof EntityPlayer))) {
            if (ignoreBasicEntities && !SPECIAL_ENTITIES.contains(EntityList.func_191301_a((Entity)entity))) continue;
            this.entityInfoList.add(new EntityInfo(pos1, entity));
        }
    }

    public List<AbstractBlockInfo> getBlockInfoList() {
        return Collections.unmodifiableList(this.blockInfoList);
    }

    public List<AbstractBlockInfo> getSpecialBlockInfoList() {
        return Collections.unmodifiableList(this.specialBlockInfoList);
    }

    public List<EntityInfo> getEntityInfoList() {
        return Collections.unmodifiableList(this.entityInfoList);
    }

    public IntList getUnprotectedBlockList() {
        return IntLists.unmodifiable((IntList)this.unprotectedBlockList);
    }

    public BlockPos getSize() {
        return this.size;
    }

    public String getAuthor() {
        return this.author;
    }

    public void addAll(World world, DungeonGenerator dungeonGenerator, BlockPos partPos, PlacementSettings settings, DungeonInhabitant dungeonMobType) {
        dungeonGenerator.add(new DungeonPartBlock(world, dungeonGenerator, partPos, this.getBlockInfoList(), settings, dungeonMobType));
        dungeonGenerator.add(new DungeonPartBlock(world, dungeonGenerator, partPos, this.getSpecialBlockInfoList(), settings, dungeonMobType));
        dungeonGenerator.add(new DungeonPartEntity(world, dungeonGenerator, partPos, this.getEntityInfoList(), settings, dungeonMobType));
        if (!this.unprotectedBlockList.isEmpty()) {
            IntListIterator intListIterator = this.unprotectedBlockList.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                BlockPos p = new BlockPos(i >>> 20 & 0xFFF, i >>> 12 & 0xFF, i & 0xFFF);
                dungeonGenerator.addUnprotectedPosition(partPos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)p)));
            }
        }
    }

    public static void updateSpecialBlocks() {
        SPECIAL_BLOCKS.clear();
        for (String s : CQRConfig.advanced.specialBlocks) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
            if (b == null) continue;
            SPECIAL_BLOCKS.add(b);
        }
    }

    public static void updateSpecialEntities() {
        SPECIAL_ENTITIES.clear();
        for (String s : CQRConfig.advanced.specialEntities) {
            SPECIAL_ENTITIES.add(new ResourceLocation(s));
        }
    }

    @Deprecated
    public static void checkAndUpdateStructureFiles() {
        if (!CQRConfig.advanced.checkAndUpdateDeprecatedStructureFiles) {
            return;
        }
        Collection files = FileUtils.listFiles((File)CQRMain.CQ_STRUCTURE_FILES_FOLDER, (String[])new String[]{"nbt"}, (boolean)true);
        CQRMain.logger.info("Checking {} structure files", (Object)files.size());
        long lastTimeLogged = System.currentTimeMillis();
        long checkedFiles = 0L;
        int updatedFiles = 0;
        for (File file : files) {
            CQStructure structure;
            if (!NBTHelper.getVersionOfStructureFile(file).equals(CQR_FILE_VERSION) && !(structure = CQStructure.createFromFile(file)).isEmpty()) {
                structure.writeToFile(file);
                ++updatedFiles;
            }
            ++checkedFiles;
            if (System.currentTimeMillis() - lastTimeLogged <= 2000L) continue;
            lastTimeLogged = System.currentTimeMillis();
            CQRMain.logger.info("{}/{}", (Object)checkedFiles, (Object)files.size());
        }
        CQRMain.logger.info("Updated {} structure files", (Object)updatedFiles);
    }

    @Deprecated
    private void readFromDeprecatedNBT(NBTTagCompound compound) {
        String cqrFileVersion = compound.func_74779_i("cqr_file_version");
        if (!cqrFileVersion.equals("1.1.0")) {
            throw new IllegalArgumentException(String.format("Structure nbt is too old! Expected %s but got %s.", "1.1.0", cqrFileVersion));
        }
        this.author = compound.func_74779_i("author");
        this.size = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("size"));
        this.blockInfoList.clear();
        this.specialBlockInfoList.clear();
        this.entityInfoList.clear();
        BlockStatePalette blockStatePalette = new BlockStatePalette();
        NBTTagList compoundTagList = compound.func_150295_c("compoundTagList", 10);
        int blockStateIndex = 0;
        for (NBTBase nbt : compound.func_150295_c("palette", 10)) {
            blockStatePalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)nbt)), blockStateIndex++);
        }
        int x = 0;
        int y = 0;
        int z = 0;
        for (NBTBase nbt : compound.func_150295_c("blockInfoList", 11)) {
            AbstractBlockInfo blockInfo = AbstractBlockInfo.create(x, y, z, (NBTTagIntArray)nbt, blockStatePalette, compoundTagList);
            if (blockInfo != null) {
                this.blockInfoList.add(blockInfo);
            }
            if (x < this.size.func_177958_n() - 1) {
                ++x;
                continue;
            }
            if (y < this.size.func_177956_o() - 1) {
                x = 0;
                ++y;
                continue;
            }
            if (z >= this.size.func_177952_p() - 1) continue;
            x = 0;
            y = 0;
            ++z;
        }
        this.blockInfoList.sort(SORT_FOR_EXPORTATION);
        for (NBTBase nbt : compound.func_150295_c("specialBlockInfoList", 10)) {
            NBTTagList pos;
            AbstractBlockInfo blockInfo;
            NBTTagCompound tag = (NBTTagCompound)nbt;
            if (!tag.func_150297_b("blockInfo", 11) || (blockInfo = AbstractBlockInfo.create((pos = tag.func_150295_c("pos", 3)).func_186858_c(0), pos.func_186858_c(1), pos.func_186858_c(2), (NBTTagIntArray)tag.func_74781_a("blockInfo"), blockStatePalette, compoundTagList)) == null) continue;
            this.specialBlockInfoList.add(blockInfo);
        }
        for (NBTBase nbt : compound.func_150295_c("entityInfoList", 10)) {
            this.entityInfoList.add(new EntityInfo((NBTTagCompound)nbt));
        }
    }
}

