/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.structurefile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.IGeneratable;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class EntityInfo
implements IGeneratable {
    private NBTTagCompound entityData;

    public EntityInfo(BlockPos structurePos, Entity entity) {
        this.entityData = new NBTTagCompound();
        entity.func_70039_c(this.entityData);
        this.entityData.func_82580_o("UUIDMost");
        this.entityData.func_82580_o("UUIDLeast");
        NBTTagList nbtTagList = this.entityData.func_150295_c("Pos", 6);
        nbtTagList.func_150304_a(0, (NBTBase)new NBTTagDouble(entity.field_70165_t - (double)structurePos.func_177958_n()));
        nbtTagList.func_150304_a(1, (NBTBase)new NBTTagDouble(entity.field_70163_u - (double)structurePos.func_177956_o()));
        nbtTagList.func_150304_a(2, (NBTBase)new NBTTagDouble(entity.field_70161_v - (double)structurePos.func_177952_p()));
        if (entity instanceof EntityHanging) {
            BlockPos blockpos = ((EntityHanging)entity).func_174857_n();
            this.entityData.func_74768_a("TileX", blockpos.func_177958_n() - structurePos.func_177958_n());
            this.entityData.func_74768_a("TileY", blockpos.func_177956_o() - structurePos.func_177956_o());
            this.entityData.func_74768_a("TileZ", blockpos.func_177952_p() - structurePos.func_177952_p());
        }
    }

    public EntityInfo(NBTTagCompound compound) {
        this.entityData = compound;
    }

    @Override
    public void generate(World world, BlockPos dungeonPos, BlockPos dungeonPartPos, PlacementSettings settings, DungeonInhabitant dungeonMob, ProtectedRegion protectedRegion) {
        Entity entity;
        try {
            entity = EntityList.func_75615_a((NBTTagCompound)this.entityData, (World)world);
        }
        catch (Exception e) {
            entity = null;
        }
        if (entity != null) {
            if (entity instanceof EntityHanging) {
                BlockPos pos = new BlockPos(this.entityData.func_74762_e("TileX"), this.entityData.func_74762_e("TileY"), this.entityData.func_74762_e("TileZ"));
                if (entity instanceof EntityPainting && settings.func_186212_b() != Mirror.NONE) {
                    pos = pos.func_177967_a(((EntityPainting)entity).field_174860_b.func_176735_f(), (((EntityPainting)entity).field_70522_e.field_75703_B >> 4) + 1 & 1);
                }
                pos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)pos).func_177971_a((Vec3i)dungeonPartPos);
                float transformedYaw = entity.field_70177_z + entity.func_184217_a(settings.func_186212_b()) - entity.func_184229_a(settings.func_186215_c());
                entity.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), transformedYaw, entity.field_70125_A);
            } else {
                Vec3d vec = DungeonGenUtils.transformedVec3d(DungeonGenUtils.readVecFromList(this.entityData.func_150295_c("Pos", 6)), settings).func_72441_c((double)dungeonPartPos.func_177958_n(), (double)dungeonPartPos.func_177956_o(), (double)dungeonPartPos.func_177952_p());
                float transformedYaw = this.getTransformedYaw(entity.field_70177_z, settings.func_186212_b(), settings.func_186215_c());
                entity.func_70012_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, transformedYaw, entity.field_70125_A);
                entity.func_181013_g(transformedYaw);
                entity.func_70034_d(transformedYaw);
            }
            world.func_72838_d(entity);
        }
    }

    public NBTTagCompound getEntityData() {
        return this.entityData;
    }

    public BlockPos getPos() {
        NBTTagList nbtTagList = this.entityData.func_150295_c("Pos", 6);
        return new BlockPos(nbtTagList.func_150309_d(0), nbtTagList.func_150309_d(1), nbtTagList.func_150309_d(2));
    }

    public double getX() {
        NBTTagList nbtTagList = this.entityData.func_150295_c("Pos", 6);
        return nbtTagList.func_150309_d(0);
    }

    public double getY() {
        NBTTagList nbtTagList = this.entityData.func_150295_c("Pos", 6);
        return nbtTagList.func_150309_d(1);
    }

    public double getZ() {
        NBTTagList nbtTagList = this.entityData.func_150295_c("Pos", 6);
        return nbtTagList.func_150309_d(2);
    }

    private float getTransformedYaw(float rotationYaw, Mirror mirror, Rotation rotation) {
        float f = MathHelper.func_76142_g((float)rotationYaw);
        switch (mirror) {
            case LEFT_RIGHT: {
                f = 180.0f - f;
                break;
            }
            case FRONT_BACK: {
                f = -f;
                break;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                f += 90.0f;
                break;
            }
            case CLOCKWISE_180: {
                f += 180.0f;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                f -= 90.0f;
                break;
            }
        }
        return f;
    }
}

