/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.thewall;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.DungeonGenerationHelper;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerationManager;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.IWallPart;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.WallPartRailingTower;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.WallPartRailingWall;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.WallPartTower;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.WallPartWall;
import team.cqr.cqrepoured.util.CQRConfig;

public class WorldWallGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (DungeonGenerationHelper.shouldDelayDungeonGeneration(world)) {
            return;
        }
        if (!CQRConfig.wall.enabled || world.field_72995_K || world.field_73011_w.getDimension() != 0) {
            return;
        }
        if (this.isWallRegion(chunkX, chunkZ, world)) {
            // empty if block
        }
        if (chunkZ < 0 && Math.abs(chunkZ) == Math.abs(CQRConfig.wall.distance)) {
            DungeonGenerator dungeonGenerator = new DungeonGenerator(world, new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8), "Wall in the North");
            Biome biome = world.func_72959_q().func_180631_a(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8));
            if (biome instanceof BiomePlains || biome instanceof BiomeSnow) {
                // empty if block
            }
            IWallPart wallPart = null;
            IWallPart railingPart = null;
            if (chunkX % CQRConfig.wall.towerDistance == 0) {
                wallPart = new WallPartTower();
                railingPart = new WallPartRailingTower();
            } else {
                wallPart = new WallPartWall();
                railingPart = new WallPartRailingWall();
            }
            wallPart.generateWall(chunkX, chunkZ, world, world.func_72964_e(chunkX, chunkZ), dungeonGenerator);
            railingPart.generateWall(chunkX, chunkZ, world, world.func_72964_e(chunkX, chunkZ), dungeonGenerator);
            DungeonGenerationManager.addStructure(world, dungeonGenerator, null, DungeonDataManager.DungeonSpawnType.DUNGEON_GENERATION, DungeonGenerationHelper.shouldGenerateDungeonImmediately(world));
        }
    }

    private boolean isWallRegion(int chunkX, int chunkZ, World world) {
        if (!CQRConfig.wall.enabled) {
            return false;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return false;
        }
        if (chunkZ >= 0) {
            return false;
        }
        if (Math.abs(chunkZ) < Math.abs(CQRConfig.wall.distance - 8)) {
            return false;
        }
        return Math.abs(chunkZ) <= Math.abs(CQRConfig.wall.distance + 8);
    }
}

