/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.thewall.wallparts;

import java.util.ArrayList;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.IWallPart;
import team.cqr.cqrepoured.util.CQRConfig;

public class WallPartRailingTower
implements IWallPart {
    @Override
    public int getTopY() {
        return CQRConfig.wall.topY - 12;
    }

    @Override
    public void generateWall(int chunkX, int chunkZ, World world, Chunk chunk, DungeonGenerator dungeonGenerator) {
        int y;
        int startX = chunkX * 16 + 8;
        int startZ = chunkZ * 16;
        int startY = this.getTopY();
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        IBlockState stateBlock = Blocks.field_150334_T.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.STONE).func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(true));
        IBlockState stateAir = Blocks.field_150350_a.func_176223_P();
        int[] xValues = new int[]{0, 1, 6, 7};
        int[] zValues = new int[]{2, 3, 12, 13};
        for (y = 0; y < 8; ++y) {
            for (int z : zValues) {
                for (int x : xValues) {
                    if (this.isBiggerPart(x)) {
                        if (y < 3 && z != 3 && z != 12) continue;
                        blockInfoList.add(new BlockInfo(new BlockPos(x * 2, y, z), stateBlock, null));
                        blockInfoList.add(new BlockInfo(new BlockPos(x * 2 + 1, y, z), stateBlock, null));
                        continue;
                    }
                    if (y < 4 || y > 6 || z != 3 && z != 12) continue;
                    blockInfoList.add(new BlockInfo(new BlockPos(x * 2, y, z), stateBlock, null));
                    blockInfoList.add(new BlockInfo(new BlockPos(x * 2 + 1, y, z), stateBlock, null));
                }
            }
        }
        for (y = 6; y <= 9; ++y) {
            for (int z = 6; z <= 9; ++z) {
                for (int x = 4; x <= 11; ++x) {
                    if (y >= 9 && z != 7 && z != 8) continue;
                    blockInfoList.add(new BlockInfo(new BlockPos(x, y, z), stateAir, null));
                }
            }
        }
        DungeonInhabitant dungeonMob = DungeonInhabitantManager.instance().getInhabitant("SPECTER");
        dungeonGenerator.add(new DungeonPartBlock(world, dungeonGenerator, new BlockPos(startX, startY, startZ), blockInfoList, new PlacementSettings(), dungeonMob));
    }

    private boolean isBiggerPart(int xAsChunkRelativeCoord) {
        return (xAsChunkRelativeCoord & 1) == 0;
    }
}

