/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.thewall.wallparts;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.factories.SpawnerFactory;
import team.cqr.cqrepoured.objects.items.armor.ItemArmorDyable;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoSpawner;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.IWallPart;
import team.cqr.cqrepoured.tileentity.TileEntitySpawner;
import team.cqr.cqrepoured.util.CQRConfig;

public class WallPartRailingWall
implements IWallPart {
    @Override
    public int getTopY() {
        return CQRConfig.wall.topY - 12;
    }

    @Override
    public void generateWall(int chunkX, int chunkZ, World world, Chunk chunk, DungeonGenerator dungeonGenerator) {
        int startX = chunkX * 16 + 8;
        int startZ = chunkZ * 16;
        int startY = this.getTopY();
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        IBlockState stateBlock = Blocks.field_150334_T.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.STONE).func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(true));
        int[] zValues = new int[]{2, 3, 12, 13};
        for (int y = 0; y < 8; ++y) {
            for (int z : zValues) {
                for (int x = 0; x < 8; ++x) {
                    if (this.isBiggerPart(x)) {
                        if (y < 3 && z != 3 && z != 12) continue;
                        blockInfoList.add(new BlockInfo(new BlockPos(x * 2, y, z), stateBlock, null));
                        blockInfoList.add(new BlockInfo(new BlockPos(x * 2 + 1, y, z), stateBlock, null));
                        continue;
                    }
                    if (y < 4 || y > 6 || z != 3 && z != 12) continue;
                    blockInfoList.add(new BlockInfo(new BlockPos(x * 2, y, z), stateBlock, null));
                    blockInfoList.add(new BlockInfo(new BlockPos(x * 2 + 1, y, z), stateBlock, null));
                }
            }
        }
        this.placeSpawner(new BlockPos(4, 6, 7), world, blockInfoList);
        DungeonInhabitant dungeonMob = DungeonInhabitantManager.instance().getInhabitant("SPECTER");
        dungeonGenerator.add(new DungeonPartBlock(world, dungeonGenerator, new BlockPos(startX, startY, startZ), blockInfoList, new PlacementSettings(), dungeonMob));
    }

    private boolean isBiggerPart(int xAsChunkRelativeCoord) {
        return (xAsChunkRelativeCoord & 1) == 0;
    }

    private void placeSpawner(BlockPos spawnerPos, World world, List<AbstractBlockInfo> blockInfoList) {
        Entity spawnerEnt = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(CQRConfig.wall.mob), (World)world);
        if (spawnerEnt instanceof EntityLivingBase) {
            EnumDifficulty difficulty = world.func_175659_aa();
            this.equipWeaponBasedOnDifficulty((EntityLivingBase)spawnerEnt, difficulty);
            this.equipArmorBasedOnDifficulty((EntityLivingBase)spawnerEnt, difficulty);
            if (spawnerEnt instanceof AbstractEntityCQR) {
                ((AbstractEntityCQR)spawnerEnt).setHealingPotions(1);
            }
            IBlockState state2 = CQRBlocks.SPAWNER.func_176223_P();
            TileEntitySpawner tileSpawner = (TileEntitySpawner)CQRBlocks.SPAWNER.createTileEntity(world, state2);
            tileSpawner.inventory.setStackInSlot(0, SpawnerFactory.getSoulBottleItemStackForEntity(spawnerEnt));
            blockInfoList.add(new BlockInfoSpawner(spawnerPos, tileSpawner.func_189515_b(new NBTTagCompound())));
        }
    }

    private void equipWeaponBasedOnDifficulty(EntityLivingBase entity, EnumDifficulty difficulty) {
        switch (entity.func_70681_au().nextInt(5)) {
            case 0: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u, 1));
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(CQRItems.SHIELD_SPECTER, 1));
                break;
            }
            case 1: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151056_x, 1));
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(CQRItems.SHIELD_SPECTER, 1));
                break;
            }
            case 2: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f, 1));
                break;
            }
            case 3: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f, 1));
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(CQRItems.SHIELD_SPECTER, 1));
                break;
            }
            case 4: {
                entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151048_u, 1));
                entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151048_u, 1));
            }
        }
    }

    private void equipArmorBasedOnDifficulty(EntityLivingBase entity, EnumDifficulty difficulty) {
        ItemStack helm = new ItemStack(CQRItems.HELMET_IRON_DYABLE);
        ItemStack chest = new ItemStack(CQRItems.CHESTPLATE_IRON_DYABLE);
        ItemStack legs = new ItemStack(CQRItems.LEGGINGS_IRON_DYABLE);
        ItemStack feet = new ItemStack(CQRItems.BOOTS_IRON_DYABLE);
        if (difficulty == EnumDifficulty.HARD) {
            if (entity.func_70681_au().nextDouble() < 0.35) {
                helm = new ItemStack(CQRItems.HELMET_DIAMOND_DYABLE);
                chest = new ItemStack(CQRItems.CHESTPLATE_DIAMOND_DYABLE);
                legs = new ItemStack(CQRItems.LEGGINGS_DIAMOND_DYABLE);
                feet = new ItemStack(CQRItems.BOOTS_DIAMOND_DYABLE);
            }
        } else if (difficulty == EnumDifficulty.NORMAL) {
            if (entity.func_70681_au().nextDouble() < 0.25) {
                helm = new ItemStack(CQRItems.HELMET_DIAMOND_DYABLE);
                chest = new ItemStack(CQRItems.CHESTPLATE_DIAMOND_DYABLE);
                legs = new ItemStack(CQRItems.LEGGINGS_DIAMOND_DYABLE);
                feet = new ItemStack(CQRItems.BOOTS_DIAMOND_DYABLE);
            }
        } else if (entity.func_70681_au().nextDouble() < 0.2) {
            helm = new ItemStack(CQRItems.HELMET_DIAMOND_DYABLE);
            chest = new ItemStack(CQRItems.CHESTPLATE_DIAMOND_DYABLE);
            legs = new ItemStack(CQRItems.LEGGINGS_DIAMOND_DYABLE);
            feet = new ItemStack(CQRItems.BOOTS_DIAMOND_DYABLE);
        }
        if (entity.func_70681_au().nextDouble() < 0.005) {
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(helm, 269025279);
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(chest, 269025279);
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(legs, 269025279);
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(feet, 269025279);
        } else {
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(helm, 0);
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(chest, 0);
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(legs, 0);
            ((ItemArmorDyable)helm.func_77973_b()).func_82813_b(feet, 0);
        }
        entity.func_184201_a(EntityEquipmentSlot.HEAD, helm);
        entity.func_184201_a(EntityEquipmentSlot.CHEST, chest);
        entity.func_184201_a(EntityEquipmentSlot.LEGS, legs);
        entity.func_184201_a(EntityEquipmentSlot.FEET, feet);
    }
}

