/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.thewall.wallparts;

import java.util.ArrayList;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.thewall.wallparts.IWallPart;
import team.cqr.cqrepoured.util.CQRConfig;

public class WallPartTower
implements IWallPart {
    @Override
    public int getTopY() {
        return CQRConfig.wall.topY;
    }

    @Override
    public void generateWall(int chunkX, int chunkZ, World world, Chunk chunk, DungeonGenerator dungeonGenerator) {
        int startX = chunkX * 16 + 8;
        int startZ = chunkZ * 16;
        int startY = this.getBottomY(world, startX, startZ);
        if (this.getTopY() > startY) {
            ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
            IBlockState stateBrick = Blocks.field_150417_aV.func_176223_P();
            IBlockState stateObsidian = CQRConfig.wall.obsidianCore ? Blocks.field_150343_Z.func_176223_P() : stateBrick;
            IBlockState stateAndesite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE_SMOOTH);
            int height = this.getTopY() - startY;
            for (BlockPos pos : BlockPos.func_191532_a((int)0, (int)0, (int)0, (int)15, (int)height, (int)15)) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                if (z >= 4 && z < 12 && (x <= 4 || x >= 12) && y <= height - 7) {
                    if (z >= 6 && z <= 9 && y < height - 7) {
                        blockInfoList.add(new BlockInfo(pos, stateObsidian, null));
                    } else {
                        blockInfoList.add(new BlockInfo(pos, stateBrick, null));
                    }
                }
                if (z >= 6 && z <= 9 && y <= height - 8 || x >= 6 && x <= 9 && z >= 2 && z <= 13 && y < height - 7) {
                    blockInfoList.add(new BlockInfo(pos, stateObsidian, null));
                    continue;
                }
                if (x < 4 || x > 11) continue;
                blockInfoList.add(new BlockInfo(pos, stateAndesite, null));
            }
            DungeonInhabitant dungeonMob = DungeonInhabitantManager.instance().getInhabitant("SPECTER");
            dungeonGenerator.add(new DungeonPartBlock(world, dungeonGenerator, new BlockPos(startX, startY, startZ), blockInfoList, new PlacementSettings(), dungeonMob));
        }
    }
}

