/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structureprot;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import team.cqr.cqrepoured.client.structureprot.ProtectedRegionClientEventHandler;
import team.cqr.cqrepoured.structureprot.IProtectedRegionManager;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.structureprot.ProtectedRegionManager;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.reflection.ReflectionField;

public class ProtectedRegionHelper {
    public static final Set<Block> BREAKABLE_BLOCK_WHITELIST = new HashSet<Block>();
    public static final Set<Material> BREAKABLE_MATERIAL_WHITELIST = new HashSet<Material>();
    public static final Set<Block> PLACEABLE_BLOCK_WHITELIST = new HashSet<Block>();
    public static final Set<Material> PLACEABLE_MATERIAL_WHITELIST = new HashSet<Material>();
    private static final ReflectionField<Entity> EXPLODER_FIELD = new ReflectionField(Explosion.class, "field_77283_e", "exploder");

    private ProtectedRegionHelper() {
    }

    public static void updateWhitelists() {
        Block b2;
        BREAKABLE_BLOCK_WHITELIST.clear();
        BREAKABLE_MATERIAL_WHITELIST.clear();
        PLACEABLE_BLOCK_WHITELIST.clear();
        PLACEABLE_MATERIAL_WHITELIST.clear();
        for (String s : CQRConfig.dungeonProtection.protectionSystemBreakableBlockWhitelist) {
            b2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
            if (b2 == null) continue;
            BREAKABLE_BLOCK_WHITELIST.add(b2);
        }
        for (String s : CQRConfig.dungeonProtection.protectionSystemBreakableMaterialWhitelist) {
            try {
                BREAKABLE_MATERIAL_WHITELIST.add((Material)Material.class.getField(s.toUpperCase()).get(null));
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException b2) {
                // empty catch block
            }
        }
        for (String s : CQRConfig.dungeonProtection.protectionSystemPlaceableBlockWhitelist) {
            b2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
            if (b2 == null) continue;
            PLACEABLE_BLOCK_WHITELIST.add(b2);
        }
        for (String s : CQRConfig.dungeonProtection.protectionSystemPlaceableMaterialWhitelist) {
            try {
                PLACEABLE_MATERIAL_WHITELIST.add((Material)Material.class.getField(s.toUpperCase()).get(null));
            }
            catch (ClassCastException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static boolean isBlockBreakingPrevented(World world, BlockPos pos, @Nullable Entity entity, boolean updateProtectedRegions, boolean addOrResetProtectedRegionIndicator) {
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager == null) {
            return false;
        }
        List<ProtectedRegion> protectedRegions = manager.getProtectedRegionsAt(pos);
        if (protectedRegions.isEmpty()) {
            return false;
        }
        boolean isBlockDependency = false;
        for (ProtectedRegion protectedRegion : protectedRegions) {
            if (!protectedRegion.isBlockDependency(pos)) continue;
            if (updateProtectedRegions) {
                protectedRegion.removeBlockDependency(pos);
            }
            isBlockDependency = true;
        }
        boolean isBreakingPrevented = false;
        if (!(isBlockDependency || !CQRConfig.dungeonProtection.protectionSystemEnabled || !CQRConfig.dungeonProtection.preventBlockBreaking || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() || ProtectedRegionHelper.isBlockBreakingWhitelisted(world.func_180495_p(pos)))) {
            for (ProtectedRegion protectedRegion : protectedRegions) {
                if (!protectedRegion.preventBlockBreaking() || protectedRegion.isBreakable(pos)) continue;
                if (addOrResetProtectedRegionIndicator) {
                    ProtectedRegionClientEventHandler.addOrResetProtectedRegionIndicator(world, protectedRegion.getUuid(), protectedRegion.getStartPos(), protectedRegion.getEndPos(), pos, entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null);
                }
                isBreakingPrevented = true;
                break;
            }
        }
        if (updateProtectedRegions && !isBreakingPrevented) {
            for (ProtectedRegion protectedRegion : protectedRegions) {
                protectedRegion.setProtectionState(pos, 0);
            }
        }
        return isBreakingPrevented;
    }

    private static boolean isBlockBreakingWhitelisted(IBlockState state) {
        if (BREAKABLE_BLOCK_WHITELIST.contains(state.func_177230_c())) {
            return true;
        }
        return BREAKABLE_MATERIAL_WHITELIST.contains(state.func_185904_a());
    }

    public static boolean isBlockPlacingPrevented(World world, BlockPos pos, @Nullable Entity entity, IBlockState state, boolean updateProtectedRegions, boolean addOrResetProtectedRegionIndicator) {
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager == null) {
            return false;
        }
        List<ProtectedRegion> protectedRegions = manager.getProtectedRegionsAt(pos);
        if (protectedRegions.isEmpty()) {
            return false;
        }
        boolean isPlacingPrevented = false;
        if (!(!CQRConfig.dungeonProtection.protectionSystemEnabled || !CQRConfig.dungeonProtection.preventBlockPlacing || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_() || ProtectedRegionHelper.isBlockPlacingWhitelisted(state))) {
            for (ProtectedRegion protectedRegion : protectedRegions) {
                if (!protectedRegion.preventBlockPlacing()) continue;
                if (addOrResetProtectedRegionIndicator) {
                    ProtectedRegionClientEventHandler.addOrResetProtectedRegionIndicator(world, protectedRegion.getUuid(), protectedRegion.getStartPos(), protectedRegion.getEndPos(), pos, entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null);
                }
                isPlacingPrevented = true;
                break;
            }
        }
        if (updateProtectedRegions && !isPlacingPrevented) {
            for (ProtectedRegion protectedRegion : protectedRegions) {
                protectedRegion.setProtectionState(pos, 1);
            }
        }
        return isPlacingPrevented;
    }

    private static boolean isBlockPlacingWhitelisted(IBlockState state) {
        if (PLACEABLE_BLOCK_WHITELIST.contains(state.func_177230_c())) {
            return true;
        }
        return PLACEABLE_MATERIAL_WHITELIST.contains(state.func_185904_a());
    }

    public static IBlockState getBlockFromItem(ItemStack stack, World world, BlockPos pos, EnumFacing facing, @Nullable Vec3d hitVec, EntityLivingBase placer, EnumHand hand) {
        if (stack.func_190926_b()) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            int meta = ((ItemBlock)item).func_77647_b(stack.func_77952_i());
            if (hitVec != null) {
                return ((ItemBlock)item).func_179223_d().getStateForPlacement(world, pos, facing, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, meta, placer, hand);
            }
            return ((ItemBlock)item).func_179223_d().func_176223_P();
        }
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluidStack != null && fluidStack.amount != 0 && fluidStack.getFluid() != null && fluidStack.getFluid().canBePlacedInWorld()) {
            return fluidStack.getFluid().getBlock().func_176223_P();
        }
        return null;
    }

    public static boolean isExplosionTNTPrevented(World world, BlockPos pos, @Nullable BlockPos origin, boolean checkForOrigin) {
        if (!CQRConfig.dungeonProtection.protectionSystemEnabled || !CQRConfig.dungeonProtection.preventExplosionTNT) {
            return false;
        }
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager == null) {
            return false;
        }
        for (ProtectedRegion protectedRegion : manager.getProtectedRegions()) {
            if (!protectedRegion.preventExplosionsTNT()) continue;
            if (protectedRegion.isInsideProtectedRegion(pos)) {
                return true;
            }
            if (!checkForOrigin || origin == null || !protectedRegion.isInsideProtectedRegion(origin)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExplosionOtherPrevented(World world, BlockPos pos, @Nullable BlockPos origin, boolean checkForOrigin) {
        if (!CQRConfig.dungeonProtection.protectionSystemEnabled || !CQRConfig.dungeonProtection.preventExplosionOther) {
            return false;
        }
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager == null) {
            return false;
        }
        for (ProtectedRegion protectedRegion : manager.getProtectedRegions()) {
            if (!protectedRegion.preventExplosionsOther()) continue;
            if (protectedRegion.isInsideProtectedRegion(pos)) {
                return true;
            }
            if (!checkForOrigin || origin == null || !protectedRegion.isInsideProtectedRegion(origin)) continue;
            return true;
        }
        return false;
    }

    public static void removeExplosionPreventedPositions(World world, Explosion explosion, boolean checkForOrigin) {
        boolean flag2;
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager == null) {
            return;
        }
        List affectedBlockPositions = explosion.func_180343_e();
        if (affectedBlockPositions.isEmpty()) {
            return;
        }
        Entity exploder = EXPLODER_FIELD.get(explosion);
        boolean flag = exploder instanceof EntityTNTPrimed;
        boolean flag1 = flag && CQRConfig.dungeonProtection.preventExplosionTNT || !flag && CQRConfig.dungeonProtection.preventExplosionOther;
        boolean bl = flag2 = CQRConfig.dungeonProtection.protectionSystemEnabled && flag1;
        if (flag2) {
            BlockPos pos = new BlockPos(explosion.getPosition());
            for (ProtectedRegion protectedRegion : manager.getProtectedRegions()) {
                if (flag && protectedRegion.preventExplosionsTNT() || !flag && protectedRegion.preventExplosionsOther()) {
                    if (checkForOrigin && protectedRegion.isInsideProtectedRegion(pos)) {
                        affectedBlockPositions.clear();
                    } else {
                        for (int i = 0; i < affectedBlockPositions.size(); ++i) {
                            BlockPos pos1 = (BlockPos)affectedBlockPositions.get(i);
                            if (!protectedRegion.isInsideProtectedRegion(pos1)) continue;
                            affectedBlockPositions.remove(i--);
                        }
                    }
                }
                if (!affectedBlockPositions.isEmpty()) continue;
                return;
            }
        }
        for (ProtectedRegion protectedRegion : manager.getProtectedRegions()) {
            for (BlockPos pos1 : affectedBlockPositions) {
                protectedRegion.setProtectionState(pos1, 0);
            }
        }
    }

    public static boolean isFireSpreadingPrevented(World world, BlockPos pos, @Nullable BlockPos origin, boolean checkForOrigin) {
        if (!CQRConfig.dungeonProtection.protectionSystemEnabled || !CQRConfig.dungeonProtection.preventFireSpreading) {
            return false;
        }
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager == null) {
            return false;
        }
        for (ProtectedRegion protectedRegion : manager.getProtectedRegions()) {
            if (!protectedRegion.preventFireSpreading()) continue;
            if (protectedRegion.isInsideProtectedRegion(pos)) {
                return true;
            }
            if (!checkForOrigin || origin == null || !protectedRegion.isInsideProtectedRegion(origin)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntitySpawningPrevented(World world, BlockPos pos) {
        if (!CQRConfig.dungeonProtection.protectionSystemEnabled || !CQRConfig.dungeonProtection.preventEntitySpawning) {
            return false;
        }
        IProtectedRegionManager manager = ProtectedRegionManager.getInstance(world);
        if (manager == null) {
            return false;
        }
        for (ProtectedRegion protectedRegion : manager.getProtectedRegions()) {
            if (!protectedRegion.preventEntitySpawning() || !protectedRegion.isInsideProtectedRegion(pos)) continue;
            return true;
        }
        return false;
    }
}

