/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structureprot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.capability.protectedregions.CapabilityProtectedRegionData;
import team.cqr.cqrepoured.capability.protectedregions.CapabilityProtectedRegionDataProvider;
import team.cqr.cqrepoured.network.server.packet.SPacketUnloadProtectedRegion;
import team.cqr.cqrepoured.network.server.packet.SPacketUpdateProtectedRegion;
import team.cqr.cqrepoured.structureprot.IProtectedRegionManager;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;

public class ServerProtectedRegionManager
implements IProtectedRegionManager {
    private final Map<UUID, ProtectedRegionContainer> protectedRegions = new ConcurrentHashMap<UUID, ProtectedRegionContainer>();
    private final World world;
    private final File folder;

    public ServerProtectedRegionManager(World world) {
        this.world = world;
        int dim = world.field_73011_w.getDimension();
        this.folder = dim == 0 ? new File(world.func_72860_G().func_75765_b(), "data/CQR/protected_regions") : new File(world.func_72860_G().func_75765_b(), "DIM" + dim + "/data/CQR/protected_regions");
    }

    public void handleChunkLoad(Chunk chunk) {
        CapabilityProtectedRegionData capabilityProtectedRegionData = (CapabilityProtectedRegionData)chunk.getCapability(CapabilityProtectedRegionDataProvider.PROTECTED_REGION_DATA, null);
        capabilityProtectedRegionData.removeIf(uuid -> this.provideProtectedRegion((UUID)uuid) == null);
    }

    public void handleChunkUnload(Chunk chunk) {
        for (ProtectedRegionContainer container : this.protectedRegions.values()) {
            container.chunkSet.remove(chunk);
        }
    }

    public void handleWorldTick() {
        long time = this.world.func_82737_E();
        Iterator<ProtectedRegionContainer> iterator = this.protectedRegions.values().iterator();
        while (iterator.hasNext()) {
            ProtectedRegionContainer container = iterator.next();
            if (!container.chunkSet.isEmpty()) {
                container.lastTickForceLoaded = time;
            } else if (time - container.lastTickForceLoaded > 600L) {
                if (container.protectedRegion.needsSaving()) {
                    this.saveProtectedRegionToFile(container.protectedRegion);
                }
                iterator.remove();
                CQRMain.NETWORK.sendToDimension((IMessage)new SPacketUnloadProtectedRegion(container.protectedRegion.getUuid()), this.world.field_73011_w.getDimension());
                continue;
            }
            if (!container.protectedRegion.needsSyncing()) continue;
            CQRMain.NETWORK.sendToDimension((IMessage)new SPacketUpdateProtectedRegion(container.protectedRegion), this.world.field_73011_w.getDimension());
            container.protectedRegion.clearNeedsSyncing();
        }
    }

    @Nullable
    public ProtectedRegion provideProtectedRegion(UUID uuid) {
        ProtectedRegionContainer container = this.protectedRegions.get(uuid);
        if (container != null) {
            return container.protectedRegion;
        }
        ProtectedRegion protectedRegion = this.createProtectedRegionFromFile(uuid);
        if (protectedRegion != null) {
            this.protectedRegions.put(uuid, new ProtectedRegionContainer(protectedRegion, false));
            CQRMain.NETWORK.sendToDimension((IMessage)new SPacketUpdateProtectedRegion(protectedRegion), this.world.field_73011_w.getDimension());
            protectedRegion.clearNeedsSyncing();
        }
        return protectedRegion;
    }

    @Override
    @Nullable
    public ProtectedRegion getProtectedRegion(UUID uuid) {
        ProtectedRegionContainer container = this.protectedRegions.get(uuid);
        return container != null ? container.protectedRegion : null;
    }

    @Override
    public void addProtectedRegion(ProtectedRegion protectedRegion) {
        if (!protectedRegion.isValid()) {
            return;
        }
        if (this.protectedRegions.containsKey(protectedRegion.getUuid())) {
            CQRMain.logger.warn("Protected region with uuid {} already exists.", (Object)protectedRegion.getUuid());
            return;
        }
        this.protectedRegions.put(protectedRegion.getUuid(), new ProtectedRegionContainer(protectedRegion, true));
        CQRMain.NETWORK.sendToDimension((IMessage)new SPacketUpdateProtectedRegion(protectedRegion), this.world.field_73011_w.getDimension());
        protectedRegion.clearNeedsSyncing();
    }

    @Override
    public void removeProtectedRegion(ProtectedRegion protectedRegion) {
        this.removeProtectedRegion(protectedRegion.getUuid());
    }

    @Override
    public void removeProtectedRegion(UUID uuid) {
        ProtectedRegionContainer container = this.protectedRegions.remove(uuid);
        File file = new File(this.folder, uuid.toString() + ".nbt");
        if (file.exists()) {
            file.delete();
        }
        if (container != null) {
            for (Chunk chunk : container.chunkSet) {
                CapabilityProtectedRegionData capProtectedRegionData = (CapabilityProtectedRegionData)chunk.getCapability(CapabilityProtectedRegionDataProvider.PROTECTED_REGION_DATA, null);
                capProtectedRegionData.removeProtectedRegionUuid(uuid);
            }
            CQRMain.NETWORK.sendToDimension((IMessage)new SPacketUnloadProtectedRegion(uuid), this.world.field_73011_w.getDimension());
        }
    }

    @Override
    public Iterable<ProtectedRegion> getProtectedRegions() {
        return () -> new Iterator<ProtectedRegion>(){
            private final Iterator iterator;
            {
                this.iterator = Collections.unmodifiableCollection(ServerProtectedRegionManager.this.protectedRegions.values()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ProtectedRegion next() {
                return ((ProtectedRegionContainer)this.iterator.next()).protectedRegion;
            }
        };
    }

    @Override
    public List<ProtectedRegion> getProtectedRegionsAt(BlockPos pos) {
        Chunk chunk = this.world.func_175726_f(pos);
        CapabilityProtectedRegionData cap = (CapabilityProtectedRegionData)chunk.getCapability(CapabilityProtectedRegionDataProvider.PROTECTED_REGION_DATA, null);
        if (cap == null) {
            return Collections.emptyList();
        }
        ArrayList<ProtectedRegion> list = new ArrayList<ProtectedRegion>();
        cap.removeIf(uuid -> {
            ProtectedRegionContainer container = this.protectedRegions.get(uuid);
            if (container != null && container.protectedRegion.isInsideProtectedRegion(pos)) {
                list.add(container.protectedRegion);
            }
            return container == null;
        });
        return list;
    }

    @Override
    public void clearProtectedRegions() {
        for (UUID uuid : new ArrayList<UUID>(this.protectedRegions.keySet())) {
            this.removeProtectedRegion(uuid);
        }
    }

    public void saveProtectedRegions() {
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        Iterator<ProtectedRegionContainer> iterator = this.protectedRegions.values().iterator();
        while (iterator.hasNext()) {
            ProtectedRegionContainer container = iterator.next();
            if (!container.protectedRegion.isValid()) {
                File file = new File(this.folder, container.protectedRegion.getUuid() + ".nbt");
                if (file.exists()) {
                    file.delete();
                }
                iterator.remove();
                continue;
            }
            if (!container.protectedRegion.needsSaving()) continue;
            this.saveProtectedRegionToFile(container.protectedRegion);
        }
    }

    private void saveProtectedRegionToFile(ProtectedRegion protectedRegion) {
        File file = new File(this.folder, protectedRegion.getUuid().toString() + ".nbt");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                NBTTagCompound compound = protectedRegion.writeToNBT();
                CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)out);
            }
        }
        catch (IOException e) {
            CQRMain.logger.error(String.format("Failed to write protected region to file: %s", file.getName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private ProtectedRegion createProtectedRegionFromFile(UUID uuid) {
        File file = new File(this.folder, uuid.toString() + ".nbt");
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(file);){
            NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)in);
            ProtectedRegion protectedRegion2 = new ProtectedRegion(this.world, compound);
            if (!compound.func_74779_i("version").equals("1.2.0")) {
                this.saveProtectedRegionToFile(protectedRegion2);
            }
            ProtectedRegion protectedRegion = protectedRegion2;
            return protectedRegion;
        }
        catch (IOException e) {
            CQRMain.logger.error(String.format("Failed to read protected region from file: %s", file.getName()), (Throwable)e);
            return null;
        }
    }

    public static class ProtectedRegionContainer {
        public final ProtectedRegion protectedRegion;
        public long lastTickForceLoaded;
        public final Set<Chunk> chunkSet = Collections.newSetFromMap(new ConcurrentHashMap());

        public ProtectedRegionContainer(ProtectedRegion protectedRegion, boolean loadChunks) {
            this.protectedRegion = protectedRegion;
            this.lastTickForceLoaded = protectedRegion.getWorld().func_82737_E();
            boolean logCascadingWorldGeneration = ForgeModContainer.logCascadingWorldGeneration;
            ForgeModContainer.logCascadingWorldGeneration = false;
            ((WorldServer)protectedRegion.getWorld()).func_152344_a(() -> {
                BlockPos p1 = protectedRegion.getStartPos();
                BlockPos p2 = protectedRegion.getEndPos();
                for (int x = p1.func_177958_n() >> 4; x <= p2.func_177958_n() >> 4; ++x) {
                    for (int z = p1.func_177952_p() >> 4; z <= p2.func_177952_p() >> 4; ++z) {
                        Chunk chunk = loadChunks ? protectedRegion.getWorld().func_72964_e(x, z) : protectedRegion.getWorld().func_72863_F().func_186026_b(x, z);
                        if (chunk == null) continue;
                        this.chunkSet.add(chunk);
                        CapabilityProtectedRegionData capProtectedRegionData = (CapabilityProtectedRegionData)chunk.getCapability(CapabilityProtectedRegionDataProvider.PROTECTED_REGION_DATA, null);
                        capProtectedRegionData.addProtectedRegionUuid(protectedRegion.getUuid());
                    }
                }
            });
            ForgeModContainer.logCascadingWorldGeneration = logCascadingWorldGeneration;
        }
    }
}

