/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.BlockSnapshot;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.reflection.ReflectionField;
import team.cqr.cqrepoured.util.reflection.ReflectionMethod;

public class BlockPlacingHelper {
    private static ReflectionField<int[]> precipitationHeightMapField = new ReflectionField(Chunk.class, "field_76638_b", "precipitationHeightMap");
    private static ReflectionMethod<Object> relightBlockMethod = new ReflectionMethod(Chunk.class, "func_76615_h", "relightBlock", Integer.TYPE, Integer.TYPE, Integer.TYPE);
    private static ReflectionMethod<Object> propagateSkylightOcclusionMethod = new ReflectionMethod(Chunk.class, "func_76595_e", "propagateSkylightOcclusion", Integer.TYPE, Integer.TYPE);

    public static boolean setBlockState(World world, BlockPos pos, IBlockState newState, int flags, boolean updateLight) {
        if (CQRMain.isPhosphorInstalled || CQRConfig.advanced.instantLightUpdates || updateLight) {
            return world.func_180501_a(pos, newState, flags);
        }
        if (world.func_189509_E(pos)) {
            return false;
        }
        if (!world.field_72995_K && world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        IBlockState oldState = chunk.func_177435_g(pos);
        IBlockState iblockstate = BlockPlacingHelper.setBlockState(world, chunk, pos, newState);
        if (iblockstate == null) {
            return false;
        }
        if (!world.field_72995_K && world.captureBlockSnapshots) {
            world.capturedBlockSnapshots.add(new BlockSnapshot(world, pos.func_185334_h(), oldState, flags));
        } else {
            world.markAndNotifyBlock(pos, chunk, iblockstate, newState, flags);
        }
        return true;
    }

    @Nullable
    private static IBlockState setBlockState(World world, Chunk chunk, BlockPos pos, IBlockState state) {
        TileEntity te;
        IBlockState iblockstate;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        int l = k << 4 | i;
        int[] precipitationHeightMap = precipitationHeightMapField.get(chunk);
        if (j >= precipitationHeightMap[l] - 1) {
            precipitationHeightMap[l] = -999;
        }
        if ((iblockstate = chunk.func_177435_g(pos)) == state) {
            return null;
        }
        Block block = state.func_177230_c();
        Block block1 = iblockstate.func_177230_c();
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[j >> 4];
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return null;
            }
            chunk.func_76587_i()[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, world.field_73011_w.func_191066_m());
        }
        extendedblockstorage.func_177484_a(i, j & 0xF, k, state);
        if (!world.field_72995_K) {
            if (block1 != block) {
                block1.func_180663_b(world, pos, iblockstate);
            }
            if ((te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(world, pos, iblockstate, state)) {
                world.func_175713_t(pos);
            }
        } else if (block1.hasTileEntity(iblockstate) && (te = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(world, pos, iblockstate, state)) {
            world.func_175713_t(pos);
        }
        if (extendedblockstorage.func_177485_a(i, j & 0xF, k).func_177230_c() != block) {
            return null;
        }
        if (!(world.field_72995_K || block1 == block || world.captureBlockSnapshots && !block.hasTileEntity(state))) {
            block.func_176213_c(world, pos, state);
        }
        if (block.hasTileEntity(state)) {
            TileEntity tileentity1 = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = block.createTileEntity(world, state);
                world.func_175690_a(pos, tileentity1);
            }
            if (tileentity1 != null) {
                tileentity1.func_145836_u();
            }
        }
        chunk.func_76630_e();
        return iblockstate;
    }
}

