/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import team.cqr.cqrepoured.objects.entity.boss.EntityCQRGiantTortoise;
import team.cqr.cqrepoured.objects.entity.boss.EntityCQRNetherDragon;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.structureprot.ProtectedRegionHelper;

@Config(modid="cqrepoured")
public class CQRConfig {
    public static Advanced advanced = new Advanced();
    public static Bosses bosses = new Bosses();
    public static BossDamageCaps bossDamageCaps = new BossDamageCaps();
    public static DungeonProtection dungeonProtection = new DungeonProtection();
    public static General general = new General();
    public static Mobs mobs = new Mobs();
    public static Wall wall = new Wall();
    public static Materials materials = new Materials();
    public static BaseHealths baseHealths = new BaseHealths();

    @Mod.EventBusSubscriber(modid="cqrepoured", value={Side.CLIENT})
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("cqrepoured")) {
                ConfigManager.sync((String)"cqrepoured", (Config.Type)Config.Type.INSTANCE);
                CQStructure.updateSpecialBlocks();
                CQStructure.updateSpecialEntities();
                if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().func_71387_A()) {
                    ProtectedRegionHelper.updateWhitelists();
                }
                EntityCQRNetherDragon.reloadBreakableBlocks();
                EntityCQRGiantTortoise.realoadHardBlocks();
            }
        }
    }

    public static class BaseHealths {
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Dummy = 1.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Dwarf = 30.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Enderman = 40.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Goblin = 20.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Golem = 40.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Gremlin = 30.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Human = 20.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Illager = 25.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Minotaur = 30.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Mummy = 20.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float NPC = 20.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Ogre = 35.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Orc = 30.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Boarman = 25.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Pirate = 25.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Skeleton = 20.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Spectre = 30.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Triton = 30.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float AbyssWalker = 40.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Zombie = 25.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Mandril = 30.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float NetherDragon = 250.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float GiantTortoise = 400.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Lich = 200.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Necromancer = 150.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float Boarmage = 250.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float AbyssWalkerKing = 300.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float PirateCaptain = 200.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float GiantSpider = 150.0f;
        @Config.RangeDouble(min=1.0, max=1000.0)
        public float EnderCalamity = 300.0f;
    }

    public static class Wall {
        @Config.RangeInt(min=0, max=1000)
        public int distance = 500;
        public boolean enabled = true;
        public String mob = "cqrepoured:spectre";
        public boolean obsidianCore = true;
        @Config.RangeInt(min=80, max=240)
        public int topY = 140;
        @Config.RangeInt(min=0, max=10)
        public int towerDistance = 3;
    }

    public static class Mobs {
        @Config.Comment(value={"Enables the axe & shield mechanic from vanilla for CQR mobs with a shield"})
        public boolean blockCancelledByAxe = true;
        public boolean armorShattersOnMobs = true;
        public boolean enableHealthChangeOnDistance = true;
        @Config.RangeInt(min=1, max=100000)
        @Config.Comment(value={"Every X blocks the mobs HP goes up by 10% of it's base health"})
        public int distanceDivisor = 1000;
        @Config.RangeInt(min=1, max=100000)
        public int mobTypeChangeDistance = 1500;
        @Config.RangeInt(min=0, max=128)
        public int factionUpdateRadius = 100;
        @Config.RangeInt(min=0, max=128)
        public int alertRadius = 20;
        @Config.Comment(value={"For every player after the first bosses will receive x percent less damage. bossDamageReduction = (1.0 - x) ^ (playerCount - 1)"})
        @Config.RangeDouble(min=0.0, max=0.5)
        public double bossDamageReductionPerPlayer = 0.25;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double dropDurabilityModalValue = 0.25;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double dropDurabilityStandardDeviation = 0.05;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double dropDurabilityMinimum = 0.1;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double dropDurabilityMaximum = 0.5;
        public boolean enableEntityStrafing = false;
        public boolean enableEntityStrafingBoss = true;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double entityStrafingSpeed = 0.5;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double entityStrafingSpeedBoss = 0.5;
        @Config.RangeInt(min=2, max=64)
        public int looterAIChestSearchRange = 16;
        public int looterAIStealableItems = 4;
        public boolean offhandPotionsAreSingleUse = true;
        public boolean potionsInBagAreSingleUse = true;
        public boolean enableDamageCapForNonBossMobs = false;
        public float maxUncappedDamageForNonBossMobs = 50.0f;
        public float maxUncappedDamageInMaxHPPercent = 1.0f;
    }

    public static class General {
        @Config.Comment(value={"Distance in chunks between each dungeon. Recommend to not set this a value lower than 10."})
        @Config.RangeInt(min=1, max=1000)
        public int dungeonSeparation = 20;
        @Config.Comment(value={"Distance in chunks to the worlds spawn point in which no dungeons can generate."})
        @Config.RangeInt(min=0, max=1000)
        public int dungeonSpawnDistance = 25;
        @Config.Comment(value={"Enable/Disable dungeon generation in super flat worlds."})
        public boolean dungeonsInFlat = false;
        @Config.Comment(value={"Setting this to true allows you to set min and max items per chest"})
        public boolean singleLootPoolPerLootTable = true;
        @Config.RangeInt(min=0, max=27)
        public int minItemsPerLootChest = 2;
        @Config.RangeInt(min=1, max=27)
        public int maxItemsPerLootChest = 8;
        public boolean mobsFromCQSpawnerDontDespawn = true;
        @Config.Comment(value={"Copies the default config files from the jar to the config folder (existing files will get replaced)."})
        public boolean reinstallDefaultConfigs = false;
        @Config.RangeInt(min=0, max=100)
        public int spawnerActivationDistance = 48;
        @Config.RangeInt(min=0, max=32)
        public int supportHillWallSize = 8;
        @Config.Comment(value={"Chance in percent to generate a dungeon."})
        @Config.RangeInt(min=0, max=100)
        public int overallDungeonChance = 100;
        public boolean moreDungeonsBehindWall = true;
        @Config.RangeDouble(min=0.0, max=10.0)
        public double densityBehindWallFactor = 2.0;
        public boolean enableSpeechBubbles = true;
        public boolean hookOnlyPullsSmallerEntities = true;
    }

    public static class DungeonProtection {
        public boolean preventBlockBreaking = true;
        public boolean preventBlockPlacing = false;
        public boolean preventEntitySpawning = true;
        public boolean preventExplosionOther = true;
        public boolean preventExplosionTNT = true;
        public boolean preventFireSpreading = true;
        @Config.Comment(value={"This enables the protection system. Set to false to disable it globally. Disabling this does not delete Protected Regions and instead just does not prevent the player from for example placing blocks."})
        public boolean protectionSystemEnabled = true;
        @Config.Comment(value={"Blocks which will be breakable despite being protected by the protection system."})
        public String[] protectionSystemBreakableBlockWhitelist = new String[]{"minecraft:mob_spawner", "minecraft:torch", "cqrepoured:unlit_torch", "cqrepoured:phylactery", "cqrepoured:force_field_nexus"};
        @Config.Comment(value={"Blocks with a whitelisted material will be breakable despite being protected by the protection system."})
        public String[] protectionSystemBreakableMaterialWhitelist = new String[]{"WATER", "LAVA", "PLANTS", "VINE", "FIRE", "CACTUS", "CAKE", "WEB"};
        @Config.Comment(value={"Blocks which will be placeable at positions protected by the protection system."})
        public String[] protectionSystemPlaceableBlockWhitelist = new String[]{"minecraft:torch", "minecraft:fire", "cqrepoured:unlit_torch"};
        @Config.Comment(value={"Blocks with a whitelisted material will be placeable at positions protected by the protection system."})
        public String[] protectionSystemPlaceableMaterialWhitelist = new String[0];
    }

    public static class BossDamageCaps {
        public boolean enableDamageCapForBosses = true;
        public float maxUncappedDamage = 30.0f;
        public float maxDamageInPercentOfMaxHP = 0.1f;
    }

    public static class Bosses {
        public boolean antiCowardMode = true;
        public int antiCowardRadius = 16;
        public boolean enableHealthRegen = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"WARNING: This WILL affect every player on the server or your lan world! Changing this as a player on a server does not have any effect"})
        public boolean enableBossBars = true;
        public boolean hotFireballsDestroyTerrain = true;
        public boolean harderWalkerKing = false;
        public boolean armorForTheWalkerKing = true;
        public boolean netherDragonDestroysBlocks = true;
        public int netherDragonStageTwoFireballInterval = 40;
        public int netherDragonStageTwoSegmentHP = 50;
        public String[] netherDragonBreakableBlocks = new String[]{"minecraft:stone", "minecraft:netherrack", "minecraft:grass", "minecraft:dirt", "minecraft:quartz_ore", "minecraft:gravel", "minecraft:soul_sand", "minecraft:sand", "minecraft:leaves", "minecraft:tall_grass", "minecraft:double_plant", "minecraft:coal_ore", "minecraft:iron_ore", "minecraft:gold_ore", "minecraft:water", "minecraft:lava", "minecraft:magma", "minecraft:glowstone", "cqrepoured:phylactery"};
        public double pirateCaptainFleeCheckRadius = 32.0;
        public boolean boarmageExplosionRayDestroysTerrain = false;
        public boolean boarmageExplosionAreaDestroysTerrain = false;
        public String[] giantTortoiseHardBlocks = new String[]{"minecraft:obsidian", "minecraft:iron_block", "minecraft:bedrock"};
        public float giantSpiderMaxHealByBite = 8.0f;
        @Config.Comment(value={"Controls the roundness of the ender-calamity's shield, has a massive impact on performance. The higher, the rounder"})
        @Config.RequiresMcRestart
        public int enderCalamityShieldRoundness = 32;
        public boolean thrownBlocksDestroyTerrain = true;
        public boolean thrownBlocksGetPlaced = true;
    }

    public static class Materials {
        public int armorStatDragonBase = 9;
        public int armorStatCloudBase = 9;
        public int armorStatBullBase = 7;
        public int armorStatSpiderBase = 7;
        public int armorStatSlimeBase = 6;
        public int armorStatTurtleBase = 8;
        public int armorStatHeavyDiamondBase = 9;
        public int armorStatHeavyIronBase = 8;
        public int armorStatInquisitionBase = 8;
        public int armorStatBackpackBase = 3;
        public int armorStatKingCrownBase = 9;
        public float toughnessStatCloud = 1.0f;
        public float toughnessStatDragon = 1.0f;
        public float toughnessStatBull = 1.0f;
        public float toughnessStatSpider = 1.0f;
        public float toughnessStatSlime = 1.0f;
        public float toughnessStatTurtle = 1.0f;
        public float toughnessStatHeavyDiamond = 4.0f;
        public float toughnessStatHeavyIron = 2.0f;
        public float toughnessStatBackpack = 0.0f;
        public float toughnessStatInquisition = 1.0f;
        public float toughnessStatKingCrown = 0.5f;
        public int monkingGreatSwordHarvestLevel = 0;
        public int monkingGreatSwordDurability = 1560;
        public float monkingGreatSwordEfficiency = 0.0f;
        public float monkingGreatSwordDamage = 5.0f;
        public int monkingGreatSwordEnchantability = 10;
        public int bullGreatSwordHarvestLevel = 0;
        public int bullGreatSwordDurability = 1560;
        public float bullGreatSwordEfficiency = 0.0f;
        public float bullGreatSwordDamage = 5.0f;
        public int bullGreatSwordEnchantability = 10;
        public int diamondGreatSwordHarvestLevel = 0;
        public int diamondGreatSwordDurability = 1560;
        public float diamondGreatSwordEfficiency = 0.0f;
        public float diamondGreatSwordDamage = 5.0f;
        public int diamondGreatSwordEnchantability = 10;
        public int ironGreatSwordHarvestLevel = 0;
        public int ironGreatSwordDurability = 250;
        public float ironGreatSwordEfficiency = 0.0f;
        public float ironGreatSwordDamage = 4.0f;
        public int ironGreatSwordEnchantability = 14;
        public int ironSpearHarvestLevel = 0;
        public int ironSpearDurability = 250;
        public float ironSpearEfficiency = 0.0f;
        public float ironSpearDamage = 2.0f;
        public int ironSpearEnchantability = 7;
        public int diamondSpearHarvestLevel = 0;
        public int diamondSpearDurability = 1560;
        public float diamondSpearEfficiency = 0.0f;
        public float diamondSpearDamage = 3.0f;
        public int diamondSpearEnchantability = 10;
        public int ironDaggerHarvestLevel = 0;
        public int ironDaggerDurability = 250;
        public float ironDaggerEfficiency = 0.0f;
        public float ironDaggerDamage = 0.5f;
        public int ironDaggerEnchantability = 14;
        public int diamondDaggerHarvestLevel = 0;
        public int diamondDaggerDurability = 1560;
        public float diamondDaggerEfficiency = 0.0f;
        public float diamondDaggerDamage = 1.5f;
        public int diamondDaggerEnchantability = 10;
        public int monkingDaggerHarvestLevel = 0;
        public int monkingDaggerDurability = 1560;
        public float monkingDaggerEfficiency = 0.0f;
        public float monkingDaggerDamage = 2.5f;
        public int monkingDaggerEnchantability = 10;
        public int ninjaDaggerHarvestLevel = 0;
        public int ninjaDaggerDurability = 2048;
        public float ninjaDaggerEfficiency = 0.0f;
        public float ninjaDaggerDamage = 2.5f;
        public int ninjaDaggerEnchantability = 10;
        public int bullBattleAxeHarvestLevel = 0;
        public int bullBattleAxeDurability = 1560;
        public float bullBattleAxeEfficiency = 0.0f;
        public float bullBattleAxeDamage = 5.0f;
        public int bullBattleAxeEnchantability = 10;
        public int turtleSwordHarvestLevel = 0;
        public int turtleSwordDurability = 2048;
        public float turtleSwordEfficiency = 0.0f;
        public float turtleSwordDamage = 3.0f;
        public int turtleSwordEnchantability = 10;
        public int spiderSwordHarvestLevel = 0;
        public int spiderSwordDurability = 2048;
        public float spiderSwordEfficiency = 0.0f;
        public float spiderSwordDamage = 3.0f;
        public int spiderSwordEnchantability = 10;
        public int moonlightHarvestLevel = 0;
        public int moonlightDurability = 2048;
        public float moonlightEfficiency = 0.0f;
        public float moonlightDamage = 3.0f;
        public int moonlightEnchantability = 10;
        public int sunshineHarvestLevel = 0;
        public int sunshineDurability = 2048;
        public float sunshineEfficiency = 0.0f;
        public float sunshineDamage = 3.0f;
        public int sunshineEnchantability = 10;
        public int walkerSwordHarvestLevel = 0;
        public int walkerSwordDurability = 2048;
        public float walkerSwordEfficiency = 0.0f;
        public float walkerSwordDamage = 3.0f;
        public int walkerSwordEnchantability = 10;
        public int musketIronHarvestLevel = 0;
        public int musketIronDurability = 300;
        public float musketIronEfficiency = 0.0f;
        public float musketIronDamage = 0.0f;
        public int musketIronEnchantability = 14;
        public int musketDiamondHarvestLevel = 0;
        public int musketDiamondDurability = 300;
        public float musketDiamondEfficiency = 0.0f;
        public float musketDiamondDamage = 1.0f;
        public int musketDiamondEnchantability = 10;
        public int musketMonkingHarvestLevel = 0;
        public int musketMonkingDurability = 300;
        public float musketMonkingEfficiency = 0.0f;
        public float musketMonkingDamage = 3.0f;
        public int musketMonkingEnchantability = 10;
    }

    public static class Advanced {
        @Config.Comment(value={"Blocks which will be saved in an extra part when exporting a structure which otherwise might not be placed correctly."})
        public String[] specialBlocks = new String[]{"minecraft:bed", "minecraft:wooden_door", "minecraft:spruce_door", "minecraft:birch_door", "minecraft:jungle_door", "minecraft:acacia_door", "minecraft:dark_oak_door", "minecraft:iron_door", "minecraft:piston", "minecraft:sticky_piston", "minecraft:piston_head"};
        @Config.Comment(value={"Entities which will be exported despite the ignore entities checkbox being checked."})
        public String[] specialEntities = new String[]{"minecraft:painting", "minecraft:item_frame", "minecraft:armor_stand", "minecraft:minecart", "minecraft:chest_minecart", "minecraft:furnace_minecart", "minecraft:tnt_minecart", "minecraft:hopper_minecart", "minecraft:boat"};
        @Config.Comment(value={"When enabled cqr mobs only take 50% damage from IceAndFire mobs and deal 200% damage against IceAndFire mobs."})
        public boolean enableSpecialFeatures = true;
        @Config.Comment(value={"Only render the nearest 'limitEntityRenderingCount' amount of CQR entities. Bosses will be rendered normally."})
        public boolean limitEntityRendering = false;
        @Config.Comment(value={"The maximum amount of entities that get rendered."})
        @Config.RangeInt(min=8, max=256)
        public int limitEntityRenderingCount = 64;
        @Config.Comment(value={"Skip rendering of entities that are behind blocks/not visible. Bosses will be rendered normally. This might cause issues where a mob is partly behind a block and thus does not get rendered but it's usually not really noticable. This setting has no effect when Entity Culling is installed."})
        public boolean skipHiddenEntityRendering = true;
        @Config.Comment(value={"It raytraces from the eyes of the player to the eyes of the mob and the other way around. Then it compares the positions that were hit and only renders the entity when no block was hit or the distance between both points is lower than this setting. This setting has no effect when Entity Culling is installed."})
        @Config.RangeInt(min=0, max=256)
        public int skipHiddenEntityRenderingDiff = 16;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"Enable/Disable loading and caching of structure files during startup."})
        public boolean cacheStructureFiles = true;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"The maximum amount of kilobytes which will be cached. Ram usage will be approximately x * 200 kilobytes. This was the result when caching multiple, differently sized structure files and thus might not be representative for your setup."})
        @Config.RangeInt(min=1, max=16384)
        public int cachedStructureFilesMaxSize = 256;
        @Config.RequiresWorldRestart
        @Config.Comment(value={"The maximum amount of files which will be cached."})
        @Config.RangeInt(min=1, max=16384)
        public int cachedStructureFilesMaxAmount = 256;
        @Config.Comment(value={"The amount of milliseconds each dungeon is allowed to consume per tick during generation."})
        @Config.RangeInt(min=1, max=100)
        public int generationSpeed = 20;
        @Config.Comment(value={"The amount of operations each dungeon is allowed to do each tick during generation."})
        @Config.RangeInt(min=1, max=1000000000)
        public int generationLimit = 20000;
        @Config.Comment(value={"When disable all light updates are delayed until the dungeon is generated which is usually a lot faster. (When Phosphor is installed this has no effect and light updates are processed immediately)"})
        public boolean instantLightUpdates = false;
        @Config.Comment(value={"When enabled and a flying entity is hit by a cqr lightning it gets extra damage."})
        public boolean flyingCowardPenaltyEnabled = true;
        @Config.RangeDouble(min=1.0)
        public double flyingCowardPenaltyDamage = 10.0;
        public boolean enableMaxDamageCaps = true;
        @Config.Comment(value={"Enable/Disable checking for nearby vanilla structures before spawning a dungeon."})
        public boolean generationRespectOtherStructures = true;
        @Config.RangeInt(min=0, max=1024)
        public double generationMinDistanceToOtherStructure = 64.0;
        @Config.Comment(value={"Enable/Disable multithreaded dungeon preparation. When enabled the calculations to prepare a dungeon for generation are done on another thread."})
        public boolean multithreadedDungeonPreparation = true;
        @Config.Comment(value={"When enabled when starting the game it checks all structure files and tries to update the deprecated ones."})
        public boolean checkAndUpdateDeprecatedStructureFiles = false;
        @Config.Comment(value={"If activated, it will try to avoid generating the same structure of a dungeon type again and again."})
        public boolean tryPreventingDuplicateDungeons = true;
        @Config.Comment(value={"If enabled, a faction will consider you as ally when you are on a team with the same name as the faction."})
        public boolean enableOldFactionMemberTeams = false;
        @Config.Comment(value={"When enabled overwrites the amount of chunks a ticket can keep loaded when generating/exporting dungeons."})
        public boolean overwriteForgeChunkLoadingLimit = true;
    }
}

