/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

public class CQRWeightedRandom<T> {
    private static final Random RAND = new Random();
    private List<WeightedObject<T>> items = new ArrayList<WeightedObject<T>>();
    private int totalWeight = 0;

    public CQRWeightedRandom() {
    }

    @SafeVarargs
    public CQRWeightedRandom(WeightedObject<T> ... weightedObjects) {
        for (WeightedObject<T> weightedObject : weightedObjects) {
            this.add(weightedObject);
        }
    }

    public CQRWeightedRandom(Collection<WeightedObject<T>> weightedObjects) {
        for (WeightedObject<T> weightedObject : weightedObjects) {
            this.add(weightedObject);
        }
    }

    public void add(T item, int weight) {
        this.add(new WeightedObject<T>(item, weight));
    }

    public void add(WeightedObject<T> weightedObject) {
        if (((WeightedObject)weightedObject).weight > 0) {
            this.totalWeight += ((WeightedObject)weightedObject).weight;
            this.items.add(weightedObject);
        }
    }

    public int numItems() {
        return this.items.size();
    }

    public void clear() {
        this.totalWeight = 0;
        this.items.clear();
    }

    @Nullable
    public T next() {
        return this.next(RAND);
    }

    @Nullable
    public T next(Random rand) {
        if (this.numItems() > 0) {
            if (this.totalWeight > 0) {
                int seed = rand.nextInt(this.totalWeight);
                int total = 0;
                for (WeightedObject<T> item : this.items) {
                    if ((total += ((WeightedObject)item).weight) <= seed) continue;
                    return (T)((WeightedObject)item).object;
                }
                return null;
            }
            return (T)((WeightedObject)this.items.get(0)).object;
        }
        return null;
    }

    public CQRWeightedRandom<T> copy() {
        return new CQRWeightedRandom<T>(this.items);
    }

    public static class WeightedObject<T> {
        private T object;
        private int weight;

        public WeightedObject(T object, int weight) {
            this.object = object;
            this.weight = weight;
        }
    }
}

