/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.reflection.ReflectionField;

public class ChunkUtil {
    private static final ReflectionField<Integer> FIELD_MAX_DEPTH = new ReflectionField(ForgeChunkManager.Ticket.class, "maxDepth", "maxDepth");

    public static ForgeChunkManager.Ticket getTicket(World world, BlockPos pos1, BlockPos pos2) {
        return ChunkUtil.getTicket(world, pos1.func_177958_n() >> 4, pos1.func_177952_p() >> 4, pos2.func_177958_n() >> 4, pos2.func_177952_p() >> 4, false);
    }

    public static ForgeChunkManager.Ticket getTicket(World world, BlockPos pos1, BlockPos pos2, boolean overwriteChunkLimit) {
        return ChunkUtil.getTicket(world, pos1.func_177958_n() >> 4, pos1.func_177952_p() >> 4, pos2.func_177958_n() >> 4, pos2.func_177952_p() >> 4, overwriteChunkLimit);
    }

    public static ForgeChunkManager.Ticket getTicket(World world, int chunkStartX, int chunkStartZ, int chunkEndX, int chunkEndZ) {
        return ChunkUtil.getTicket(world, chunkStartX, chunkStartZ, chunkEndX, chunkEndZ, false);
    }

    public static ForgeChunkManager.Ticket getTicket(World world, int chunkStartX, int chunkStartZ, int chunkEndX, int chunkEndZ, boolean overwriteChunkLimit) {
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)CQRMain.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            return null;
        }
        if (CQRConfig.advanced.overwriteForgeChunkLoadingLimit && overwriteChunkLimit) {
            FIELD_MAX_DEPTH.set(ticket, 0);
        }
        for (int x = chunkStartX; x <= chunkEndX; ++x) {
            for (int z = chunkStartZ; z <= chunkEndZ; ++z) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(x, z));
            }
        }
        return ticket;
    }
}

