/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

public class Circle2D {
    public int radius;
    private HashSet<Coord> fill;
    private HashSet<Coord> border;
    private HashSet<Coord> insideEdge;

    public Circle2D(int centerX, int centerZ, int radius) {
        this.radius = radius;
        int innerRadius = radius - 1;
        int outerRadius = radius + 1;
        this.fill = new HashSet();
        this.insideEdge = new HashSet();
        this.border = new HashSet();
        for (int dX = -outerRadius; dX < outerRadius; ++dX) {
            for (int dZ = -outerRadius; dZ < outerRadius; ++dZ) {
                int distSq = dX * dX + dZ * dZ;
                if (distSq < radius * radius) {
                    this.fill.add(new Coord(centerX + dX, centerZ + dZ));
                    if (distSq <= innerRadius * innerRadius) continue;
                    this.insideEdge.add(new Coord(centerX + dX, centerZ + dZ));
                    continue;
                }
                if (distSq >= outerRadius * outerRadius) continue;
                this.border.add(new Coord(centerX + dX, centerZ + dZ));
            }
        }
    }

    public ArrayList<Coord> getFloorArray() {
        return new ArrayList<Coord>(this.fill);
    }

    public ArrayList<Coord> getWallArray() {
        return new ArrayList<Coord>(this.border);
    }

    public ArrayList<Coord> getEdgeArray() {
        return new ArrayList<Coord>(this.insideEdge);
    }

    public boolean isCoordInFill(int x, int y) {
        return this.fill.contains(new Coord(x, y));
    }

    public boolean isCoordOnBorder(int x, int y) {
        return this.border.contains(new Coord(x, y));
    }

    public boolean isCoordOnInsideEdge(int x, int y) {
        return this.insideEdge.contains(new Coord(x, y));
    }

    public boolean isCoordInCircle(int x, int y) {
        Coord c = new Coord(x, y);
        return this.fill.contains(c) || this.border.contains(c);
    }

    public class Coord {
        public int x;
        public int z;

        private Coord(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Coord)) {
                return false;
            }
            Coord c = (Coord)o;
            return this.x == c.x && this.z == c.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.z);
        }
    }

    public static enum CircleRegion {
        OUTSIDE,
        EDGE,
        INSIDE;

    }
}

