/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import team.cqr.cqrepoured.objects.banners.BannerHelper;
import team.cqr.cqrepoured.objects.blocks.BlockExporterChest;
import team.cqr.cqrepoured.structuregen.DungeonRegistry;
import team.cqr.cqrepoured.structuregen.DungeonSpawnPos;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.CQRConfig;

public class DungeonGenUtils {
    private static final Random RAND = new Random();

    public static boolean isInsideCircle(int x, int z, int radius) {
        return x * x + z * z < radius * radius;
    }

    public static boolean isInsideSphere(BlockPos pos, BlockPos center, int radius) {
        return center.func_177951_i((Vec3i)pos) < (double)(radius * radius);
    }

    public static boolean isInsideSphere(int x, int y, int z, int radius) {
        return x * x + y * y + z * z < radius * radius;
    }

    public static boolean isInsideSpheroid(Vec3i pointOnSphere, double radX, double radY, double radZ) {
        double axisX = pointOnSphere.func_177958_n();
        axisX *= axisX;
        double axisY = pointOnSphere.func_177956_o();
        axisY *= axisY;
        double axisZ = pointOnSphere.func_177952_p();
        axisZ *= axisZ;
        return (axisX /= radX * radX) + (axisY /= radY * radY) + (axisZ /= radZ * radZ) == 1.0;
    }

    public static boolean isInsideSpheroid(Vec3i pointInSpace, Vec3i spheroidCenter, double radX, double radY, double radZ) {
        return DungeonGenUtils.isInsideSpheroid(new Vec3i(pointInSpace.func_177958_n() - spheroidCenter.func_177958_n(), pointInSpace.func_177956_o() - spheroidCenter.func_177956_o(), pointInSpace.func_177952_p() - spheroidCenter.func_177952_p()), radX, radY, radZ);
    }

    public static boolean isInsideSpheroid(Vec3i pointOnSphere, double radWidth, double radHeight) {
        return DungeonGenUtils.isInsideSpheroid(pointOnSphere, radWidth, radHeight, radWidth);
    }

    public static boolean isInsideSpheroid(Vec3i pointInSpace, Vec3i spheroidCenter, double radWidth, double radHeight) {
        return DungeonGenUtils.isInsideSpheroid(pointInSpace, spheroidCenter, radWidth, radHeight, radWidth);
    }

    public static boolean percentageRandom(int chance) {
        return DungeonGenUtils.percentageRandom(chance, RAND);
    }

    public static boolean percentageRandom(int chance, Random rand) {
        if (chance <= 0) {
            return false;
        }
        if (chance >= 100) {
            return true;
        }
        return rand.nextInt(100) < chance;
    }

    public static boolean percentageRandom(double chance) {
        return DungeonGenUtils.percentageRandom(chance, RAND);
    }

    public static boolean percentageRandom(double chance, Random rand) {
        if (chance <= 0.0) {
            return false;
        }
        if (chance >= 1.0) {
            return true;
        }
        return rand.nextDouble() < chance;
    }

    public static int randomBetween(int min, int max) {
        return DungeonGenUtils.randomBetween(min, max, RAND);
    }

    public static int randomBetween(int min, int max, Random rand) {
        if (min >= max) {
            return min;
        }
        return min + rand.nextInt(max - min + 1);
    }

    public static int randomBetweenGaussian(int min, int max) {
        return DungeonGenUtils.randomBetweenGaussian(min, max, RAND);
    }

    public static int randomBetweenGaussian(int min, int max, Random rand) {
        if (min >= max) {
            return min;
        }
        double avg = (double)min + (double)(max - min) / 2.0;
        double stdDev = ((double)max - avg) / 3.0;
        double gaussian = rand.nextGaussian();
        int result = (int)(avg + gaussian * stdDev + 0.5);
        return MathHelper.func_76125_a((int)result, (int)min, (int)max);
    }

    public static boolean isLootChest(Block b) {
        return b instanceof BlockExporterChest;
    }

    public static boolean isCQBanner(TileEntityBanner banner) {
        return BannerHelper.isCQBanner(banner);
    }

    public static boolean isInWallRange(World world, int chunkX, int chunkZ) {
        if (!CQRConfig.wall.enabled) {
            return false;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return false;
        }
        if (chunkZ < -CQRConfig.wall.distance - 12) {
            return false;
        }
        return chunkZ <= -CQRConfig.wall.distance + 12;
    }

    public static boolean isFarAwayEnoughFromSpawn(World world, int chunkX, int chunkZ) {
        int z;
        if (!world.field_73011_w.func_76567_e()) {
            return true;
        }
        int x = chunkX - (DungeonGenUtils.getSpawnX(world) >> 4);
        return x * x + (z = chunkZ - (DungeonGenUtils.getSpawnZ(world) >> 4)) * z >= CQRConfig.general.dungeonSpawnDistance * CQRConfig.general.dungeonSpawnDistance;
    }

    public static boolean isFarAwayEnoughFromLocationSpecifics(World world, int chunkX, int chunkZ, int dungeonSeparation) {
        int dim = world.field_73011_w.getDimension();
        for (DungeonBase dungeon : DungeonRegistry.getInstance().getDungeons()) {
            if (!dungeon.isEnabled() || dungeon.isModDependencyMissing() || !dungeon.isValidDim(dim)) continue;
            for (DungeonSpawnPos dungeonSpawnPos : dungeon.getLockedPositions()) {
                int z;
                int x = chunkX - (dungeonSpawnPos.getX(world) >> 4);
                if (x * x + (z = chunkZ - (dungeonSpawnPos.getZ(world) >> 4)) * z >= dungeonSeparation * dungeonSeparation) continue;
                return false;
            }
        }
        return true;
    }

    public static Vec3i rotateVec3i(Vec3i vec, EnumFacing side) {
        if (side == EnumFacing.SOUTH) {
            return new Vec3i(-vec.func_177958_n(), vec.func_177956_o(), -vec.func_177952_p());
        }
        if (side == EnumFacing.WEST) {
            return new Vec3i(vec.func_177952_p(), vec.func_177956_o(), -vec.func_177958_n());
        }
        if (side == EnumFacing.EAST) {
            return new Vec3i(-vec.func_177952_p(), vec.func_177956_o(), vec.func_177958_n());
        }
        return vec;
    }

    public static Vec3i rotateMatrixOffsetCW(Vec3i offset, int sizeX, int sizeZ, int numRotations) {
        int maxXIndex = sizeX - 1;
        int maxZIndex = sizeZ - 1;
        if (numRotations % 4 == 0) {
            return new Vec3i(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        }
        if (numRotations % 4 == 1) {
            return new Vec3i(maxZIndex - offset.func_177952_p(), offset.func_177956_o(), offset.func_177958_n());
        }
        if (numRotations % 4 == 2) {
            return new Vec3i(maxXIndex - offset.func_177958_n(), offset.func_177956_o(), maxZIndex - offset.func_177952_p());
        }
        return new Vec3i(offset.func_177952_p(), offset.func_177956_o(), maxXIndex - offset.func_177958_n());
    }

    public static int getCWRotationsBetween(EnumFacing start, EnumFacing end) {
        int rotations = 0;
        if (start.func_176740_k().func_176722_c() && end.func_176740_k().func_176722_c()) {
            while (start != end) {
                start = start.func_176746_e();
                ++rotations;
            }
        }
        return rotations;
    }

    public static EnumFacing rotateFacingNTimesAboutY(EnumFacing facing, int n) {
        for (int i = 0; i < n; ++i) {
            facing = facing.func_176746_e();
        }
        return facing;
    }

    public static BlockPos getMinPos(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), Math.min(pos1.func_177956_o(), pos2.func_177956_o()), Math.min(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos getMaxPos(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), Math.max(pos1.func_177956_o(), pos2.func_177956_o()), Math.max(pos1.func_177952_p(), pos2.func_177952_p()));
    }

    public static BlockPos getValidMinPos(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.max(Math.min(pos1.func_177958_n(), pos2.func_177958_n()), -30000000), Math.max(Math.min(pos1.func_177956_o(), pos2.func_177956_o()), 0), Math.max(Math.min(pos1.func_177952_p(), pos2.func_177952_p()), -30000000));
    }

    public static BlockPos getValidMaxPos(BlockPos pos1, BlockPos pos2) {
        return new BlockPos(Math.min(Math.max(pos1.func_177958_n(), pos2.func_177958_n()), 30000000), Math.min(Math.max(pos1.func_177956_o(), pos2.func_177956_o()), 255), Math.min(Math.max(pos1.func_177952_p(), pos2.func_177952_p()), 30000000));
    }

    public static BlockPos getTransformedStartPos(BlockPos startPos, BlockPos size, PlacementSettings settings) {
        if (settings.func_186212_b() == Mirror.NONE && settings.func_186215_c() == Rotation.NONE) {
            return startPos;
        }
        BlockPos pos = Template.func_186266_a((PlacementSettings)settings, (BlockPos)size);
        int x = startPos.func_177958_n();
        int y = startPos.func_177956_o();
        int z = startPos.func_177952_p();
        boolean flag = false;
        if (pos.func_177958_n() < 0) {
            x -= pos.func_177958_n() + 1;
            flag = true;
        }
        if (pos.func_177952_p() < 0) {
            z -= pos.func_177952_p() + 1;
            flag = true;
        }
        return flag ? new BlockPos(x, y, z) : startPos;
    }

    public static int getYForPos(World world, int x, int z, boolean ignoreWater) {
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, chunk.func_76625_h() + 15, z);
        Material material = chunk.func_177435_g((BlockPos)mutablePos).func_185904_a();
        while (mutablePos.func_177956_o() > 0 && (material == Material.field_151579_a || material == Material.field_151575_d || material == Material.field_151584_j || material == Material.field_151585_k || ignoreWater && material == Material.field_151586_h)) {
            mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
            material = chunk.func_177435_g((BlockPos)mutablePos).func_185904_a();
        }
        return mutablePos.func_177956_o() + 1;
    }

    public static Vec3d transformedVec3d(Vec3d vec, PlacementSettings settings) {
        return DungeonGenUtils.transformedVec3d(vec, settings.func_186212_b(), settings.func_186215_c());
    }

    public static Vec3d transformedVec3d(Vec3d vec, Mirror mirror, Rotation rotation) {
        double i = vec.field_72450_a;
        double j = vec.field_72448_b;
        double k = vec.field_72449_c;
        boolean flag = true;
        switch (mirror) {
            case LEFT_RIGHT: {
                k = 1.0 - k;
                break;
            }
            case FRONT_BACK: {
                i = 1.0 - i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(k, j, 1.0 - i);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - k, j, i);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - i, j, 1.0 - k);
            }
        }
        return flag ? new Vec3d(i, j, k) : vec;
    }

    public static NBTTagList writePosToList(BlockPos pos) {
        NBTTagList nbtTagList = new NBTTagList();
        nbtTagList.func_74742_a((NBTBase)new NBTTagInt(pos.func_177958_n()));
        nbtTagList.func_74742_a((NBTBase)new NBTTagInt(pos.func_177956_o()));
        nbtTagList.func_74742_a((NBTBase)new NBTTagInt(pos.func_177952_p()));
        return nbtTagList;
    }

    public static BlockPos readPosFromList(NBTTagList nbtTagList) {
        return new BlockPos(nbtTagList.func_186858_c(0), nbtTagList.func_186858_c(1), nbtTagList.func_186858_c(2));
    }

    public static NBTTagList writeVecToList(Vec3d vec) {
        NBTTagList nbtTagList = new NBTTagList();
        nbtTagList.func_74742_a((NBTBase)new NBTTagDouble(vec.field_72450_a));
        nbtTagList.func_74742_a((NBTBase)new NBTTagDouble(vec.field_72448_b));
        nbtTagList.func_74742_a((NBTBase)new NBTTagDouble(vec.field_72449_c));
        return nbtTagList;
    }

    public static Vec3d readVecFromList(NBTTagList nbtTagList) {
        return new Vec3d(nbtTagList.func_150309_d(0), nbtTagList.func_150309_d(1), nbtTagList.func_150309_d(2));
    }

    public static NBTTagList writeUUIDToList(UUID uuid) {
        NBTTagList nbtTagList = new NBTTagList();
        nbtTagList.func_74742_a((NBTBase)new NBTTagLong(uuid.getMostSignificantBits()));
        nbtTagList.func_74742_a((NBTBase)new NBTTagLong(uuid.getLeastSignificantBits()));
        return nbtTagList;
    }

    public static UUID readUUIDFromList(NBTTagList nbtTagList) {
        NBTBase nbtM = nbtTagList.func_179238_g(0);
        NBTBase nbtL = nbtTagList.func_179238_g(1);
        return new UUID(nbtM instanceof NBTTagLong ? ((NBTTagLong)nbtM).func_150291_c() : 0L, nbtM instanceof NBTTagLong ? ((NBTTagLong)nbtL).func_150291_c() : 0L);
    }

    public static BlockPos getCentralizedPosForStructure(BlockPos pos, CQStructure structure, PlacementSettings settings) {
        BlockPos transformedSize = Template.func_186266_a((PlacementSettings)settings, (BlockPos)structure.getSize());
        return pos.func_177982_a(-(transformedSize.func_177958_n() >> 1), 0, -(transformedSize.func_177952_p() >> 1));
    }

    public static int getSpawnX(World world) {
        int x = world.func_72912_H().func_76079_c();
        return (double)x >= world.func_175723_af().func_177726_b() && (double)x < world.func_175723_af().func_177728_d() ? x : MathHelper.func_76128_c((double)world.func_175723_af().func_177731_f());
    }

    public static int getSpawnY(World world) {
        return world.func_72912_H().func_76075_d();
    }

    public static int getSpawnZ(World world) {
        int z = world.func_72912_H().func_76074_e();
        return (double)z >= world.func_175723_af().func_177736_c() && (double)z < world.func_175723_af().func_177733_e() ? z : MathHelper.func_76128_c((double)world.func_175723_af().func_177721_g());
    }
}

