/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityUtil {
    public static void move2D(Entity entity, double strafe, double forward, double speed, double yaw) {
        double d = strafe * strafe + forward * forward;
        if (d >= 1.0E-4) {
            if ((d = Math.sqrt(d)) < 1.0) {
                d = 1.0;
            }
            d = speed / d;
            double d1 = Math.sin(Math.toRadians(yaw));
            double d2 = Math.cos(Math.toRadians(yaw));
            entity.field_70159_w += (strafe *= d) * d2 - (forward *= d) * d1;
            entity.field_70179_y += forward * d2 + strafe * d1;
        }
    }

    public static void move3D(Entity entity, double strafe, double up, double forward, double speed, double yaw, double pitch) {
        double d = strafe * strafe + up * up + forward * forward;
        if (d >= 1.0E-4) {
            if ((d = Math.sqrt(d)) < 1.0) {
                d = 1.0;
            }
            d = speed / d;
            strafe *= d;
            up *= d;
            double d1 = Math.sin(Math.toRadians(yaw));
            double d2 = Math.cos(Math.toRadians(yaw));
            double d3 = Math.sin(Math.toRadians(pitch));
            double d4 = Math.cos(Math.toRadians(pitch));
            entity.field_70159_w += strafe * d2 - (forward *= d) * d1 * d4;
            entity.field_70181_x += up - forward * d3;
            entity.field_70179_y += forward * d2 * d4 + strafe * d1;
        }
    }

    public static boolean isEntityFlying(Entity entity) {
        if (entity.field_70122_E) {
            return false;
        }
        if (entity.field_70132_H) {
            return false;
        }
        if (entity.field_70181_x < -0.1) {
            return false;
        }
        BlockPos pos = new BlockPos(entity);
        int y = 0;
        int count = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                mutablePos.func_181079_c(pos.func_177958_n() + i, pos.func_177956_o(), pos.func_177952_p() + j);
                if (!entity.func_130014_f_().func_175667_e((BlockPos)mutablePos)) continue;
                while (mutablePos.func_177956_o() > 0 && entity.func_130014_f_().func_180495_p((BlockPos)mutablePos).func_185890_d((IBlockAccess)entity.func_130014_f_(), (BlockPos)mutablePos) == Block.field_185506_k) {
                    mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
                }
                y += mutablePos.func_177956_o() + 1;
                ++count;
            }
        }
        int n = y = count > 0 ? y / count : (int)entity.field_70163_u;
        if (entity.field_70163_u < (double)(y + 8)) {
            return false;
        }
        return !entity.func_130014_f_().func_72829_c(entity.func_174813_aQ());
    }

    @Nullable
    public static Entity getEntityByUUID(World world, UUID uuid) {
        if (!world.field_72995_K) {
            return ((WorldServer)world).func_175733_a(uuid);
        }
        for (Entity entity : world.field_72996_f) {
            if (!entity.getPersistentID().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static void applyMaxHealthModifier(EntityLivingBase entity, UUID uuid, String name, double amount) {
        IAttributeInstance attribute = entity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (attribute == null) {
            return;
        }
        AttributeModifier oldModifier = attribute.func_111127_a(uuid);
        float oldHealth = entity.func_110143_aJ();
        double oldAmount = 0.0;
        if (oldModifier != null) {
            oldAmount = oldModifier.func_111164_d();
            if (Math.abs(amount - oldAmount) < 0.01) {
                return;
            }
            attribute.func_111124_b(oldModifier);
        }
        attribute.func_111121_a(new AttributeModifier(uuid, name, amount, 2));
        entity.func_70606_j((float)((double)oldHealth / (1.0 + oldAmount) * (1.0 + amount) + 1.0E-7));
    }
}

