/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.util.BlockStateGenArray;

public class GenerationTemplate {
    private List<GenerationRule> generationRules = new ArrayList<GenerationRule>();
    private int lengthX;
    private int lengthY;
    private int lengthZ;
    private boolean fillUnusedBlockWithAir = true;

    public GenerationTemplate(int lengthX, int lengthY, int lengthZ) {
        this.lengthX = lengthX;
        this.lengthY = lengthY;
        this.lengthZ = lengthZ;
    }

    public void setFillUnusedBlockWithAir(boolean shouldFill) {
        this.fillUnusedBlockWithAir = shouldFill;
    }

    public GenerationTemplate(Vec3i dimensions) {
        this.lengthX = dimensions.func_177958_n();
        this.lengthY = dimensions.func_177956_o();
        this.lengthZ = dimensions.func_177952_p();
    }

    public void addRule(Predicate<Vec3i> condition, IBlockState blockToBuild) {
        this.generationRules.add(new GenerationRule(condition, blockToBuild));
    }

    public void AddToGenArray(BlockPos origin, BlockStateGenArray genArray, BlockStateGenArray.GenerationPhase phase) {
        this.AddToGenArray(origin, genArray, phase, null);
    }

    public void AddToGenArray(BlockPos origin, BlockStateGenArray genArray, BlockStateGenArray.GenerationPhase phase, @Nullable HashSet<BlockPos> positionsFilled) {
        HashMap<BlockPos, IBlockState> genMap = this.GetGenerationMap(origin, this.fillUnusedBlockWithAir);
        genArray.addBlockStateMap(genMap, phase, BlockStateGenArray.EnumPriority.MEDIUM);
        if (positionsFilled != null) {
            for (Map.Entry<BlockPos, IBlockState> entry : genMap.entrySet()) {
                if (entry.getValue().func_177230_c() == Blocks.field_150350_a) continue;
                positionsFilled.add(entry.getKey());
            }
        }
    }

    public HashMap<BlockPos, IBlockState> GetGenerationMap(BlockPos origin, boolean fillUnusedWithAir) {
        HashMap<BlockPos, IBlockState> result = new HashMap<BlockPos, IBlockState>();
        for (int x = 0; x < this.lengthX; ++x) {
            for (int z = 0; z < this.lengthZ; ++z) {
                for (int y = 0; y < this.lengthY; ++y) {
                    boolean foundRule = false;
                    Vec3i offset = new Vec3i(x, y, z);
                    for (GenerationRule rule : this.generationRules) {
                        if (!rule.getCondition().test(offset)) continue;
                        result.put(origin.func_177971_a(offset), rule.getBlock());
                        foundRule = true;
                        break;
                    }
                    if (foundRule || !fillUnusedWithAir) continue;
                    result.put(origin.func_177971_a(offset), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
        return result;
    }

    public ArrayList<Map.Entry<BlockPos, IBlockState>> GetGenerationList(BlockPos origin, boolean fillUnusedWithAir) {
        return new ArrayList<Map.Entry<BlockPos, IBlockState>>(this.GetGenerationMap(origin, fillUnusedWithAir).entrySet());
    }

    private class GenerationRule {
        public Predicate<Vec3i> condition;
        public IBlockState block;

        public GenerationRule(Predicate<Vec3i> condition, IBlockState blockToBuild) {
            this.condition = condition;
            this.block = blockToBuild;
        }

        public Predicate<Vec3i> getCondition() {
            return this.condition;
        }

        public IBlockState getBlock() {
            return this.block;
        }
    }
}

