/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.structuregen.DungeonSpawnPos;
import team.cqr.cqrepoured.util.CQRWeightedRandom;
import team.cqr.cqrepoured.util.EnumMCWoodType;

public class PropertyFileHelper {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Properties readPropFile(File file) {
        if (!file.exists()) return null;
        if (!file.isFile()) return null;
        Properties prop = new Properties();
        try (FileInputStream inputStream = new FileInputStream(file);){
            prop.load(inputStream);
            Properties properties = prop;
            return properties;
        }
        catch (IOException e) {
            CQRMain.logger.error("Failed to load file " + file.getName(), (Throwable)e);
            return null;
        }
    }

    public static String getStringProperty(Properties prop, String key, String defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        return s;
    }

    public static boolean getBooleanProperty(Properties prop, String key, boolean defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        return defVal;
    }

    public static int getIntProperty(Properties prop, String key, int defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static int getIntProperty(Properties prop, String key, int defVal, int min, int max) {
        return MathHelper.func_76125_a((int)PropertyFileHelper.getIntProperty(prop, key, defVal), (int)min, (int)max);
    }

    public static double getDoubleProperty(Properties prop, String key, double defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static double getDoubleProperty(Properties prop, String key, double defVal, double min, double max) {
        return MathHelper.func_151237_a((double)PropertyFileHelper.getDoubleProperty(prop, key, defVal), (double)min, (double)max);
    }

    public static ResourceLocation getResourceLocationProperty(Properties prop, String key, ResourceLocation defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        return PropertyFileHelper.getResourceLocationFromString(s, defVal);
    }

    public static IBlockState getBlockStateProperty(Properties prop, String key, IBlockState defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        return PropertyFileHelper.getBlockStateFromString(s, defVal);
    }

    public static BlockPos getBlockPosProperty(Properties prop, String key, BlockPos defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        return PropertyFileHelper.getBlockPosFromString(s, defVal);
    }

    public static DungeonSpawnPos getDungeonSpawnPosProperty(Properties prop, String key, DungeonSpawnPos defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        return PropertyFileHelper.getDungeonSpawnPosFromString(s, defVal);
    }

    public static File getStructureFolderProperty(Properties prop, String key, String defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return new File(CQRMain.CQ_STRUCTURE_FILES_FOLDER, defVal);
        }
        if ((s = s.trim()).isEmpty()) {
            return new File(CQRMain.CQ_STRUCTURE_FILES_FOLDER, defVal);
        }
        File retFile = new File(CQRMain.CQ_STRUCTURE_FILES_FOLDER, s);
        if (!retFile.isDirectory()) {
            return new File(CQRMain.CQ_STRUCTURE_FILES_FOLDER, defVal);
        }
        return retFile;
    }

    public static EnumMCWoodType getWoodTypeProperty(Properties prop, String key, EnumMCWoodType defVal) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        if ((s = s.trim()).isEmpty()) {
            return defVal;
        }
        EnumMCWoodType retType = EnumMCWoodType.getTypeFromString(s);
        if (retType == null) {
            retType = defVal;
        }
        return retType;
    }

    public static String[] getStringArrayProperty(Properties prop, String key, String[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(",");
        Object[] retArr = new String[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            String tmp = splitStr[i].trim();
            if (!tmp.isEmpty()) {
                retArr[i - removed] = tmp;
                continue;
            }
            retArr = (String[])ArrayUtils.remove((Object[])retArr, (int)(i - removed));
            ++removed;
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static boolean[] getBooleanArrayProperty(Properties prop, String key, boolean[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(",");
        boolean[] retArr = new boolean[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            String tmp = splitStr[i].trim();
            if (tmp.equalsIgnoreCase("true")) {
                retArr[i - removed] = true;
                continue;
            }
            if (tmp.equalsIgnoreCase("false")) {
                retArr[i - removed] = false;
                continue;
            }
            retArr = ArrayUtils.remove((boolean[])retArr, (int)(i - removed));
            ++removed;
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static int[] getIntArrayProperty(Properties prop, String key, int[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(",");
        int[] retArr = new int[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            String tmp = splitStr[i].trim();
            try {
                retArr[i - removed] = Integer.parseInt(tmp);
                continue;
            }
            catch (NumberFormatException e) {
                retArr = ArrayUtils.remove((int[])retArr, (int)(i - removed));
                ++removed;
            }
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static double[] getDoubleArrayProperty(Properties prop, String key, double[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(",");
        double[] retArr = new double[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            String tmp = splitStr[i].trim();
            try {
                retArr[i - removed] = Double.parseDouble(tmp);
                continue;
            }
            catch (NumberFormatException e) {
                retArr = ArrayUtils.remove((double[])retArr, (int)(i - removed));
                ++removed;
            }
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static ResourceLocation[] getResourceLocationArrayProperty(Properties prop, String key, ResourceLocation[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(",");
        Object[] retArr = new ResourceLocation[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            ResourceLocation rs = PropertyFileHelper.getResourceLocationFromString(splitStr[i], null);
            if (rs != null) {
                retArr[i - removed] = rs;
                continue;
            }
            retArr = (ResourceLocation[])ArrayUtils.remove((Object[])retArr, (int)(i - removed));
            ++removed;
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static IBlockState[] getBlockStateArrayProperty(Properties prop, String key, IBlockState[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(",");
        Object[] retArr = new IBlockState[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            IBlockState state = PropertyFileHelper.getBlockStateFromString(splitStr[i], null);
            if (state != null) {
                retArr[i - removed] = state;
                continue;
            }
            retArr = (IBlockState[])ArrayUtils.remove((Object[])retArr, (int)(i - removed));
            ++removed;
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static BlockPos[] getBlockPosArrayProperty(Properties prop, String key, BlockPos[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(";");
        Object[] retArr = new BlockPos[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            BlockPos pos = PropertyFileHelper.getBlockPosFromString(splitStr[i], null);
            if (pos != null) {
                retArr[i - removed] = pos;
                continue;
            }
            retArr = (BlockPos[])ArrayUtils.remove((Object[])retArr, (int)(i - removed));
            ++removed;
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static DungeonSpawnPos[] getDungeonSpawnPosArrayProperty(Properties prop, String key, DungeonSpawnPos[] defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr = s.split(";");
        Object[] retArr = new DungeonSpawnPos[splitStr.length];
        int removed = 0;
        for (int i = 0; i < splitStr.length; ++i) {
            DungeonSpawnPos dungeonSpawnPos = PropertyFileHelper.getDungeonSpawnPosFromString(splitStr[i], null);
            if (dungeonSpawnPos != null) {
                retArr[i - removed] = dungeonSpawnPos;
                continue;
            }
            retArr = (DungeonSpawnPos[])ArrayUtils.remove((Object[])retArr, (int)(i - removed));
            ++removed;
        }
        if (!allowEmpty && retArr.length == 0) {
            return defVal;
        }
        return retArr;
    }

    public static CQRWeightedRandom<IBlockState> getWeightedBlockStateList(Properties prop, String key, CQRWeightedRandom<IBlockState> defVal, boolean allowEmpty) {
        String s = prop.getProperty(key);
        if (s == null) {
            return defVal;
        }
        s = s.trim();
        if (!allowEmpty && s.isEmpty()) {
            return defVal;
        }
        String[] splitStr1 = s.split(";");
        CQRWeightedRandom<IBlockState> retList = new CQRWeightedRandom<IBlockState>();
        for (String string : splitStr1) {
            String[] splitStr2 = string.split(",");
            if (splitStr2.length < 2) continue;
            IBlockState state = PropertyFileHelper.getBlockStateFromString(splitStr2[0], null);
            int weight = 0;
            try {
                weight = Integer.parseInt(splitStr2[1].trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (state == null || weight <= 0) continue;
            retList.add(state, weight);
        }
        if (!allowEmpty && retList.numItems() == 0) {
            return defVal;
        }
        return retList;
    }

    private static ResourceLocation getResourceLocationFromString(String s, ResourceLocation defVal) {
        String[] splitStr = s.split(":");
        String namespace = "minecraft";
        String path = null;
        if (splitStr.length >= 2) {
            String s1 = splitStr[0].trim();
            String s2 = splitStr[1].trim();
            if (!s1.isEmpty()) {
                namespace = s1;
            }
            if (!s2.isEmpty()) {
                path = s2;
            }
        } else {
            String s1 = s.trim();
            if (!s1.isEmpty()) {
                path = s1;
            }
        }
        return path != null ? new ResourceLocation(namespace, path) : defVal;
    }

    private static IBlockState getBlockStateFromString(String s, IBlockState defVal) {
        String[] splitStr = s.split(":");
        Block block = null;
        int meta = 0;
        if (splitStr.length >= 3) {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(splitStr[0].trim(), splitStr[1].trim()));
            try {
                meta = Integer.parseInt(splitStr[2].trim());
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (splitStr.length == 2) {
            try {
                meta = Integer.parseInt(splitStr[1].trim());
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(splitStr[0].trim()));
            }
            catch (NumberFormatException e) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(splitStr[0].trim(), splitStr[1].trim()));
            }
        } else {
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(splitStr[0].trim()));
        }
        return block != null ? block.func_176203_a(meta) : defVal;
    }

    public static BlockPos getBlockPosFromString(String s, BlockPos defVal) {
        String[] splitStr = s.split(",");
        if (splitStr.length >= 3) {
            try {
                int x = Integer.parseInt(splitStr[0].trim());
                int y = Integer.parseInt(splitStr[1].trim());
                int z = Integer.parseInt(splitStr[2].trim());
                return new BlockPos(x, y, z);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defVal;
    }

    public static DungeonSpawnPos getDungeonSpawnPosFromString(String s, DungeonSpawnPos defVal) {
        String[] splitStr = s.split(",");
        if (splitStr.length >= 2) {
            try {
                int x = Integer.parseInt(splitStr[0].trim());
                int z = Integer.parseInt(splitStr[1].trim());
                boolean spawnPointRelative = false;
                if (splitStr.length >= 3) {
                    spawnPointRelative = Boolean.valueOf(splitStr[2].trim());
                }
                return new DungeonSpawnPos(x, z, spawnPointRelative);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defVal;
    }
}

