/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import team.cqr.cqrepoured.util.data.ArrayCollectionMapManipulationUtil;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static Object getInstanceOfClass(Class c) {
        try {
            return c.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class getClassFromName(String verboseTypeNameAsSting) {
        try {
            return Class.forName(verboseTypeNameAsSting);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Field reflectGetField(Object instanceToAccess, String[] possibleNames) {
        Field[] allFields;
        for (Field field : allFields = ReflectionHelper.reflectGetAllFields(instanceToAccess)) {
            for (String name : possibleNames) {
                if (!ReflectionHelper.reflectGetFieldName(field).equals(name)) continue;
                return field;
            }
        }
        return null;
    }

    public static String reflectGetFieldName(Field toGetNameOf) {
        return toGetNameOf.getName();
    }

    public static Object reflectGetFieldValue(Object instance, Field toGetValueOf) {
        try {
            toGetValueOf.setAccessible(true);
            return toGetValueOf.get(instance);
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object reflectSetFieldValue(Object instance, Field toSet, Object value) {
        toSet.setAccessible(true);
        try {
            toSet.set(instance, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    public static Field[] reflectGetAllFields(Object instanceOrClassToAccess) {
        Object[] fieldsFromClass = new Field[]{};
        Object[] fieldsFromSuperclass = new Field[]{};
        Class<?> classToAccess = instanceOrClassToAccess instanceof Class ? (Class<?>)instanceOrClassToAccess : instanceOrClassToAccess.getClass();
        fieldsFromClass = classToAccess.getDeclaredFields();
        if (classToAccess.getSuperclass() != null && classToAccess.getSuperclass() != Object.class) {
            try {
                fieldsFromSuperclass = ReflectionHelper.reflectGetAllFields(classToAccess.getSuperclass());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Object[] tmpArr = ArrayCollectionMapManipulationUtil.combineArrays(fieldsFromClass, fieldsFromSuperclass);
            fieldsFromClass = new Field[tmpArr.length];
            for (int i = 0; i < tmpArr.length; ++i) {
                if (!(tmpArr[i] instanceof Field)) continue;
                fieldsFromClass[i] = (Field)tmpArr[i];
            }
        }
        try {
            for (Object f : fieldsFromClass) {
                ((Field)f).setAccessible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldsFromClass;
    }

    public static String[] reflectGetAllFieldNames(Object instanceToAccess) {
        Field[] fieldsFromInstance = ReflectionHelper.reflectGetAllFields(instanceToAccess);
        String[] toReturn = new String[fieldsFromInstance.length];
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = ReflectionHelper.reflectGetFieldName(fieldsFromInstance[i]);
        }
        return toReturn;
    }

    public static Object[] reflectGetAllFieldValues(Object instanceToAccess) {
        Field[] fieldsFromInstance = ReflectionHelper.reflectGetAllFields(instanceToAccess);
        Object[] toReturn = new Object[fieldsFromInstance.length];
        try {
            for (int i = 0; i < toReturn.length; ++i) {
                toReturn[i] = ReflectionHelper.reflectGetFieldValue(instanceToAccess, fieldsFromInstance[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public static ArrayList<Class> reflectGetAllTypesUsedInConstructorParameters(Object instanceToAccess, boolean excludeOwnType) {
        ArrayList<Class> toReturn = new ArrayList<Class>();
        for (Constructor<?> c : instanceToAccess.getClass().getConstructors()) {
            for (Class<?> cl : c.getParameterTypes()) {
                if (cl.equals(instanceToAccess.getClass()) && excludeOwnType) continue;
                toReturn.add(cl);
            }
        }
        return toReturn;
    }

    public static Object reflectGetInstanceWithAllMethodsPublic(Object instanceToAccess) {
        Method[] methods;
        for (Method m : methods = ReflectionHelper.reflectGetAllMethods(instanceToAccess)) {
            m.setAccessible(true);
        }
        return instanceToAccess;
    }

    public static Method[] reflectGetAllMethods(Object instanceOrClassToAccess) {
        Object[] methodsFromClass = new Method[]{};
        Object[] methodsFromSuperclass = new Method[]{};
        Class<?> classToAccess = instanceOrClassToAccess instanceof Class ? (Class<?>)instanceOrClassToAccess : instanceOrClassToAccess.getClass();
        methodsFromClass = classToAccess.getDeclaredMethods();
        if (classToAccess.getSuperclass() != null && classToAccess.getSuperclass() != Object.class) {
            try {
                methodsFromSuperclass = ReflectionHelper.reflectGetAllMethods(classToAccess.getSuperclass());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            methodsFromClass = (Method[])ArrayCollectionMapManipulationUtil.combineArrays(methodsFromClass, methodsFromSuperclass);
        }
        try {
            for (Object m : methodsFromClass) {
                ((Method)m).setAccessible(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return methodsFromClass;
    }
}

