/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import team.cqr.cqrepoured.util.data.ByteArrayManipulationUtil;

public class ArchiveManipulationUtil {
    public static byte[] zip(HashMap<String, byte[]> inputFiles) {
        ByteArrayOutputStream toReturn = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream(toReturn);
        try {
            for (String fileName : inputFiles.keySet()) {
                out.putNextEntry(new ZipEntry(fileName));
                out.write(inputFiles.get(fileName));
                out.closeEntry();
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn.toByteArray();
    }

    public static HashMap<String, byte[]> unzip(byte[] zippedFileAsPrimByteArray) {
        return ArchiveManipulationUtil.unzip("", zippedFileAsPrimByteArray);
    }

    public static HashMap<String, byte[]> unzip(String namePrefix, byte[] zippedFileAsPrimByteArray) {
        if (zippedFileAsPrimByteArray == null) {
            return null;
        }
        ZipInputStream archiveAsInputStream = new ZipInputStream(new ByteArrayInputStream(zippedFileAsPrimByteArray));
        ZipEntry currentZipEntry = null;
        boolean continueLoop = true;
        byte[] temp = new byte[1];
        ArrayList<Byte> buffer = new ArrayList<Byte>();
        HashMap<String, byte[]> toReturn = new HashMap<String, byte[]>();
        while (continueLoop) {
            try {
                currentZipEntry = archiveAsInputStream.getNextEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (currentZipEntry == null) {
                continueLoop = false;
                continue;
            }
            if (currentZipEntry.isDirectory()) {
                try {
                    while (archiveAsInputStream.available() == 1) {
                        archiveAsInputStream.read(temp);
                        buffer.add(temp[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                HashMap<String, byte[]> recursiveReturn = ArchiveManipulationUtil.unzip(namePrefix + "\\" + currentZipEntry.getName(), ByteArrayManipulationUtil.convertArrayListByteToPrimByteArray(buffer));
                for (String entryName : recursiveReturn.keySet()) {
                    toReturn.put(entryName, recursiveReturn.get(entryName));
                }
                continue;
            }
            try {
                while (archiveAsInputStream.available() == 1) {
                    archiveAsInputStream.read(temp);
                    buffer.add(temp[0]);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            toReturn.put(namePrefix + currentZipEntry.getName(), ByteArrayManipulationUtil.convertArrayListByteToPrimByteArray(buffer));
        }
        try {
            archiveAsInputStream.closeEntry();
            archiveAsInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }
}

