/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.DimensionManager;

public class FileIOUtil {
    private static FilenameFilter nbtFileFilter = null;

    private FileIOUtil() {
    }

    public static String getAbsoluteWorldPath() {
        return DimensionManager.getCurrentSaveRootDirectory() + "/";
    }

    public static void saveToFile(String fileNameIncludingFullPathAndExtension, byte[] toSave) {
        try {
            Files.createDirectories(Paths.get(fileNameIncludingFullPathAndExtension, new String[0]).getParent(), new FileAttribute[0]);
            Files.write(Paths.get(fileNameIncludingFullPathAndExtension, new String[0]), toSave, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] loadFromFile(String fileNameIncludingFullPathAndExtension) {
        try {
            return Files.readAllBytes(Paths.get(fileNameIncludingFullPathAndExtension, new String[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void saveNBTCompoundToFile(NBTTagCompound root, File file) {
        try {
            FileOutputStream outStream = null;
            outStream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)root, (OutputStream)outStream);
            ((OutputStream)outStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static NBTTagCompound getRootNBTTagOfFile(File file) {
        if (file.exists() && file.isFile() && file.getName().contains(".nbt")) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                NBTTagCompound root = null;
                try {
                    root = CompressedStreamTools.func_74796_a((InputStream)stream);
                }
                catch (IOException ex) {
                    root = new NBTTagCompound();
                }
                if (root != null) {
                    return root;
                }
            }
        }
        return null;
    }

    public static File getOrCreateFile(String FolderPath, String fileName) {
        File folder = new File(FolderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        } else if (!folder.isDirectory()) {
            folder.delete();
            folder.mkdirs();
        }
        File file = new File(folder, fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
                FileIOUtil.saveNBTCompoundToFile(new NBTTagCompound(), file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (!file.isFile()) {
            file.delete();
            try {
                file.createNewFile();
                FileIOUtil.saveNBTCompoundToFile(new NBTTagCompound(), file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static NBTTagList getOrCreateTagList(NBTTagCompound rootTag, String key, int listType) {
        NBTTagList structureList = new NBTTagList();
        if (!rootTag.func_150297_b(key, 9)) {
            if (rootTag.func_74764_b(key)) {
                rootTag.func_82580_o(key);
            }
            rootTag.func_74782_a(key, (NBTBase)structureList);
        } else {
            structureList = rootTag.func_150295_c(key, listType);
        }
        return structureList;
    }

    public static FilenameFilter getNBTFileFilter() {
        if (nbtFileFilter == null) {
            nbtFileFilter = new FilenameFilter(){
                String[] fileExtensions = new String[]{"nbt"};

                @Override
                public boolean accept(File dirIn, String fileName) {
                    if (dirIn != null) {
                        if (!dirIn.isDirectory()) {
                            return false;
                        }
                        int var3 = fileName.lastIndexOf(46);
                        if (var3 > 0 && var3 < fileName.length() - 1) {
                            String var4 = fileName.substring(var3 + 1).toLowerCase();
                            for (String var8 : this.fileExtensions) {
                                if (!var4.equals(var8)) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }
            };
        }
        return nbtFileFilter;
    }
}

