/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.handlers;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.crafting.RecipeArmorDyableBreathing;
import team.cqr.cqrepoured.crafting.RecipeArmorDyableRainbow;
import team.cqr.cqrepoured.crafting.RecipeCrownAttach;
import team.cqr.cqrepoured.crafting.RecipeCrownDetach;
import team.cqr.cqrepoured.crafting.RecipesArmorDyes;
import team.cqr.cqrepoured.customtextures.TextureSetManager;
import team.cqr.cqrepoured.factions.FactionRegistry;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.lootchests.LootTableLoader;
import team.cqr.cqrepoured.util.CQRConfig;

@Mod.EventBusSubscriber
public class EventsHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLootTableLoadPre(LootTableLoadEvent event) {
        if (event.getName().func_110624_b().equals("cqrepoured")) {
            try {
                event.setTable(LootTableLoader.fillLootTable(event.getName(), event.getTable()));
            }
            catch (Exception e) {
                CQRMain.logger.error("Unable to fill loot table {}", (Object)event.getName());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLootTableLoadPost(LootTableLoadEvent event) {
        LootTableLoader.freezeLootTable();
    }

    @SubscribeEvent
    public static void onDefense(LivingAttackEvent event) {
        boolean tep = false;
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            Entity attacker = event.getSource().func_76346_g();
            float amount = event.getAmount();
            World world = player.field_70170_p;
            if (player.func_184607_cu().func_77973_b() != CQRItems.SHIELD_WALKER_KING || player.func_184614_ca().func_77973_b() != CQRItems.SWORD_WALKER || player.func_184187_bx() != null || attacker == null) {
                return;
            }
            double d = attacker.field_70165_t + (attacker.field_70170_p.field_73012_v.nextDouble() - 0.5) * 4.0;
            double d1 = attacker.field_70163_u;
            double d2 = attacker.field_70161_v + (attacker.field_70170_p.field_73012_v.nextDouble() - 0.5) * 4.0;
            double d3 = player.field_70165_t;
            double d4 = player.field_70163_u;
            double d5 = player.field_70161_v;
            int i = MathHelper.func_76128_c((double)d);
            int j = MathHelper.func_76128_c((double)d1);
            int k = MathHelper.func_76128_c((double)d2);
            BlockPos ep = new BlockPos(i, j, k);
            BlockPos ep1 = new BlockPos(i, j + 1, k);
            if (world.func_184144_a((Entity)player, player.func_174813_aQ()).size() == 0 && !world.func_72953_d(attacker.func_174813_aQ()) && player.func_184585_cz() && player.func_70068_e(attacker) >= 25.0) {
                if (world.func_180495_p(ep).func_177230_c().func_176205_b((IBlockAccess)world, ep) && world.func_180495_p(ep1).func_177230_c().func_176205_b((IBlockAccess)world, ep1)) {
                    tep = true;
                } else {
                    tep = false;
                    if (!world.field_72995_K) {
                        ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_LARGE, player.field_70165_t, player.field_70163_u + (double)player.field_70131_O * 0.5, player.field_70161_v, 12, 0.25, 0.25, 0.25, 0.0, new int[0]);
                    }
                }
            }
            if (tep && world.func_180495_p(ep).func_177230_c().func_176205_b((IBlockAccess)world, ep) && world.func_180495_p(ep1).func_177230_c().func_176205_b((IBlockAccess)world, ep1)) {
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    playerMP.field_71135_a.func_147364_a(d, d1, d2, playerMP.field_70177_z, playerMP.field_70125_A);
                    if (!world.field_72995_K) {
                        ((WorldServer)world).func_175739_a(EnumParticleTypes.PORTAL, player.field_70165_t, player.field_70163_u + (double)player.field_70131_O * 0.5, player.field_70161_v, 12, 0.25, 0.25, 0.25, 0.0, new int[0]);
                    }
                    world.func_184148_a(null, d, d1, d2, SoundEvents.field_187534_aX, SoundCategory.MASTER, 1.0f, 1.0f);
                }
                event.setCanceled(true);
                tep = false;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Random rand = new Random();
        Entity entity = event.getEntity();
        NBTTagCompound tag = entity.getEntityData();
        if (tag.func_74764_b("Items")) {
            NBTTagList itemList = tag.func_150295_c("Items", 10);
            if (itemList == null) {
                return;
            }
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound entry = itemList.func_150305_b(i);
                ItemStack stack = new ItemStack(entry);
                if (stack == null || entity.field_70170_p.field_72995_K) continue;
                entity.field_70170_p.func_72838_d((Entity)new EntityItem(entity.field_70170_p, entity.field_70165_t + rand.nextDouble(), entity.field_70163_u, entity.field_70161_v + rand.nextDouble(), stack));
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load e) {
        DungeonDataManager.handleWorldLoad(e.getWorld());
        if (!e.getWorld().field_72995_K && e.getWorld().field_73011_w.getDimension() == 0) {
            LootTableLoader.registerCustomLootTables((WorldServer)e.getWorld());
        }
    }

    @SubscribeEvent
    public static void onWorldCreateSpawnpoint(WorldEvent.CreateSpawnPosition e) {
        DungeonDataManager.handleWorldLoad(e.getWorld());
    }

    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save e) {
        DungeonDataManager.handleWorldSave(e.getWorld());
        FactionRegistry.instance().saveAllReputationData(false);
    }

    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new RecipesArmorDyes().setRegistryName("cqrepoured", "armor_coloring"));
        event.getRegistry().register((IForgeRegistryEntry)new RecipeArmorDyableRainbow());
        event.getRegistry().register((IForgeRegistryEntry)new RecipeArmorDyableBreathing());
        event.getRegistry().register((IForgeRegistryEntry)new RecipeCrownAttach());
        event.getRegistry().register((IForgeRegistryEntry)new RecipeCrownDetach());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload e) {
        if (!e.getWorld().field_72995_K) {
            DungeonDataManager.handleWorldUnload(e.getWorld());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLCommonHandler.instance().getSide().isServer() || !CQRMain.proxy.isOwnerOfIntegratedServer(event.player)) {
            TextureSetManager.sendTexturesToClient((EntityPlayerMP)event.player);
            FactionRegistry.instance().handlePlayerLogin((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (FMLCommonHandler.instance().getSide().isServer() || !CQRMain.proxy.isOwnerOfIntegratedServer(event.player)) {
            FactionRegistry.instance().handlePlayerLogout((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        if (CQRConfig.mobs.blockCancelledByAxe) {
            AbstractEntityCQR targetCQR;
            EntityPlayer player = event.getEntityPlayer();
            World world = player.field_70170_p;
            if (!world.field_72995_K && event.getTarget() instanceof AbstractEntityCQR && (targetCQR = (AbstractEntityCQR)event.getTarget()).func_184583_d(DamageSource.func_76365_a((EntityPlayer)player)) && player.func_184614_ca().func_77973_b() instanceof ItemAxe && player.func_184825_o(0.0f) >= 0.9f) {
                targetCQR.setLastTimeHitByAxeWhileBlocking(targetCQR.field_70173_aa);
            }
        }
    }

    @SubscribeEvent
    public static void sayNoToCowardlyPlacingLavaAgainstBosses(FillBucketEvent event) {
        if (CQRConfig.bosses.antiCowardMode && !event.getEntityPlayer().func_184812_l_()) {
            BlockPos pos = new BlockPos((Entity)event.getEntityPlayer());
            int radius = CQRConfig.bosses.antiCowardRadius;
            AxisAlignedBB aabb = new AxisAlignedBB(pos.func_177982_a(-radius, -radius / 2, -radius), pos.func_177982_a(radius, radius / 2, radius));
            event.setCanceled(!event.getWorld().func_72872_a(AbstractEntityCQRBoss.class, aabb).isEmpty());
        }
    }
}

