/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import team.cqr.cqrepoured.CQRMain;

public class ReflectionMethod<T> {
    private final Method method;

    public ReflectionMethod(Class<?> clazz, String obfuscatedName, String deobfuscatedName, Class<?> ... parameterTypes) {
        Method m = null;
        try {
            try {
                m = clazz.getDeclaredMethod(obfuscatedName, parameterTypes);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                m = clazz.getDeclaredMethod(deobfuscatedName, parameterTypes);
                m.setAccessible(true);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            CQRMain.logger.error("Failed to get method from class " + clazz + " for name " + deobfuscatedName, (Throwable)e);
        }
        this.method = m;
    }

    public ReflectionMethod(String className, String obfuscatedName, String deobfuscatedName, Class<?> ... parameterTypes) {
        Method m = null;
        try {
            Class<?> clazz = Class.forName(className);
            try {
                m = clazz.getDeclaredMethod(obfuscatedName, parameterTypes);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                m = clazz.getDeclaredMethod(deobfuscatedName, parameterTypes);
                m.setAccessible(true);
            }
        }
        catch (ClassCastException | ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            CQRMain.logger.error("Failed to get method from class " + obfuscatedName + " for name " + deobfuscatedName, (Throwable)e);
        }
        this.method = m;
    }

    public T invoke(Object obj, Object ... args) {
        try {
            return (T)this.method.invoke(obj, args);
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            CQRMain.logger.error("Failed to invoke method " + this.method.getName() + " for object " + obj + " with parameters " + args, (Throwable)e);
            return null;
        }
    }
}

