/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import shadows.click.ClickMachine;
import shadows.click.block.TileAutoClick;
import shadows.placebo.block.BlockBasic;
import shadows.placebo.interfaces.IItemBlock;
import shadows.placebo.registry.RegistryInformation;

public class BlockAutoClick
extends BlockBasic
implements IItemBlock {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public BlockAutoClick() {
        super("auto_clicker", Material.field_151573_f, 5.0f, 5.0f, (RegistryInformation)ClickMachine.INFO);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAutoClick();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[meta % 6]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        EnumFacing rotated = facing.func_176732_a(axis.func_176740_k());
        return world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)rotated));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirror.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof TileAutoClick && placer instanceof EntityPlayer) {
            ((TileAutoClick)te).setPlayer((EntityPlayer)placer);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing face = placer.func_174811_aO().func_176734_d();
        if (placer.field_70125_A > 50.0f) {
            face = EnumFacing.UP;
        } else if (placer.field_70125_A < -50.0f) {
            face = EnumFacing.DOWN;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)face);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)ClickMachine.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileAutoClick) {
            BlockAutoClick.func_180635_a((World)world, (BlockPos)pos, (ItemStack)((TileAutoClick)te).held.getStackInSlot(0));
        }
        super.func_180663_b(world, pos, state);
    }
}

