/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.block;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import shadows.click.ClickMachine;
import shadows.click.ClickMachineConfig;
import shadows.click.block.BlockAutoClick;
import shadows.click.net.MessageUpdateGui;
import shadows.click.util.FakePlayerUtil;

public class TileAutoClick
extends TileEntity
implements ITickable {
    public static final GameProfile DEFAULT_CLICKER = new GameProfile(UUID.fromString("36f373ac-29ef-4150-b664-e7e6006efcd8"), "[The Click Machine]");
    ItemStackHandler held = new ItemStackHandler(1);
    EnergyStorage power = new EnergyStorage(ClickMachineConfig.maxPowerStorage);
    GameProfile profile;
    WeakReference<FakePlayerUtil.UsefulFakePlayer> player;
    int counter = 0;
    boolean rightClick = true;
    boolean sneak = false;
    int speedIdx = 0;
    NetworkRegistry.TargetPoint us;
    int lastPower = 0;
    static final String tagUUID = "uuid";
    static final String tagName = "name";
    static final String tagCounter = "counter";
    static final String tagSpeed = "speed_index";
    static final String tagSneak = "sneak";
    static final String tagRightClick = "right_click";
    static final String tagHandler = "inv";
    static final String tagEnergy = "fe";

    public void func_73660_a() {
        int use;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.player == null) {
            this.player = new WeakReference<FakePlayerUtil.UsefulFakePlayer>(FakePlayerUtil.getPlayer(this.field_145850_b, this.profile != null ? this.profile : DEFAULT_CLICKER));
        }
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        int n = use = ClickMachineConfig.usesRF ? ClickMachineConfig.powerPerSpeed[this.speedIdx] : 0;
        if (this.power.extractEnergy(use, true) == use) {
            this.power.extractEnergy(use, false);
            if (this.player != null && this.counter++ % this.getSpeed() == 0) {
                EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockAutoClick.FACING);
                FakePlayerUtil.setupFakePlayerForUse(this.getPlayer(), this.field_174879_c, facing, this.held.getStackInSlot(0).func_77946_l(), this.sneak);
                ItemStack result = this.held.getStackInSlot(0);
                result = this.rightClick ? FakePlayerUtil.rightClickInDirection(this.getPlayer(), this.field_145850_b, this.field_174879_c, facing, this.field_145850_b.func_180495_p(this.field_174879_c)) : FakePlayerUtil.leftClickInDirection(this.getPlayer(), this.field_145850_b, this.field_174879_c, facing, this.field_145850_b.func_180495_p(this.field_174879_c));
                FakePlayerUtil.cleanupFakePlayerFromUse(this.getPlayer(), result, this.held.getStackInSlot(0), s -> this.held.setStackInSlot(0, s));
                this.func_70296_d();
            }
        }
        if (this.counter % ClickMachineConfig.powerUpdateFreq == 0 && this.power.getEnergyStored() != this.lastPower) {
            if (this.us == null) {
                this.us = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0);
            }
            ClickMachine.NETWORK.sendToAllTracking((IMessage)new MessageUpdateGui(this.power.getEnergyStored()), this.us);
            this.lastPower = this.power.getEnergyStored();
        }
    }

    public void setPlayer(EntityPlayer player) {
        this.profile = player.func_146103_bH();
        this.func_70296_d();
    }

    public ItemStack insert(ItemStack stack) {
        ItemStack s = this.held.insertItem(0, stack, false);
        this.func_70296_d();
        return s;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.held);
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.power);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState state1, IBlockState state2) {
        return state1.func_177230_c() != state2.func_177230_c();
    }

    FakePlayerUtil.UsefulFakePlayer getPlayer() {
        return (FakePlayerUtil.UsefulFakePlayer)((Object)this.player.get());
    }

    public IItemHandler getHandler() {
        return this.held;
    }

    public int getSpeed() {
        return ClickMachineConfig.speeds[this.speedIdx];
    }

    public int getSpeedIndex() {
        return this.speedIdx;
    }

    public void setSpeedIndex(int speedIdx) {
        this.speedIdx = speedIdx;
        this.func_70296_d();
    }

    public boolean isSneaking() {
        return this.sneak;
    }

    public void setSneaking(boolean sneak) {
        this.sneak = sneak;
        this.func_70296_d();
    }

    public boolean isRightClicking() {
        return this.rightClick;
    }

    public void setRightClicking(boolean rightClick) {
        this.rightClick = rightClick;
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.profile != null) {
            tag.func_186854_a(tagUUID, this.profile.getId());
            tag.func_74778_a(tagName, this.profile.getName());
        }
        tag.func_74782_a(tagHandler, (NBTBase)this.held.serializeNBT());
        tag.func_74768_a(tagCounter, this.counter % this.getSpeed());
        this.writeSyncData(tag);
        return super.func_189515_b(tag);
    }

    void writeSyncData(NBTTagCompound tag) {
        tag.func_74768_a(tagSpeed, this.speedIdx);
        tag.func_74757_a(tagSneak, this.sneak);
        tag.func_74757_a(tagRightClick, this.rightClick);
        tag.func_74768_a(tagEnergy, this.power.getEnergyStored());
    }

    void readSyncData(NBTTagCompound tag) {
        this.speedIdx = tag.func_74762_e(tagSpeed);
        this.sneak = tag.func_74767_n(tagSneak);
        this.rightClick = tag.func_74767_n(tagRightClick);
        this.setPower(tag.func_74762_e(tagEnergy));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b(tagUUID) && tag.func_74764_b(tagName)) {
            this.profile = new GameProfile(tag.func_186857_a(tagUUID), tag.func_74779_i(tagName));
        }
        if (tag.func_74764_b(tagHandler)) {
            this.held.deserializeNBT(tag.func_74775_l(tagHandler));
        }
        this.counter = tag.func_74762_e(tagCounter);
        this.readSyncData(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeSyncData(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 2664, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncData(pkt.func_148857_g());
    }

    public int getPower() {
        return this.power.getEnergyStored();
    }

    public void setPower(int energy) {
        this.power.extractEnergy(this.power.getMaxEnergyStored(), false);
        this.power.receiveEnergy(energy, false);
        this.func_70296_d();
    }
}

