/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.block.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import shadows.click.ClickMachine;
import shadows.click.ClickMachineConfig;
import shadows.click.block.TileAutoClick;
import shadows.click.block.gui.BetterButtonToggle;
import shadows.click.block.gui.ContainerAutoClick;
import shadows.click.net.MessageButtonClick;

public class GuiAutoClick
extends GuiContainer {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("clickmachine", "textures/gui/auto_click.png");
    EntityPlayer player;
    TileAutoClick tile;
    BetterButtonToggle[] buttons;

    public GuiAutoClick(TileAutoClick tile) {
        super((Container)new ContainerAutoClick(tile, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.buttons = new BetterButtonToggle[12];
        this.tile = tile;
        ++this.field_147000_g;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (Buttons b : Buttons.values()) {
            this.buttons[b.ordinal()] = (BetterButtonToggle)this.func_189646_b((GuiButton)b.getAndInitButton(this));
        }
        this.buttons[this.tile.getSpeedIndex()].func_191753_b(true);
        this.buttons[9].func_191753_b(this.tile.isSneaking());
        this.buttons[this.tile.isRightClicking() ? 11 : 10].func_191753_b(true);
    }

    public void updateTile(int speedIdx, boolean sneaking, boolean rightClick, int power) {
        for (BetterButtonToggle b : this.buttons) {
            if (b.field_146127_k >= 9) continue;
            b.func_191753_b(b.field_146127_k == speedIdx);
        }
        this.buttons[9].func_191753_b(sneaking);
        for (BetterButtonToggle b : this.buttons) {
            if (b.field_146127_k <= 9) continue;
            b.func_191753_b(rightClick ? b.field_146127_k == 11 : b.field_146127_k == 10);
        }
        this.tile.setPower(power);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(GUI_TEXTURE);
        int n = (int)(72.0f * Math.min(1.0f, 1.0f - (float)this.tile.getPower() / (float)ClickMachineConfig.maxPowerStorage));
        this.func_73729_b(151, 7 + n, 230, n, 18, 72);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.clickmachine.autoclick.name", (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.player.field_71071_by.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_191948_b(int x, int y) {
        super.func_191948_b(x, y);
        for (BetterButtonToggle b : this.buttons) {
            if (!b.func_146115_a()) continue;
            this.drawHoveringText(Buttons.VALUES[b.field_146127_k].getTooltip(), x, y, this.field_146289_q);
        }
        if (this.func_146978_c(151, 7, 18, 71, x, y)) {
            this.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"gui.clickmachine.power.tooltip", (Object[])new Object[]{this.tile.getPower(), ClickMachineConfig.maxPowerStorage})), x, y, this.field_146289_q);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k < 12) {
            BetterButtonToggle toggle = (BetterButtonToggle)button;
            if (toggle.field_146127_k < 9) {
                for (BetterButtonToggle b : this.buttons) {
                    if (b.field_146127_k < 9 && b.field_146127_k != toggle.field_146127_k) {
                        b.func_191753_b(false);
                    }
                    toggle.func_191753_b(true);
                }
            } else if (toggle.field_146127_k == 9) {
                toggle.func_191753_b(!toggle.func_191754_c());
            } else if (toggle.field_146127_k > 9) {
                for (BetterButtonToggle b : this.buttons) {
                    if (b.field_146127_k > 9 && b.field_146127_k != toggle.field_146127_k) {
                        b.func_191753_b(false);
                    }
                    toggle.func_191753_b(true);
                }
            }
        }
        ClickMachine.NETWORK.sendToServer((IMessage)new MessageButtonClick(button.field_146127_k));
    }

    public void setButtonState(int buttonId, boolean on) {
        this.buttons[buttonId].func_191753_b(on);
    }

    public static void setFormatArgs(int button, Object ... args) {
        Buttons.VALUES[button].formatArgs = args;
    }

    public TileAutoClick getTile() {
        return this.tile;
    }

    static enum Buttons {
        SPEED_0(35, 18, 176, 0),
        SPEED_1(53, 18, 176, 18),
        SPEED_2(71, 18, 176, 36),
        SPEED_3(35, 36, 176, 54),
        SPEED_4(53, 36, 176, 72),
        SPEED_5(71, 36, 176, 90),
        SPEED_6(35, 54, 176, 108),
        SPEED_7(53, 54, 176, 126),
        SPEED_8(71, 54, 176, 144),
        SNEAK(107, 18, 176, 162),
        LEFT_CLICK(98, 54, 176, 180),
        RIGHT_CLICK(116, 54, 176, 198);

        static final Buttons[] VALUES;
        int id;
        int x;
        int y;
        int u;
        int v;
        String unlocalized;
        Object[] formatArgs = new Object[0];

        private Buttons(int x, int y, int u, int v) {
            this.id = this.ordinal();
            this.x = x - 1;
            this.y = y - 2;
            this.u = u;
            this.v = v;
            this.unlocalized = "gui.clickmachine." + this.name().toLowerCase(Locale.ROOT) + (ClickMachineConfig.usesRF && this.id < 9 ? ".rf.tooltip" : ".tooltip");
        }

        List<String> getTooltip() {
            return Arrays.asList(I18n.func_135052_a((String)this.unlocalized, (Object[])this.formatArgs));
        }

        BetterButtonToggle getAndInitButton(GuiAutoClick gui) {
            BetterButtonToggle b = new BetterButtonToggle(this.id, gui.field_147003_i + this.x, gui.field_147009_r + this.y, 18, 18, false);
            b.func_191751_a(this.u, this.v, 18, 0, GUI_TEXTURE);
            return b;
        }

        static {
            VALUES = Buttons.values();
        }
    }
}

