/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import shadows.click.block.TileAutoClick;
import shadows.click.block.gui.GuiAutoClick;

public class MessageUpdateGui
implements IMessage {
    Type t;
    int power;
    int speedIdx;
    boolean right;
    boolean sneak;

    public MessageUpdateGui(Type t, int power, TileAutoClick te) {
        if (t == Type.POWER) {
            this.power = power;
        } else {
            this.power = te.getPower();
            this.speedIdx = te.getSpeedIndex();
            this.right = te.isRightClicking();
            this.sneak = te.isSneaking();
        }
        this.t = t;
    }

    public MessageUpdateGui(TileAutoClick te) {
        this(Type.SYNC, -1, te);
    }

    public MessageUpdateGui(int power) {
        this(Type.POWER, power, null);
    }

    public MessageUpdateGui() {
    }

    public void fromBytes(ByteBuf buf) {
        this.t = Type.values()[buf.readByte()];
        this.power = buf.readInt();
        if (this.t == Type.SYNC) {
            this.speedIdx = buf.readInt();
            this.right = buf.readBoolean();
            this.sneak = buf.readBoolean();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.t.ordinal());
        buf.writeInt(this.power);
        if (this.t == Type.SYNC) {
            buf.writeInt(this.speedIdx);
            buf.writeBoolean(this.right);
            buf.writeBoolean(this.sneak);
        }
    }

    public static enum Type {
        POWER,
        SYNC;

    }

    public static class UpdatePowerHandler
    implements IMessageHandler<MessageUpdateGui, IMessage> {
        public MessageUpdateGui onMessage(MessageUpdateGui message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (Minecraft.func_71410_x().field_71462_r instanceof GuiAutoClick) {
                    if (message.t == Type.POWER) {
                        ((GuiAutoClick)Minecraft.func_71410_x().field_71462_r).getTile().setPower(message.power);
                    } else {
                        ((GuiAutoClick)Minecraft.func_71410_x().field_71462_r).updateTile(message.speedIdx, message.sneak, message.right, message.power);
                    }
                }
            });
            return null;
        }
    }
}

