/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.block.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import shadows.click.ClickMachineConfig;
import shadows.click.block.TileAutoClick;
import shadows.click.block.gui.BetterButtonToggle;
import shadows.click.block.gui.ContainerAutoClick;
import shadows.placebo.Placebo;
import shadows.placebo.net.MessageButtonClick;

public class GuiAutoClick
extends ContainerScreen<ContainerAutoClick> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("clickmachine", "textures/gui/auto_click.png");
    PlayerEntity player;
    TileAutoClick tile;
    BetterButtonToggle[] buttons;

    public GuiAutoClick(ContainerAutoClick container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.buttons = new BetterButtonToggle[12];
        this.tile = container.tile;
        ++this.field_147000_g;
    }

    public void init() {
        super.init();
        for (Buttons b : Buttons.values()) {
            this.buttons[b.ordinal()] = (BetterButtonToggle)this.addButton((Widget)b.getAndInitButton(this));
        }
        this.buttons[this.tile.getSpeedIndex()].func_191753_b(true);
        this.buttons[9].func_191753_b(this.tile.isSneaking());
        this.buttons[this.tile.isRightClicking() ? 11 : 10].func_191753_b(true);
    }

    public void updateTile(int speedIdx, boolean sneaking, boolean rightClick, int power) {
        for (BetterButtonToggle b : this.buttons) {
            if (b.id >= 9) continue;
            b.func_191753_b(b.id == speedIdx);
        }
        this.buttons[9].func_191753_b(sneaking);
        for (BetterButtonToggle b : this.buttons) {
            if (b.id <= 9) continue;
            b.func_191753_b(rightClick ? b.id == 11 : b.id == 10);
        }
        this.tile.setPower(power);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        int n = (int)(72.0f * Math.min(1.0f, 1.0f - (float)this.tile.getPower() / (float)ClickMachineConfig.maxPowerStorage));
        this.blit(151, 7 + n, 230, n, 18, 72);
        this.font.func_211126_b(this.getNarrationMessage(), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.player.field_71071_by.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI_TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_191948_b(int x, int y) {
        super.func_191948_b(x, y);
        for (BetterButtonToggle b : this.buttons) {
            if (!b.isMouseOver(x, y)) continue;
            Buttons.VALUES[b.id].getTooltip().forEach(s -> GuiUtils.drawHoveringText(Arrays.asList(s), (int)x, (int)y, (int)this.width, (int)this.height, (int)0xFFFFFF, (FontRenderer)this.font));
        }
        if (this.func_195359_a(151, 7, 18, 71, x, y)) {
            GuiUtils.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"gui.clickmachine.power.tooltip", (Object[])new Object[]{this.tile.getPower(), ClickMachineConfig.usesRF ? ClickMachineConfig.maxPowerStorage : 0})), (int)x, (int)y, (int)this.width, (int)this.height, (int)0xFFFFFF, (FontRenderer)this.font);
        }
    }

    protected void actionPerformed(BetterButtonToggle toggle) {
        if (toggle.id < 9) {
            for (BetterButtonToggle b : this.buttons) {
                if (b.id < 9 && b.id != toggle.id) {
                    b.func_191753_b(false);
                }
                toggle.func_191753_b(true);
            }
        } else if (toggle.id == 9) {
            toggle.func_191753_b(!toggle.func_191754_c());
        } else if (toggle.id > 9) {
            for (BetterButtonToggle b : this.buttons) {
                if (b.id > 9 && b.id != toggle.id) {
                    b.func_191753_b(false);
                }
                toggle.func_191753_b(true);
            }
        }
        Placebo.CHANNEL.sendToServer((Object)new MessageButtonClick(toggle.id));
    }

    public void setButtonState(int buttonId, boolean on) {
        this.buttons[buttonId].func_191753_b(on);
    }

    public static void setFormatArgs(int button, Object ... args) {
        Buttons.VALUES[button].formatArgs = args;
    }

    public TileAutoClick getTile() {
        return this.tile;
    }

    static enum Buttons {
        SPEED_0(35, 18, 176, 0),
        SPEED_1(53, 18, 176, 18),
        SPEED_2(71, 18, 176, 36),
        SPEED_3(35, 36, 176, 54),
        SPEED_4(53, 36, 176, 72),
        SPEED_5(71, 36, 176, 90),
        SPEED_6(35, 54, 176, 108),
        SPEED_7(53, 54, 176, 126),
        SPEED_8(71, 54, 176, 144),
        SNEAK(107, 18, 176, 162),
        LEFT_CLICK(98, 54, 176, 180),
        RIGHT_CLICK(116, 54, 176, 198);

        static final Buttons[] VALUES;
        int id;
        int x;
        int y;
        int u;
        int v;
        String unlocalized;
        Object[] formatArgs = new Object[0];

        private Buttons(int x, int y, int u, int v) {
            this.id = this.ordinal();
            this.x = x - 1;
            this.y = y - 2;
            this.u = u;
            this.v = v;
            this.unlocalized = "gui.clickmachine." + this.name().toLowerCase(Locale.ROOT) + (ClickMachineConfig.usesRF && this.id < 9 ? ".rf.tooltip" : ".tooltip");
        }

        List<String> getTooltip() {
            return Arrays.asList(I18n.func_135052_a((String)this.unlocalized, (Object[])this.formatArgs));
        }

        BetterButtonToggle getAndInitButton(GuiAutoClick gui) {
            BetterButtonToggle b = new BetterButtonToggle(this.id, gui.field_147003_i + this.x, gui.field_147009_r + this.y, 18, 18, false);
            b.func_191751_a(this.u, this.v, 18, 0, GUI_TEXTURE);
            b.controller = gui;
            return b;
        }

        static {
            VALUES = Buttons.values();
        }
    }
}

