/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.mod.minema;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import team.creative.cmdcam.CMDCam;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.reflection.ReflectionHelper;

public class MinemaAddon {
    public static final String MODID = "minema";
    private static final boolean installed = CreativeCore.loader().isModLoaded("minema");
    private static final Field singletonField;
    private static final Method startCaptureMethod;
    private static final Method stopCaptureMethod;
    private static final Object configFrameLimit;
    private static final Method getInt;
    private static final Method setInt;
    private static int previousFrameLimit;

    public static boolean installed() {
        return installed && CMDCam.CONFIG.syncMinema;
    }

    public static void startCapture() {
        try {
            previousFrameLimit = (Integer)getInt.invoke(configFrameLimit, new Object[0]);
            setInt.invoke(configFrameLimit, -1);
            startCaptureMethod.invoke(singletonField.get(null), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static void stopCapture() {
        try {
            stopCaptureMethod.invoke(singletonField.get(null), new Object[0]);
            setInt.invoke(configFrameLimit, previousFrameLimit);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    static {
        if (installed) {
            try {
                Class<?> captureSessionClass = Class.forName("info.ata4.minecraft.minema.CaptureSession");
                singletonField = ReflectionHelper.findField(captureSessionClass, (String)"singleton");
                startCaptureMethod = ReflectionHelper.findMethod(captureSessionClass, (String)"startCapture", (Class[])new Class[0]);
                stopCaptureMethod = ReflectionHelper.findMethod(captureSessionClass, (String)"stopCapture", (Class[])new Class[0]);
                Class<?> modClass = Class.forName("info.ata4.minecraft.minema.Minema");
                Object config = ReflectionHelper.findField(modClass, (String)"config").get(ReflectionHelper.findField(modClass, (String)"instance").get(null));
                configFrameLimit = ReflectionHelper.findField(config.getClass(), (String)"frameLimit").get(config);
                getInt = ReflectionHelper.findMethod(configFrameLimit.getClass(), (String)"get", (Class[])new Class[0]);
                setInt = ReflectionHelper.findMethod(configFrameLimit.getClass(), (String)"set", (Class[])new Class[]{Integer.TYPE});
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        } else {
            singletonField = null;
            startCaptureMethod = null;
            stopCaptureMethod = null;
            configFrameLimit = null;
            getInt = null;
            setInt = null;
        }
    }
}

