/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client.mixin;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import team.creative.cmdcam.client.EntitySelectorClient;

@Mixin(value={EntitySelector.class})
public abstract class EntitySelectorMixin
implements EntitySelectorClient {
    @Shadow
    @Final
    private int f_121111_;
    @Shadow
    @Final
    private boolean f_121112_;
    @Shadow
    @Final
    private boolean f_121113_;
    @Shadow
    @Final
    private Predicate<Entity> f_121114_;
    @Shadow
    @Final
    private MinMaxBounds.Doubles f_121115_;
    @Shadow
    @Final
    private Function<Vec3, Vec3> f_121116_;
    @Shadow
    @Final
    @Nullable
    private AABB f_121117_;
    @Shadow
    @Final
    private BiConsumer<Vec3, List<? extends Entity>> f_121118_;
    @Shadow
    @Final
    private boolean f_121119_;
    @Shadow
    @Final
    @Nullable
    private String f_121120_;
    @Shadow
    @Final
    @Nullable
    private UUID f_121121_;
    @Shadow
    @Final
    private EntityTypeTest<Entity, ?> f_121122_;
    @Shadow
    @Final
    private boolean f_121123_;

    @Shadow
    private void m_121168_(CommandSourceStack source) throws CommandSyntaxException {
    }

    @Shadow
    private Predicate<Entity> m_121144_(Vec3 vec) {
        return null;
    }

    @Shadow
    public abstract boolean m_121165_();

    @Shadow
    private <T extends Entity> List<T> m_121149_(Vec3 vec, List<T> list) {
        return null;
    }

    @Override
    public Entity findSingleEntityClient(CommandSourceStack source) throws CommandSyntaxException {
        this.m_121168_(source);
        List<? extends Entity> list = this.findEntitiesClient(source);
        if (list.isEmpty()) {
            throw EntityArgument.f_91439_.create();
        }
        if (list.size() > 1) {
            throw EntityArgument.f_91436_.create();
        }
        return list.get(0);
    }

    @Override
    public List<? extends Entity> findEntitiesClient(CommandSourceStack source) throws CommandSyntaxException {
        this.m_121168_(source);
        if (!this.f_121112_) {
            return this.findPlayersClient(source);
        }
        if (this.f_121120_ != null) {
            for (Player player : source.getUnsidedLevel().m_6907_()) {
                if (!player.m_36316_().getName().equalsIgnoreCase(this.f_121120_)) continue;
                return Lists.newArrayList((Object[])new Player[]{player});
            }
            return Collections.emptyList();
        }
        if (this.f_121121_ != null) {
            ClientLevel level = (ClientLevel)source.getUnsidedLevel();
            for (Entity entity : level.m_104735_()) {
                if (!entity.m_20148_().equals(this.f_121121_)) continue;
                return Lists.newArrayList((Object[])new Entity[]{entity});
            }
            return Collections.emptyList();
        }
        Vec3 vec3 = this.f_121116_.apply(source.m_81371_());
        Predicate<Entity> predicate = this.m_121144_(vec3);
        if (this.f_121119_) {
            return source.m_81373_() != null && predicate.test(source.m_81373_()) ? Lists.newArrayList((Object[])new Entity[]{source.m_81373_()}) : Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        ClientLevel level = (ClientLevel)source.getUnsidedLevel();
        if (this.f_121117_ != null) {
            list.addAll(level.m_142425_(this.f_121122_, this.f_121117_.m_82383_(vec3), predicate));
        } else {
            for (Entity entity : level.m_104735_()) {
                if (predicate.test(entity)) {
                    list.add(entity);
                }
                for (PartEntity p : level.getPartEntities()) {
                    Entity t = (Entity)this.f_121122_.m_141992_((Object)p);
                    if (t == null || !predicate.test(t)) continue;
                    list.add(t);
                }
            }
        }
        return this.m_121149_(vec3, list);
    }

    @Override
    public Player findSinglePlayerClient(CommandSourceStack source) throws CommandSyntaxException {
        this.m_121168_(source);
        List<Player> list = this.findPlayersClient(source);
        if (list.size() != 1) {
            throw EntityArgument.f_91440_.create();
        }
        return list.get(0);
    }

    @Override
    public List<Player> findPlayersClient(CommandSourceStack source) throws CommandSyntaxException {
        this.m_121168_(source);
        if (this.f_121120_ != null) {
            for (Player player : source.getUnsidedLevel().m_6907_()) {
                if (!player.m_36316_().getName().equalsIgnoreCase(this.f_121120_)) continue;
                return Lists.newArrayList((Object[])new Player[]{player});
            }
            return Collections.emptyList();
        }
        if (this.f_121121_ != null) {
            Player player = source.getUnsidedLevel().m_46003_(this.f_121121_);
            return player == null ? Collections.emptyList() : Lists.newArrayList((Object[])new Player[]{player});
        }
        Vec3 vec3 = this.f_121116_.apply(source.m_81371_());
        Predicate<Entity> predicate = this.m_121144_(vec3);
        if (this.f_121119_) {
            Player player;
            Entity entity = source.m_81373_();
            if (entity instanceof Player && predicate.test((Entity)(player = (Player)entity))) {
                return Lists.newArrayList((Object[])new Player[]{player});
            }
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (Player player : source.getUnsidedLevel().m_6907_()) {
            if (!predicate.test((Entity)player)) continue;
            list.add(player);
        }
        return this.m_121149_(vec3, list);
    }
}

