/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.math.interpolation;

import java.util.List;
import team.creative.cmdcam.common.math.interpolation.CircularCamInterpolation;
import team.creative.cmdcam.common.math.interpolation.CubicCamInterpolation;
import team.creative.cmdcam.common.math.interpolation.HermiteCamInterpolation;
import team.creative.cmdcam.common.math.interpolation.LinearCamInterpolation;
import team.creative.cmdcam.common.math.interpolation.SmoothCamInterpolation;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.creativecore.common.util.math.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.type.Color;

public abstract class CamInterpolation {
    public static final NamedHandlerRegistry<CamInterpolation> REGISTRY = new NamedHandlerRegistry(null);
    public static final CamInterpolation HERMITE;
    public boolean isRenderingEnabled = false;
    public final Color color;

    public CamInterpolation(Color color) {
        this.color = color;
    }

    public abstract <T extends VecNd> Interpolation<T> create(double[] var1, CamScene var2, T var3, List<T> var4, T var5, CamAttribute<T> var6);

    static {
        REGISTRY.register("linear", (Object)new LinearCamInterpolation());
        REGISTRY.register("cubic", (Object)new CubicCamInterpolation());
        HERMITE = new HermiteCamInterpolation();
        REGISTRY.registerDefault("hermite", (Object)HERMITE);
        REGISTRY.register("cosine", (Object)new SmoothCamInterpolation());
        REGISTRY.register("circular", (Object)new CircularCamInterpolation());
    }
}

