/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.scene;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.cmdcam.common.math.follow.CamFollowConfig;
import team.creative.cmdcam.common.math.interpolation.CamInterpolation;
import team.creative.cmdcam.common.math.interpolation.CamPitchMode;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.cmdcam.common.scene.mode.CamMode;
import team.creative.cmdcam.common.scene.mode.DefaultMode;
import team.creative.cmdcam.common.scene.run.CamRun;
import team.creative.cmdcam.common.target.CamTarget;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.registry.exception.RegistryException;

public class CamScene {
    private boolean started = false;
    private boolean serverSynced = false;
    public long duration;
    public int loop = 0;
    public CamMode mode;
    public CamInterpolation interpolation;
    public CamTarget lookTarget;
    public CamFollowConfig<Vec1d> pitchFollowConfig = new CamFollowConfig(CamAttribute.PITCH, 10.0);
    public CamFollowConfig<Vec1d> yawFollowConfig = new CamFollowConfig(CamAttribute.YAW, 10.0);
    public CamTarget posTarget;
    public CamFollowConfig<Vec3d> posFollowConfig = new CamFollowConfig(CamAttribute.POSITION, 2.0);
    public List<CamPoint> points;
    public boolean smoothBeginning = true;
    public CamPitchMode pitchMode = CamPitchMode.FIX_KEEP_DIRECTION;
    public boolean distanceBasedTiming = false;
    @OnlyIn(value=Dist.CLIENT)
    public CamRun run;

    public static CamScene createDefault() {
        return new CamScene(10000L, 0, "default", new ArrayList<CamPoint>(), CamInterpolation.HERMITE);
    }

    public CamScene(long duration, int loop, String mode, List<CamPoint> points, CamInterpolation interpolation) {
        this.duration = duration;
        this.setMode(mode);
        this.points = points;
        this.interpolation = interpolation;
    }

    public CamScene(CompoundTag nbt) throws RegistryException {
        this.duration = nbt.m_128454_("duration");
        this.loop = nbt.m_128451_("loop");
        this.setMode(nbt.m_128461_("mode"));
        this.interpolation = (CamInterpolation)CamInterpolation.REGISTRY.get(nbt.m_128461_("inter"));
        this.lookTarget = nbt.m_128441_("look_target") ? CamTarget.load(nbt.m_128469_("look_target")) : null;
        this.pitchFollowConfig.load(nbt.m_128469_("pitch"));
        this.yawFollowConfig.load(nbt.m_128469_("yaw"));
        this.posTarget = nbt.m_128441_("pos_target") ? CamTarget.load(nbt.m_128469_("pos_target")) : null;
        this.posFollowConfig.load(nbt.m_128469_("pos"));
        ListTag list = nbt.m_128437_("points", 10);
        this.points = new ArrayList<CamPoint>();
        for (Tag point : list) {
            this.points.add(new CamPoint((CompoundTag)point));
        }
        this.smoothBeginning = nbt.m_128471_("smooth_start");
        this.pitchMode = CamPitchMode.values()[nbt.m_128451_("pitch_mode")];
        this.distanceBasedTiming = nbt.m_128471_("d_timing");
    }

    public void setServerSynced() {
        this.serverSynced = true;
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128356_("duration", this.duration);
        nbt.m_128405_("loop", this.loop);
        nbt.m_128359_("mode", CamMode.REGISTRY.getId((Object)this.mode));
        nbt.m_128359_("inter", CamInterpolation.REGISTRY.getId((Object)this.interpolation));
        if (this.lookTarget != null) {
            nbt.m_128365_("look_target", (Tag)this.lookTarget.save(new CompoundTag()));
        }
        nbt.m_128365_("pitch", (Tag)this.pitchFollowConfig.save(new CompoundTag()));
        nbt.m_128365_("yaw", (Tag)this.yawFollowConfig.save(new CompoundTag()));
        if (this.posTarget != null) {
            nbt.m_128365_("pos_target", (Tag)this.posTarget.save(new CompoundTag()));
        }
        nbt.m_128365_("pos", (Tag)this.posFollowConfig.save(new CompoundTag()));
        ListTag list = new ListTag();
        for (CamPoint point : this.points) {
            list.add((Object)point.save(new CompoundTag()));
        }
        nbt.m_128365_("points", (Tag)list);
        nbt.m_128379_("smooth_start", this.smoothBeginning);
        nbt.m_128405_("pitch_mode", this.pitchMode.ordinal());
        nbt.m_128379_("d_timing", this.distanceBasedTiming);
        return nbt;
    }

    public boolean endless() {
        return this.loop < 0;
    }

    public boolean serverSynced() {
        return this.serverSynced;
    }

    public void play() {
        this.started = true;
    }

    public boolean paused() {
        return !this.run.playing();
    }

    public void togglePause() {
        if (this.playing()) {
            if (this.paused()) {
                this.resume();
            } else {
                this.pause();
            }
        }
    }

    public void pause() {
        this.run.pause();
    }

    public void resume() {
        this.run.resume();
    }

    public void stop() {
        this.run.stop();
    }

    public boolean playing() {
        return this.run != null;
    }

    protected void started(Level level) {
        if (this.lookTarget != null) {
            this.lookTarget.start(level);
        }
        if (this.posTarget != null) {
            this.posTarget.start(level);
        }
        if (level.f_46443_) {
            this.run = new CamRun(level, this);
        }
    }

    public void finish(Level level) {
        if (this.lookTarget != null) {
            this.lookTarget.finish();
        }
        if (this.posTarget != null) {
            this.posTarget.finish();
        }
        this.stop();
        if (level.f_46443_) {
            this.mode.finished(this.run);
            this.run.finish();
            this.run = null;
        }
        this.started = false;
    }

    public void tick(Level level, float deltaTime) {
        if (this.started) {
            this.started = false;
            this.started(level);
        }
        this.run.tick(level, deltaTime);
    }

    public void mcTick(Level level) {
        if (this.started) {
            this.started = false;
            this.started(level);
        }
        this.run.mcTick(level);
    }

    public void set(CamScene scene) {
        this.duration = scene.duration;
        this.loop = scene.loop;
        this.setMode(CamMode.REGISTRY.getId((Object)scene.mode));
        this.points = scene.copyPoints();
        this.interpolation = scene.interpolation;
        this.serverSynced = scene.serverSynced;
        this.lookTarget = scene.lookTarget;
        this.pitchFollowConfig = scene.pitchFollowConfig;
        this.yawFollowConfig = scene.yawFollowConfig;
        this.posTarget = scene.posTarget;
        this.posFollowConfig = scene.posFollowConfig;
        this.smoothBeginning = scene.smoothBeginning;
        this.pitchMode = scene.pitchMode;
        this.distanceBasedTiming = scene.distanceBasedTiming;
    }

    public void setMode(String mode) {
        this.mode = (CamMode)CamMode.REGISTRY.createSafe(DefaultMode.class, mode, new Object[]{this});
    }

    private List<CamPoint> copyPoints() {
        ArrayList<CamPoint> newPoints = new ArrayList<CamPoint>(this.points.size());
        for (int i = 0; i < this.points.size(); ++i) {
            newPoints.add(this.points.get(i).copy());
        }
        return newPoints;
    }

    public CamScene copy() {
        CamScene scene = new CamScene(this.duration, this.loop, CamMode.REGISTRY.getId((Object)this.mode), this.copyPoints(), this.interpolation);
        scene.set(this);
        return scene;
    }

    public <T extends VecNd> CamFollowConfig<T> getConfig(CamAttribute<T> attribute) {
        if (attribute == CamAttribute.POSITION) {
            return this.posFollowConfig;
        }
        if (attribute == CamAttribute.PITCH) {
            return this.pitchFollowConfig;
        }
        if (attribute == CamAttribute.YAW) {
            return this.yawFollowConfig;
        }
        return null;
    }
}

