/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.scene.mode;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.cmdcam.client.CamEventHandlerClient;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.common.scene.mode.DefaultMode;
import team.creative.cmdcam.common.scene.mode.OutsideMode;
import team.creative.cmdcam.common.scene.run.CamRun;
import team.creative.creativecore.common.util.registry.NamedTypeRegistry;

public abstract class CamMode {
    public static final NamedTypeRegistry<CamMode> REGISTRY = new NamedTypeRegistry().addConstructorPattern(new Class[]{CamScene.class});
    public final CamScene scene;

    public CamMode(CamScene scene) {
        this.scene = scene;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void finished(CamRun run) {
        CamEventHandlerClient.resetFOV();
        CamEventHandlerClient.roll = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Entity getCamera();

    @OnlyIn(value=Dist.CLIENT)
    public void process(CamPoint point) {
        CamEventHandlerClient.roll = (float)point.roll;
        CamEventHandlerClient.currentFOV = (float)point.zoom;
        Entity camera = this.getCamera();
        if (camera instanceof Player) {
            ((Player)camera).m_150110_().f_35935_ = true;
        }
        camera.m_19890_(point.x, point.y - (double)camera.m_20192_(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
        camera.f_19859_ = (float)point.rotationYaw;
        camera.f_19860_ = (float)point.rotationPitch;
        camera.m_7678_(point.x, point.y - (double)camera.m_20192_(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
    }

    public abstract boolean outside();

    static {
        REGISTRY.register("default", DefaultMode.class);
        REGISTRY.register("outside", OutsideMode.class);
    }
}

