/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.math.follow;

import team.creative.cmdcam.common.math.follow.CamFollow;
import team.creative.cmdcam.common.math.follow.CamFollowConfig;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class CamFollowStepDistance<T extends VecNd>
extends CamFollow<T> {
    private T aimed;

    public CamFollowStepDistance(CamFollowConfig<T> config) {
        super(config);
    }

    @Override
    public T followInternal(T target) {
        if (this.config.div == 1.0) {
            return (T)target.copy();
        }
        if (this.current == null) {
            this.current = target;
        }
        if (this.config.threshold > 0.0) {
            this.aimed = target;
            target = this.aimed;
        } else {
            this.aimed = target;
        }
        if (this.config.maxSpeed > 0.0) {
            VecNd speed = this.current.copy();
            for (int i = 0; i < speed.dimensions(); ++i) {
                speed.set(i, (this.aimed.get(i) - this.current.get(i)) / this.config.div);
            }
            if (speed.length() > this.config.maxSpeed) {
                speed.normalize();
                speed.scale(this.config.maxSpeed);
            }
            speed.add(this.current);
            return (T)speed;
        }
        VecNd vec = this.current.copy();
        for (int i = 0; i < vec.dimensions(); ++i) {
            vec.set(i, (this.aimed.get(i) - this.current.get(i)) / this.config.div + this.current.get(i));
        }
        this.current = vec;
        return (T)vec;
    }
}

