/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.math.interpolation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.cmdcam.common.math.interpolation.CamInterpolation;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.cmdcam.common.target.CamTarget;
import team.creative.creativecore.common.util.math.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.type.Color;

public class CircularCamInterpolation
extends CamInterpolation {
    public CircularCamInterpolation() {
        super(new Color(255, 255, 0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends VecNd> Interpolation<T> createClient(double[] timed, CamScene scene, T before, List<T> points, T after, CamAttribute<T> attribute) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3d center = scene.lookTarget.position((Level)mc.f_91073_, mc.m_91297_());
        if (center != null) {
            List<Vec3d> points3 = points;
            points.add((Vec3d)((VecNd)points.get(0)));
            Vec3d firstPoint = new Vec3d(((Vec3d)points3.get((int)0)).x, ((Vec3d)points3.get((int)0)).y, ((Vec3d)points3.get((int)0)).z);
            Vec3d centerPoint = new Vec3d(center.x, center.y, center.z);
            Vec3d sphereOrigin = new Vec3d(firstPoint);
            sphereOrigin.sub(centerPoint);
            double radius = sphereOrigin.length();
            ArrayList<Vec1d> vecs = new ArrayList<Vec1d>();
            ArrayList<Double> times = new ArrayList<Double>();
            times.add(0.0);
            vecs.add(new Vec1d(firstPoint.y));
            ArrayList<Vec3d> newPointsSorted = new ArrayList<Vec3d>();
            newPointsSorted.add((Vec3d)points3.get(0));
            for (int i = 1; i < points.size() - 1; ++i) {
                Vec3d point = new Vec3d(((Vec3d)points3.get((int)i)).x, firstPoint.y, ((Vec3d)points3.get((int)i)).z);
                point.sub(centerPoint);
                double dot = point.dot(sphereOrigin);
                double det = point.x * sphereOrigin.z - point.z * sphereOrigin.x;
                double angle = Math.toDegrees(Math.atan2(det, dot));
                if (angle < 0.0) {
                    angle += 360.0;
                }
                double time = angle / 360.0;
                for (int j = 0; j < times.size(); ++j) {
                    if (!((Double)times.get(j) > time)) continue;
                    times.add(j, time);
                    vecs.add(j, new Vec1d(points3.get((int)i).y));
                    newPointsSorted.add(j, points3.get(i));
                    break;
                }
                newPointsSorted.add(points3.get(i));
                times.add(time);
                vecs.add(new Vec1d(points3.get((int)i).y));
            }
            if (scene.loop == 0) {
                newPointsSorted.add(((Vec3d)newPointsSorted.get(0)).copy());
            }
            times.add(1.0);
            vecs.add(new Vec1d(firstPoint.y));
            return new CircularInterpolation(points, scene.lookTarget, sphereOrigin, radius, (HermiteInterpolation<Vec1d>)new HermiteInterpolation(ArrayUtils.toPrimitive((Double[])times.toArray(new Double[0])), (VecNd[])vecs.toArray(new Vec1d[0])));
        }
        return null;
    }

    @Override
    public <T extends VecNd> Interpolation<T> create(double[] timed, CamScene scene, T before, List<T> points, T after, CamAttribute<T> attribute) {
        Interpolation<T> result;
        if (attribute == CamAttribute.POSITION && scene.lookTarget != null && (result = this.createClient(timed, scene, before, points, after, attribute)) != null) {
            return result;
        }
        return new HermiteInterpolation(points);
    }

    public static class CircularInterpolation
    extends HermiteInterpolation<Vec3d> {
        public Vec3d sphereOrigin;
        public double radius;
        public CamTarget target;
        public HermiteInterpolation<Vec1d> yAxis;

        public CircularInterpolation(List<Vec3d> points, CamTarget target, Vec3d sphereOrigin, double radius, HermiteInterpolation<Vec1d> yAxis) {
            super(points);
            this.target = target;
            this.sphereOrigin = sphereOrigin;
            this.radius = radius;
            this.yAxis = yAxis;
        }

        public Vec3d valueAt(double t) {
            Minecraft mc = Minecraft.m_91087_();
            Vec3d center = this.target.position((Level)mc.f_91073_, mc.m_91297_());
            if (center != null) {
                Vec3d centerPoint = new Vec3d(center.x, center.y, center.z);
                double angle = t * 360.0;
                Vec3d newPoint = new Vec3d(this.sphereOrigin);
                newPoint.y = 0.0;
                Matrix3 matrix = new Matrix3();
                matrix.rotY(Math.toRadians(angle));
                matrix.transform(newPoint);
                newPoint.y = ((Vec1d)this.yAxis.valueAt((double)t)).x - center.y;
                newPoint.normalize();
                newPoint.scale(this.radius);
                newPoint.add(centerPoint);
                return newPoint;
            }
            return (Vec3d)super.valueAt(t);
        }
    }
}

