/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.cmdcam.CMDCamConfig;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.common.command.argument.CamModeArgument;
import team.creative.cmdcam.common.command.argument.CamPitchModeArgument;
import team.creative.cmdcam.common.command.argument.DurationArgument;
import team.creative.cmdcam.common.command.argument.InterpolationArgument;
import team.creative.cmdcam.common.command.builder.SceneCommandBuilder;
import team.creative.cmdcam.common.command.builder.SceneStartCommandBuilder;
import team.creative.cmdcam.common.packet.ConnectPacket;
import team.creative.cmdcam.common.packet.GetPathPacket;
import team.creative.cmdcam.common.packet.PausePathPacket;
import team.creative.cmdcam.common.packet.ResumePathPacket;
import team.creative.cmdcam.common.packet.SetPathPacket;
import team.creative.cmdcam.common.packet.StartPathPacket;
import team.creative.cmdcam.common.packet.StopPathPacket;
import team.creative.cmdcam.common.packet.TeleportPathPacket;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.server.CMDCamServer;
import team.creative.cmdcam.server.CamEventHandler;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.network.CreativePacket;

@Mod(value="cmdcam")
public class CMDCam {
    public static final String MODID = "cmdcam";
    private static final Logger LOGGER = LogManager.getLogger((String)"cmdcam");
    public static final CreativeNetwork NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation("cmdcam", "main"));
    public static final CMDCamConfig CONFIG = new CMDCamConfig();
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256982_, (String)"cmdcam");

    public CMDCam() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CMDCamClient.load(FMLJavaModLoadingContext.get().getModEventBus()));
        MinecraftForge.EVENT_BUS.addListener(this::commands);
        COMMAND_ARGUMENT_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        COMMAND_ARGUMENT_TYPES.register("duration", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(DurationArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(() -> DurationArgument.duration())));
        COMMAND_ARGUMENT_TYPES.register("cam_mode", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(CamModeArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(() -> CamModeArgument.mode())));
        COMMAND_ARGUMENT_TYPES.register("interpolation", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(InterpolationArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(() -> InterpolationArgument.interpolation())));
        COMMAND_ARGUMENT_TYPES.register("all_interpolation", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(InterpolationArgument.AllInterpolationArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(() -> InterpolationArgument.interpolationAll())));
        COMMAND_ARGUMENT_TYPES.register("pitch_mode", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(CamPitchModeArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(() -> CamPitchModeArgument.pitchMode())));
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK.registerType(ConnectPacket.class, ConnectPacket::new);
        NETWORK.registerType(GetPathPacket.class, GetPathPacket::new);
        NETWORK.registerType(SetPathPacket.class, SetPathPacket::new);
        NETWORK.registerType(StartPathPacket.class, StartPathPacket::new);
        NETWORK.registerType(StopPathPacket.class, StopPathPacket::new);
        NETWORK.registerType(TeleportPathPacket.class, TeleportPathPacket::new);
        NETWORK.registerType(PausePathPacket.class, PausePathPacket::new);
        NETWORK.registerType(ResumePathPacket.class, ResumePathPacket::new);
        MinecraftForge.EVENT_BUS.register((Object)new CamEventHandler());
        CreativeConfigRegistry.ROOT.registerValue(MODID, (Object)CONFIG);
    }

    private void commands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder camServer = Commands.m_82127_((String)"cam-server");
        SceneStartCommandBuilder.start(camServer, CMDCamServer.PROCESSOR);
        LiteralArgumentBuilder get = Commands.m_82127_((String)"get");
        SceneCommandBuilder.scene(get, CMDCamServer.PROCESSOR);
        camServer.then((ArgumentBuilder)get);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)camServer.then(Commands.m_82127_((String)"stop").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(x -> {
            StopPathPacket packet = new StopPathPacket();
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)x, (String)"players")) {
                NETWORK.sendToClient((CreativePacket)packet, player);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"pause").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(x -> {
            PausePathPacket packet = new PausePathPacket();
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)x, (String)"players")) {
                NETWORK.sendToClient((CreativePacket)packet, player);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"resume").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(x -> {
            ResumePathPacket packet = new ResumePathPacket();
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)x, (String)"players")) {
                NETWORK.sendToClient((CreativePacket)packet, player);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"list").executes(x -> {
            Collection<String> names = CMDCamServer.getSavedPaths((Level)((CommandSourceStack)x.getSource()).m_81372_());
            ((CommandSourceStack)x.getSource()).m_243053_((Component)Component.m_237110_((String)"scenes.list", (Object[])new Object[]{names.size(), String.join((CharSequence)", ", names)}));
            return 0;
        }))).then(Commands.m_82127_((String)"clear").executes(x -> {
            CMDCamServer.clearPaths((Level)((CommandSourceStack)x.getSource()).m_81372_());
            ((CommandSourceStack)x.getSource()).m_81354_((Component)Component.m_237115_((String)"scenes.clear"), true);
            return 0;
        }))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String name = StringArgumentType.getString((CommandContext)x, (String)"name");
            if (CMDCamServer.removePath((Level)((CommandSourceStack)x.getSource()).m_81372_(), name)) {
                ((CommandSourceStack)x.getSource()).m_81354_((Component)Component.m_237110_((String)"scene.remove", (Object[])new Object[]{name}), true);
            } else {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237110_((String)"scene.remove_fail", (Object[])new Object[]{name}));
            }
            return 0;
        })))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String name = StringArgumentType.getString((CommandContext)x, (String)"name");
            if (CMDCamServer.get((Level)((CommandSourceStack)x.getSource()).m_81372_(), name) != null) {
                ((CommandSourceStack)x.getSource()).m_81354_((Component)Component.m_237110_((String)"scene.exists", (Object[])new Object[]{name}), true);
            } else {
                CMDCamServer.set((Level)((CommandSourceStack)x.getSource()).m_81372_(), name, CamScene.createDefault());
                ((CommandSourceStack)x.getSource()).m_81354_((Component)Component.m_237110_((String)"scene.create", (Object[])new Object[]{name}), true);
            }
            return 0;
        }))));
    }
}

