/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.math.point;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.cmdcam.client.CamEventHandlerClient;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.mc.TickUtils;

public class CamPoint
extends Vec3d {
    public double rotationYaw;
    public double rotationPitch;
    public double roll;
    public double zoom;

    @OnlyIn(value=Dist.CLIENT)
    public static CamPoint createLocal() {
        Minecraft mc = Minecraft.m_91087_();
        float partialTicks = TickUtils.getFrameTime((LevelAccessor)mc.f_91073_);
        Vec3 vec = mc.f_91074_.m_20299_(partialTicks);
        return new CamPoint(vec.f_82479_, vec.f_82480_, vec.f_82481_, mc.f_91074_.m_5675_(partialTicks), mc.f_91074_.m_5686_(partialTicks), CamEventHandlerClient.roll, CamEventHandlerClient.currentFOV);
    }

    public static CamPoint create(Entity entity) {
        float partialTicks = TickUtils.getFrameTime((LevelAccessor)entity.f_19853_);
        Vec3 vec = entity.m_20299_(partialTicks);
        if (entity.f_19853_.f_46443_) {
            return new CamPoint(vec.f_82479_, vec.f_82480_, vec.f_82481_, entity.m_5675_(partialTicks), entity.m_5686_(partialTicks), CamEventHandlerClient.roll, CamEventHandlerClient.currentFOV);
        }
        return new CamPoint(vec.f_82479_, vec.f_82480_, vec.f_82481_, entity.m_5675_(partialTicks), entity.m_5686_(partialTicks), 0.0, 70.0);
    }

    public CamPoint(double x, double y, double z, double rotationYaw, double rotationPitch, double roll, double zoom) {
        super(x, y, z);
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        this.roll = roll;
        this.zoom = zoom;
    }

    public CamPoint(HashMap<CamAttribute, VecNd> attributes) {
        for (Map.Entry<CamAttribute, VecNd> entry : attributes.entrySet()) {
            entry.getKey().set(this, entry.getValue());
        }
    }

    public CamPoint(CompoundTag nbt) {
        super(nbt.m_128459_("x"), nbt.m_128459_("y"), nbt.m_128459_("z"));
        this.rotationYaw = nbt.m_128459_("rotationYaw");
        this.rotationPitch = nbt.m_128459_("rotationPitch");
        this.roll = nbt.m_128459_("roll");
        this.zoom = nbt.m_128459_("zoom");
    }

    public final Vec3d calculateViewVector() {
        float f = (float)(this.rotationPitch * (Math.PI / 180));
        float f1 = (float)(-this.rotationYaw * (Math.PI / 180));
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public CamPoint copy() {
        return new CamPoint(this.x, this.y, this.z, this.rotationYaw, this.rotationPitch, this.roll, this.zoom);
    }

    public String toString() {
        return "x:" + this.x + ",y:" + this.y + ",z:" + this.z + ",yaw:" + this.rotationYaw + ",pitch:" + this.rotationPitch + ",roll:" + this.roll + ",zoom:" + this.zoom;
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128347_("x", this.x);
        nbt.m_128347_("y", this.y);
        nbt.m_128347_("z", this.z);
        nbt.m_128347_("rotationYaw", this.rotationYaw);
        nbt.m_128347_("rotationPitch", this.rotationPitch);
        nbt.m_128347_("roll", this.roll);
        nbt.m_128347_("zoom", this.zoom);
        return nbt;
    }
}

