/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.scene.run;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import team.creative.cmdcam.common.math.follow.CamFollow;
import team.creative.cmdcam.common.math.follow.CamFollowConfig;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.math.point.CamPoints;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.cmdcam.common.scene.run.CamRun;
import team.creative.creativecore.common.util.math.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class CamRunStage {
    public final CamRun run;
    public final long duration;
    public final int loops;
    public int looped = 0;
    private boolean started = false;
    private HashMap<CamAttribute, Interpolation> attributes = new HashMap();
    private HashMap<CamAttribute, CamFollow> followAttributes;

    public CamRunStage(CamRun run, long duration, int loops, CamPoints points) {
        this.run = run;
        this.duration = duration;
        this.loops = loops;
        double[] times = points.createTimes(run.scene);
        CamAttribute[] toStore = run.attributes();
        for (int i = 0; i < toStore.length; ++i) {
            ArrayList vecs = new ArrayList(points.size());
            for (CamPoint point : points) {
                vecs.add(toStore[i].get(point));
            }
            this.attributes.put(toStore[i], points.interpolate(times, run.scene, toStore[i]));
        }
    }

    public boolean hasStarted() {
        return this.started;
    }

    private <T extends VecNd> void addFollow(CamAttribute<T> attribute, CamFollowConfig<T> config, CamPoint point) {
        this.followAttributes.put(attribute, config.create(attribute.get(point)));
    }

    public void start() {
        this.followAttributes = new HashMap();
        CamPoint initial = CamPoint.create(this.run.scene.mode.getCamera());
        if (this.run.scene.lookTarget != null) {
            this.addFollow(CamAttribute.PITCH, this.run.scene.pitchFollowConfig, initial);
            this.addFollow(CamAttribute.YAW, this.run.scene.yawFollowConfig, initial);
        }
        if (this.run.scene.posTarget != null) {
            this.addFollow(CamAttribute.POSITION, this.run.scene.posFollowConfig, initial);
        }
        this.started = true;
    }

    public CamPoint calculatePoint(Level level, long position, float partialTicks) {
        Vec3d vec;
        double progress = (double)position / (double)this.duration;
        HashMap<CamAttribute, VecNd> generated = new HashMap<CamAttribute, VecNd>();
        for (Map.Entry<CamAttribute, Interpolation> entry : this.attributes.entrySet()) {
            generated.put(entry.getKey(), entry.getValue().valueAt(progress));
        }
        CamPoint point = new CamPoint(generated);
        CamPoint targetPoint = new CamPoint(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Entity camera = this.run.scene.mode.getCamera();
        Vec3d camPos = new Vec3d(camera.m_20318_(partialTicks));
        if (this.run.scene.lookTarget != null && (vec = this.run.scene.lookTarget.position(level, partialTicks)) != null) {
            this.run.scene.mode.correctTargetPosition(vec);
            double d0 = vec.x - camPos.x;
            double d1 = vec.y - camPos.y;
            double d2 = vec.z - camPos.z;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            targetPoint.rotationPitch = -(Math.atan2(d1, d3) * 180.0 / Math.PI);
            targetPoint.rotationYaw = Math.atan2(d2, d0) * 180.0 / Math.PI - 90.0;
        }
        if (this.run.scene.posTarget != null) {
            targetPoint.set(point);
            vec = new Vec3d(this.run.scene.posTarget.position(level, partialTicks));
            this.run.scene.mode.correctTargetPosition(vec);
            targetPoint.add(vec);
        }
        for (Map.Entry<CamAttribute, CamFollow> entry : this.followAttributes.entrySet()) {
            entry.getKey().set(point, entry.getValue().follow(entry.getKey().get(targetPoint)));
        }
        return point;
    }

    public boolean endless() {
        return this.loops < 0;
    }
}

