/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.creative.cmdcam.CMDCam;
import team.creative.cmdcam.client.CamCommandProcessorClient;
import team.creative.cmdcam.client.CamEventHandlerClient;
import team.creative.cmdcam.client.KeyHandler;
import team.creative.cmdcam.client.SceneException;
import team.creative.cmdcam.common.command.CamCommandProcessor;
import team.creative.cmdcam.common.command.argument.InterpolationArgument;
import team.creative.cmdcam.common.command.builder.PointArgumentBuilder;
import team.creative.cmdcam.common.command.builder.SceneCommandBuilder;
import team.creative.cmdcam.common.command.builder.SceneStartCommandBuilder;
import team.creative.cmdcam.common.math.interpolation.CamInterpolation;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.packet.GetPathPacket;
import team.creative.cmdcam.common.packet.SetPathPacket;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.network.CreativePacket;

public class CMDCamClient {
    public static final Minecraft mc = Minecraft.m_91087_();
    public static final CamCommandProcessorClient PROCESSOR = new CamCommandProcessorClient();
    public static final HashMap<String, CamScene> SCENES = new HashMap();
    private static final CamScene scene = CamScene.createDefault();
    private static CamScene playing;
    private static boolean serverAvailable;
    private static boolean hideGuiCache;
    private static boolean hasTargetMarker;
    private static CamPoint targetMarker;

    public static void resetServerAvailability() {
        serverAvailable = false;
    }

    public static void setServerAvailability() {
        serverAvailable = true;
    }

    public static void init(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new CamEventHandlerClient());
        CreativeCoreClient.registerClientConfig((String)"cmdcam");
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "SERVER_ONLY", (a, b) -> true));
    }

    public static void load(IEventBus bus) {
        bus.addListener(CMDCamClient::init);
        MinecraftForge.EVENT_BUS.addListener(CMDCamClient::commands);
        bus.addListener(KeyHandler::registerKeys);
    }

    public static void commands(RegisterClientCommandsEvent event) {
        LiteralArgumentBuilder cam = Commands.m_82127_((String)"cam");
        SceneStartCommandBuilder.start(cam, PROCESSOR);
        SceneCommandBuilder.scene(cam, PROCESSOR);
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)cam.then(Commands.m_82127_((String)"stop").executes(x -> {
            CMDCamClient.stop();
            return 0;
        }))).then(Commands.m_82127_((String)"pause").executes(x -> {
            CMDCamClient.pause();
            return 0;
        }))).then(Commands.m_82127_((String)"resume").executes(x -> {
            CMDCamClient.resume();
            return 0;
        }))).then(Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            if (!interpolation.equalsIgnoreCase("all")) {
                ((CamInterpolation)CamInterpolation.REGISTRY.get((String)interpolation)).isRenderingEnabled = true;
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.interpolation.show", (Object[])new Object[]{interpolation}), false);
            } else {
                for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
                    movement.isRenderingEnabled = true;
                }
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237115_((String)"scene.interpolation.show_all"), false);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"hide").then(Commands.m_82129_((String)"interpolation", (ArgumentType)InterpolationArgument.interpolationAll()).executes(x -> {
            String interpolation = StringArgumentType.getString((CommandContext)x, (String)"interpolation");
            if (!interpolation.equalsIgnoreCase("all")) {
                ((CamInterpolation)CamInterpolation.REGISTRY.get((String)interpolation)).isRenderingEnabled = false;
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scene.interpolation.hide", (Object[])new Object[]{interpolation}), false);
            } else {
                for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
                    movement.isRenderingEnabled = false;
                }
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237115_((String)"scene.interpolation.hide_all"), false);
            }
            return 0;
        })))).then(Commands.m_82127_((String)"list").executes(x -> {
            if (serverAvailable) {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)"scenes.list_fail"));
                return 0;
            }
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scenes.list", (Object[])new Object[]{SCENES.size(), String.join((CharSequence)", ", SCENES.keySet())}), true);
            return 0;
        }))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            if (serverAvailable) {
                CMDCam.NETWORK.sendToServer((CreativePacket)new GetPathPacket(pathArg));
            } else {
                CamScene scene = SCENES.get(pathArg);
                if (scene != null) {
                    CMDCamClient.set(scene);
                    ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scenes.load", (Object[])new Object[]{pathArg}), false);
                } else {
                    ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237110_((String)"scenes.load_fail", (Object[])new Object[]{pathArg}));
                }
            }
            return 0;
        })))).then(Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"path", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String pathArg = StringArgumentType.getString((CommandContext)x, (String)"path");
            try {
                CamScene scene = CMDCamClient.createScene();
                if (serverAvailable) {
                    CMDCam.NETWORK.sendToServer((CreativePacket)new SetPathPacket(pathArg, scene));
                } else {
                    SCENES.put(pathArg, scene);
                    ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)"scenes.save", (Object[])new Object[]{pathArg}), false);
                }
            }
            catch (SceneException e) {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)e.getMessage()));
            }
            return 0;
        })))).then(new PointArgumentBuilder("follow_center", (x, y) -> {
            targetMarker = y;
        }, (CamCommandProcessor)PROCESSOR).executes(x -> {
            targetMarker = CamPoint.createLocal();
            return 0;
        })));
    }

    public static void renderBefore(RenderPlayerEvent.Pre event) {
    }

    public static CamScene getScene() {
        if (CMDCamClient.isPlaying()) {
            return playing;
        }
        return scene;
    }

    public static CamScene getConfigScene() {
        return scene;
    }

    public static boolean isPlaying() {
        return playing != null;
    }

    public static List<CamPoint> getPoints() {
        return CMDCamClient.scene.points;
    }

    public static void set(CamScene scene) {
        CMDCamClient.scene.set(scene);
        CMDCamClient.checkTargetMarker();
    }

    public static void checkTargetMarker() {
        boolean bl = hasTargetMarker = CMDCamClient.scene.posTarget != null;
        if (hasTargetMarker && targetMarker == null) {
            targetMarker = CamPoint.createLocal();
        }
    }

    public static void start(CamScene scene) {
        if (scene.points.isEmpty()) {
            return;
        }
        if (scene.points.size() == 1) {
            scene.points.add(scene.points.get(0));
        }
        playing = scene;
        playing.play();
    }

    public static void pause() {
        if (playing != null) {
            playing.pause();
        }
        CMDCamClient.mc.f_91066_.f_92062_ = hideGuiCache;
    }

    public static void resume() {
        if (playing != null) {
            playing.resume();
        }
    }

    public static void stop() {
        if (playing == null) {
            return;
        }
        if (playing.serverSynced()) {
            return;
        }
        playing.finish((Level)CMDCamClient.mc.f_91073_);
        playing = null;
        CMDCamClient.mc.f_91066_.f_92062_ = hideGuiCache;
    }

    public static void stopServer() {
        if (playing == null) {
            return;
        }
        playing.finish((Level)CMDCamClient.mc.f_91073_);
        playing = null;
        CMDCamClient.mc.f_91066_.f_92062_ = hideGuiCache;
    }

    public static void noTickPath(Level level, float renderTickTime) {
        hideGuiCache = CMDCamClient.mc.f_91066_.f_92062_;
    }

    public static void mcTickPath(Level level) {
        playing.mcTick(level);
    }

    public static void tickPath(Level level, float renderTickTime) {
        playing.tick(level, renderTickTime);
        if (!playing.playing()) {
            CMDCamClient.mc.f_91066_.f_92062_ = hideGuiCache;
            playing = null;
        }
    }

    public static void resetTargetMarker() {
        targetMarker = null;
    }

    public static boolean hasTargetMarker() {
        return hasTargetMarker && targetMarker != null && CMDCamClient.scene.posTarget != null;
    }

    public static CamPoint getTargetMarker() {
        return targetMarker;
    }

    public static CamScene createScene() throws SceneException {
        if (CMDCamClient.scene.points.size() < 1) {
            throw new SceneException("scene.create_fail");
        }
        CamScene newScene = scene.copy();
        if (newScene.points.size() == 1) {
            newScene.points.add(newScene.points.get(0));
        }
        return newScene;
    }

    public static void teleportTo(CamPoint point) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91074_.m_150110_().f_35935_ = true;
        CamEventHandlerClient.roll = (float)point.roll;
        CamEventHandlerClient.currentFOV = (float)point.zoom;
        mc.f_91074_.m_19890_(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
        mc.f_91074_.m_19890_(point.x, point.y - (double)mc.f_91074_.m_20192_(), point.z, (float)point.rotationYaw, (float)point.rotationPitch);
    }

    static {
        serverAvailable = false;
    }
}

