/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.command.builder;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import team.creative.cmdcam.client.SceneException;
import team.creative.cmdcam.common.command.CamCommandProcessor;
import team.creative.cmdcam.common.target.CamTarget;

public class TargetArgumentBuilder
extends ArgumentBuilder<CommandSourceStack, TargetArgumentBuilder> {
    private final String literal;
    private final boolean look;
    private final CamCommandProcessor processor;

    public TargetArgumentBuilder(String literal, boolean look, CamCommandProcessor processor) {
        this.literal = literal;
        this.look = look;
        this.processor = processor;
    }

    public String getLiteral() {
        return this.literal;
    }

    protected TargetArgumentBuilder getThis() {
        return this;
    }

    private String translatePrefix() {
        if (this.look) {
            return "scene.look.target.";
        }
        return "scene.follow.target.";
    }

    public CommandNode<CommandSourceStack> build() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)this.literal).then(Commands.m_82127_((String)"none").executes(x -> {
            try {
                this.processor.setTarget((CommandContext<CommandSourceStack>)x, null, this.look);
            }
            catch (SceneException e) {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)e.getMessage()));
            }
            this.processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237115_((String)(this.translatePrefix() + "remove")), false);
            return 0;
        }))).then(Commands.m_82127_((String)"self").executes(x -> {
            try {
                this.processor.setTarget((CommandContext<CommandSourceStack>)x, new CamTarget.SelfTarget(), this.look);
            }
            catch (SceneException e) {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)e.getMessage()));
            }
            this.processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237115_((String)(this.translatePrefix() + "self")), false);
            return 0;
        }))).then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(x -> {
            Player player = this.processor.getPlayer((CommandContext<CommandSourceStack>)x, "player");
            try {
                this.processor.setTarget((CommandContext<CommandSourceStack>)x, new CamTarget.PlayerTarget(player), this.look);
            }
            catch (SceneException e) {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)e.getMessage()));
            }
            this.processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)(this.translatePrefix() + "player"), (Object[])new Object[]{player.m_6302_()}), false);
            return 0;
        })))).then(Commands.m_82127_((String)"entity").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(x -> {
            Entity entity = this.processor.getEntity((CommandContext<CommandSourceStack>)x, "entity");
            try {
                this.processor.setTarget((CommandContext<CommandSourceStack>)x, new CamTarget.EntityTarget(entity), this.look);
            }
            catch (SceneException e) {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)e.getMessage()));
            }
            this.processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)(this.translatePrefix() + "entity"), (Object[])new Object[]{entity.m_20149_()}), false);
            return 0;
        })))).then(Commands.m_82127_((String)"pos").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(x -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)x, (String)"pos");
            try {
                this.processor.setTarget((CommandContext<CommandSourceStack>)x, new CamTarget.BlockTarget(pos), this.look);
            }
            catch (SceneException e) {
                ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)e.getMessage()));
            }
            this.processor.markDirty((CommandContext<CommandSourceStack>)x);
            ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237110_((String)(this.translatePrefix() + "pos"), (Object[])new Object[]{pos.m_123344_()}), false);
            return 0;
        })));
        if (this.processor.canSelectTarget()) {
            builder.then(Commands.m_82127_((String)"select").executes(x -> {
                try {
                    this.processor.selectTarget((CommandContext<CommandSourceStack>)x, this.look);
                }
                catch (SceneException e) {
                    ((CommandSourceStack)x.getSource()).m_81352_((Component)Component.m_237115_((String)e.getMessage()));
                }
                ((CommandSourceStack)x.getSource()).m_288197_(() -> Component.m_237115_((String)(this.translatePrefix() + "select")), false);
                return 0;
            }));
        }
        return builder.build();
    }
}

