/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.math.follow;

import net.minecraft.nbt.CompoundTag;
import team.creative.cmdcam.common.math.follow.CamFollow;
import team.creative.cmdcam.common.math.follow.CamFollowStepDistance;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.creativecore.common.util.math.vec.VecNd;

public class CamFollowConfig<T extends VecNd> {
    public final CamAttribute attribute;
    public String type = "step";
    public double div = 20.0;
    public double threshold;
    public double maxSpeed;

    public CamFollowConfig(CamAttribute attribute) {
        this.attribute = attribute;
    }

    public CamFollowConfig(CamAttribute attribute, double div) {
        this(attribute);
        this.div = div;
    }

    public CamFollowConfig(CamAttribute attribute, String type, double div) {
        this(attribute, div);
        this.type = type;
    }

    public CamFollow<T> create(T initial) {
        if (this.div < 1.0) {
            this.div = 1.0;
        }
        CamFollow follow = (CamFollow)CamFollow.REGISTRY.createSafe(CamFollowStepDistance.class, this.type, new Object[]{this});
        follow.setInitial(initial);
        return follow;
    }

    public void load(CompoundTag nbt) {
        this.type = nbt.m_128461_("type");
        this.div = Math.max(1.0, nbt.m_128459_("div"));
        this.threshold = nbt.m_128459_("threshold");
        this.maxSpeed = nbt.m_128459_("max_speed");
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.m_128359_("type", this.type);
        nbt.m_128347_("div", this.div);
        if (this.threshold > 0.0) {
            nbt.m_128347_("threshold", this.threshold);
        }
        if (this.maxSpeed > 0.0) {
            nbt.m_128347_("max_speed", this.maxSpeed);
        }
        return nbt;
    }

    public CamFollowConfig<T> copy() {
        CamFollowConfig<T> copy = new CamFollowConfig<T>(this.attribute);
        copy.type = this.type;
        copy.div = this.div;
        copy.threshold = this.threshold;
        copy.maxSpeed = this.maxSpeed;
        return copy;
    }
}

