/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.client.KeyHandler;
import team.creative.cmdcam.client.SceneException;
import team.creative.cmdcam.client.mixin.GameRendererAccessor;
import team.creative.cmdcam.common.math.interpolation.CamInterpolation;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.math.point.CamPoints;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.cmdcam.common.scene.mode.OutsideMode;
import team.creative.cmdcam.common.target.CamTarget;
import team.creative.creativecore.common.util.math.interpolation.Interpolation;
import team.creative.creativecore.common.util.math.vec.Vec3d;

@OnlyIn(value=Dist.CLIENT)
public class CamEventHandlerClient {
    public static final Minecraft MC = Minecraft.m_91087_();
    public static final double ZOOM_STEP = 0.005;
    public static final float ROLL_STEP = 1.5f;
    public static final double MAX_FOV = 170.0;
    public static final double MIN_FOV = 0.1;
    public static final double FOV_RANGE = 169.9;
    public static final double FOV_RANGE_HALF = 84.95;
    public static Entity camera = null;
    private static double fov = 0.0;
    private static float roll = 0.0f;
    private static Consumer<CamTarget> selectingTarget = null;
    private static boolean renderingHand = false;
    private static boolean skipFov = false;

    public static void startSelectionMode(Consumer<CamTarget> selectingTarget) {
        CamEventHandlerClient.selectingTarget = selectingTarget;
    }

    public static void resetRoll() {
        roll = 0.0f;
    }

    public static float roll() {
        return roll;
    }

    public static void roll(float roll) {
        CamEventHandlerClient.roll = roll;
    }

    public static void resetFOV() {
        fov = 0.0;
    }

    public static double fovExactVanilla(float partialTickTime) {
        try {
            skipFov = true;
            double d = ((GameRendererAccessor)CamEventHandlerClient.MC.f_91063_).callGetFov(CamEventHandlerClient.MC.f_91063_.m_109153_(), partialTickTime, true);
            return d;
        }
        finally {
            skipFov = false;
        }
    }

    public static double fovExact(float partialTickTime) {
        return CamEventHandlerClient.fovExactVanilla(partialTickTime) + fov;
    }

    public static void fov(double fov) {
        CamEventHandlerClient.fov = fov;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (CamEventHandlerClient.MC.f_91074_ != null && CamEventHandlerClient.MC.f_91073_ != null && !MC.m_91104_() && CMDCamClient.isPlaying()) {
            CMDCamClient.gameTickPath((Level)CamEventHandlerClient.MC.f_91073_);
        }
    }

    private double calculatePointInCurve(double fov) {
        fov -= 0.1;
        fov /= 84.95;
        fov = Mth.m_14008_((double)fov, (double)0.0, (double)2.0);
        return Math.asin(fov - 1.0) / Math.PI + 0.5;
    }

    private double transformFov(double x) {
        if (x <= 0.0) {
            return 0.1;
        }
        if (x >= 1.0) {
            return 170.0;
        }
        return (Math.sin((x - 0.5) * Math.PI) + 1.0) * 84.95 + 0.1;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (CamEventHandlerClient.MC.f_91073_ == null) {
            CMDCamClient.resetServerAvailability();
            CMDCamClient.resetTargetMarker();
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        renderingHand = false;
        if (CamEventHandlerClient.MC.f_91074_ != null && CamEventHandlerClient.MC.f_91073_ != null && !MC.m_91104_()) {
            if (CMDCamClient.isPlaying()) {
                while (CamEventHandlerClient.MC.f_91066_.f_92089_.m_90859_()) {
                    if (!CMDCamClient.isPlaying() || CMDCamClient.getScene().mode.outside()) continue;
                    CMDCamClient.getScene().togglePause();
                }
                CMDCamClient.renderTickPath((Level)CamEventHandlerClient.MC.f_91073_, event.renderTickTime);
            } else {
                double multiplier;
                CMDCamClient.noTickPath((Level)CamEventHandlerClient.MC.f_91073_, event.renderTickTime);
                double timeFactor = MC.m_91297_();
                double vanillaFov = CamEventHandlerClient.fovExactVanilla(event.renderTickTime);
                double currentFov = vanillaFov + fov;
                double x = this.calculatePointInCurve(currentFov);
                double d = multiplier = CamEventHandlerClient.MC.f_91074_.m_6047_() ? 5.0 : 1.0;
                if (KeyHandler.zoomIn.m_90857_()) {
                    fov = this.transformFov(multiplier * timeFactor * -0.005 + x) - vanillaFov;
                }
                if (KeyHandler.zoomOut.m_90857_()) {
                    fov = this.transformFov(multiplier * timeFactor * 0.005 + x) - vanillaFov;
                }
                if (KeyHandler.zoomCenter.m_90857_()) {
                    CamEventHandlerClient.resetFOV();
                }
                if (KeyHandler.rollLeft.m_90857_()) {
                    roll = (float)((double)roll - timeFactor * 1.5);
                }
                if (KeyHandler.rollRight.m_90857_()) {
                    roll = (float)((double)roll + timeFactor * 1.5);
                }
                if (KeyHandler.rollCenter.m_90857_()) {
                    CamEventHandlerClient.resetRoll();
                }
                while (KeyHandler.pointKey.m_90859_()) {
                    CamPoint point = CamPoint.createLocal();
                    if (CMDCamClient.getScene().posTarget != null) {
                        CamPoint vec = CMDCamClient.getTargetMarker();
                        if (vec == null) {
                            CamEventHandlerClient.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"scene.follow.no_marker", (Object[])new Object[]{CMDCamClient.getPoints().size()}));
                            continue;
                        }
                        point.sub(vec);
                    }
                    CMDCamClient.getPoints().add(point);
                    CamEventHandlerClient.MC.f_91074_.m_213846_((Component)Component.m_237110_((String)"scene.add", (Object[])new Object[]{CMDCamClient.getPoints().size()}));
                }
            }
            if (KeyHandler.startStop.m_90859_()) {
                if (CMDCamClient.isPlaying()) {
                    CMDCamClient.stop();
                } else {
                    try {
                        CMDCamClient.start(CMDCamClient.createScene());
                    }
                    catch (SceneException e) {
                        CamEventHandlerClient.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)e.getMessage()));
                    }
                }
            }
            while (KeyHandler.clearPoint.m_90859_()) {
                CMDCamClient.getPoints().clear();
                CamEventHandlerClient.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"scene.clear"));
            }
        }
    }

    @SubscribeEvent
    public void fov(ViewportEvent.ComputeFov event) {
        if (skipFov) {
            return;
        }
        if (!renderingHand) {
            if (CMDCamClient.isPlaying()) {
                event.setFOV(fov);
            } else {
                event.setFOV(event.getFOV() + fov);
            }
            event.setFOV(Mth.m_14008_((double)event.getFOV(), (double)0.1, (double)170.0));
        }
        renderingHand = !renderingHand;
    }

    @SubscribeEvent
    public void worldRender(RenderLevelStageEvent event) {
        if (CMDCamClient.isPlaying() || event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        Vec3 view = CamEventHandlerClient.MC.f_91063_.m_109153_().m_90583_();
        RenderSystem.setProjectionMatrix((Matrix4f)event.getProjectionMatrix(), (VertexSorting)VertexSorting.f_276633_);
        PoseStack mat = RenderSystem.getModelViewStack();
        mat.m_85836_();
        mat.m_166856_();
        mat.m_252931_(event.getPoseStack().m_85850_().m_252922_());
        mat.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)false);
        if (CMDCamClient.hasTargetMarker()) {
            CamPoint point = CMDCamClient.getTargetMarker();
            CamEventHandlerClient.renderHitbox(mat, MC.m_91269_().m_110104_().m_6299_(RenderType.m_110504_()), new AABB(point.x - 0.3, point.y - 1.62, point.z - 0.3, point.x + 0.3, point.y + 0.18, point.z + 0.3), CamEventHandlerClient.MC.f_91074_.m_20192_(), point, point.calculateViewVector());
        }
        boolean shouldRender = false;
        for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
            if (!movement.isRenderingEnabled) continue;
            shouldRender = true;
            break;
        }
        PoseStack pose = new PoseStack();
        if (shouldRender && CMDCamClient.getPoints().size() > 0) {
            for (int i = 0; i < CMDCamClient.getPoints().size(); ++i) {
                CamPoint point = CMDCamClient.getPoints().get(i);
                if (CMDCamClient.hasTargetMarker()) {
                    point = point.copy();
                    point.add(CMDCamClient.getTargetMarker());
                }
                DebugRenderer.m_269008_((PoseStack)pose, (MultiBufferSource)MC.m_91269_().m_110104_(), (double)(point.x - 0.05), (double)(point.y - 0.05), (double)(point.z - 0.05), (double)(point.x + 0.05), (double)(point.y + 0.05), (double)(point.z + 0.05), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                DebugRenderer.m_269271_((PoseStack)pose, (MultiBufferSource)MC.m_91269_().m_110104_(), (String)("" + (i + 1)), (double)(point.x + view.f_82479_), (double)(point.y + 0.2 + view.f_82480_), (double)(point.z + view.f_82481_), (int)-1);
                RenderSystem.depthMask((boolean)false);
            }
            MC.m_91269_().m_110104_().m_173043_();
            try {
                mat.m_85836_();
                CamScene scene = CMDCamClient.createScene();
                for (CamInterpolation movement : CamInterpolation.REGISTRY.values()) {
                    if (!movement.isRenderingEnabled) continue;
                    this.renderPath(pose, movement, scene);
                }
                mat.m_85849_();
            }
            catch (SceneException sceneException) {
                // empty catch block
            }
        }
        mat.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableBlend();
    }

    public void renderPath(PoseStack mat, CamInterpolation inter, CamScene scene) {
        double steps = 20 * (scene.points.size() - 1);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        RenderSystem.lineWidth((float)1.0f);
        Vec3d color = inter.color.toVec();
        bufferbuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        CamPoints points = new CamPoints(scene.points);
        if (scene.lookTarget != null) {
            scene.lookTarget.start((Level)CamEventHandlerClient.MC.f_91073_);
        }
        if (scene.posTarget != null) {
            scene.posTarget.start((Level)CamEventHandlerClient.MC.f_91073_);
        }
        double[] times = points.createTimes(scene);
        Interpolation<Vec3d> interpolation = inter.create(times, scene, null, new ArrayList<CamPoint>(scene.points), null, CamAttribute.POSITION);
        int i = 0;
        while ((double)i < steps) {
            Vec3d pos = (Vec3d)interpolation.valueAt((double)i / steps);
            if (CMDCamClient.hasTargetMarker()) {
                pos.add((Vec3d)CMDCamClient.getTargetMarker());
            }
            bufferbuilder.m_5483_((double)((float)pos.x), (double)((float)pos.y), (double)((float)pos.z)).m_85950_((float)color.x, (float)color.y, (float)color.z, 1.0f).m_5752_();
            ++i;
        }
        CamPoint last = scene.points.get(scene.points.size() - 1).copy();
        if (CMDCamClient.hasTargetMarker()) {
            last.add(CMDCamClient.getTargetMarker());
        }
        bufferbuilder.m_5483_((double)((float)last.x), (double)((float)last.y), (double)((float)last.z)).m_85950_((float)color.x, (float)color.y, (float)color.z, 1.0f).m_5752_();
        tessellator.m_85914_();
        if (scene.lookTarget != null) {
            scene.lookTarget.finish();
        }
        if (scene.posTarget != null) {
            scene.posTarget.finish();
        }
    }

    private static void renderHitbox(PoseStack pMatrixStack, VertexConsumer pBuffer, AABB aabb, float eyeHeight, Vec3d origin, Vec3d view) {
        LevelRenderer.m_109646_((PoseStack)pMatrixStack, (VertexConsumer)pBuffer, (AABB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 0.01f;
        LevelRenderer.m_109608_((PoseStack)pMatrixStack, (VertexConsumer)pBuffer, (double)aabb.f_82288_, (double)(aabb.f_82289_ + (double)(eyeHeight - f)), (double)aabb.f_82290_, (double)aabb.f_82291_, (double)(aabb.f_82289_ + (double)(eyeHeight + f)), (double)aabb.f_82293_, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Matrix4f matrix4f = pMatrixStack.m_85850_().m_252922_();
        Matrix3f matrix3f = pMatrixStack.m_85850_().m_252943_();
        pBuffer.m_252986_(matrix4f, (float)origin.x, (float)origin.y, (float)origin.z).m_6122_(0, 0, 255, 255).m_252939_(matrix3f, (float)view.x, (float)view.y, (float)view.z).m_5752_();
        pBuffer.m_252986_(matrix4f, (float)(origin.x + view.x * 2.0), (float)(origin.y + view.y * 2.0), (float)(origin.z + view.z * 2.0)).m_6122_(0, 0, 255, 255).m_252939_(matrix3f, (float)view.x, (float)view.y, (float)view.z).m_5752_();
    }

    @SubscribeEvent
    public void cameraRoll(ViewportEvent.ComputeCameraAngles event) {
        event.setRoll(roll);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (selectingTarget == null || !event.getLevel().f_46443_) {
            return;
        }
        if (event instanceof PlayerInteractEvent.EntityInteract) {
            selectingTarget.accept(new CamTarget.EntityTarget(((PlayerInteractEvent.EntityInteract)event).getTarget()));
            event.getEntity().m_213846_((Component)Component.m_237110_((String)"scene.look.target.entity", (Object[])new Object[]{((PlayerInteractEvent.EntityInteract)event).getTarget().m_20149_()}));
            selectingTarget = null;
        }
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            selectingTarget.accept(new CamTarget.BlockTarget(event.getPos()));
            event.getEntity().m_213846_((Component)Component.m_237110_((String)"scene.look.target.pos", (Object[])new Object[]{event.getPos().m_123344_()}));
            selectingTarget = null;
        }
    }

    public static void setupMouseHandlerBefore() {
        if (CMDCamClient.isPlaying() && CMDCamClient.getScene().mode instanceof OutsideMode) {
            camera = CamEventHandlerClient.MC.f_91075_;
            CamEventHandlerClient.MC.f_91075_ = CamEventHandlerClient.MC.f_91074_;
        }
    }

    public static void setupMouseHandlerAfter() {
        if (CMDCamClient.isPlaying() && CMDCamClient.getScene().mode instanceof OutsideMode) {
            CamEventHandlerClient.MC.f_91075_ = camera;
            camera = null;
        }
    }
}

