/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.scene.run;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.client.SceneException;
import team.creative.cmdcam.common.math.interpolation.CamPitchMode;
import team.creative.cmdcam.common.math.point.CamPoint;
import team.creative.cmdcam.common.math.point.CamPoints;
import team.creative.cmdcam.common.mod.minema.MinemaAddon;
import team.creative.cmdcam.common.mod.minema.MinemaTimer;
import team.creative.cmdcam.common.scene.CamScene;
import team.creative.cmdcam.common.scene.attribute.CamAttribute;
import team.creative.cmdcam.common.scene.run.CamRunStage;
import team.creative.cmdcam.common.scene.timer.RealTimeTimer;
import team.creative.cmdcam.common.scene.timer.RunTimer;

@OnlyIn(value=Dist.CLIENT)
public class CamRun {
    private static Minecraft mc = Minecraft.m_91087_();
    public static final CamAttribute[] PATH_ATTRIBUTES = new CamAttribute[]{CamAttribute.POSITION, CamAttribute.PITCH, CamAttribute.YAW, CamAttribute.ZOOM, CamAttribute.ROLL};
    public final CamScene scene;
    protected final List<CamRunStage> stages = new ArrayList<CamRunStage>();
    public double sizeOfIteration;
    private RunTimer timer;
    private boolean running;
    private int currentStage;
    private boolean finished;

    public CamRun(Level level, CamScene scene) {
        CamPoints points;
        LocalPlayer camera = Minecraft.m_91087_().f_91074_;
        this.scene = scene;
        if (scene.smoothBeginning) {
            points = new CamPoints();
            CamPoint camPoint = CamPoint.create((Entity)camera);
            try {
                CMDCamClient.PROCESSOR.makeRelative(scene, level, camPoint);
            }
            catch (SceneException sceneException) {
                // empty catch block
            }
            points.add(camPoint);
            points.add(scene.points.get(0).copy());
            points.after(scene.points.get(0).copy());
            points.fixSpinning(CamPitchMode.FIX);
            this.stages.add(new CamRunStage(this, (long)Mth.m_14085_((double)(points.estimateLength() / 10.0), (double)1000.0, (double)20000.0), 0, points));
        }
        points = new CamPoints(scene.points);
        if (scene.loop != 0 && scene.points.size() > 1) {
            points.add(scene.points.get(0).copy());
            points.after(scene.points.get(1).copy());
        }
        points.fixSpinning(scene.pitchMode);
        this.stages.add(new CamRunStage(this, scene.duration, 0, points){

            @Override
            public void start() {
                super.start();
                if (MinemaAddon.installed()) {
                    MinemaAddon.startCapture();
                }
            }
        });
        if (scene.loop != 0 && scene.loop != 1) {
            points = new CamPoints(scene.points);
            points.before(scene.points.get(scene.points.size() - 1).copy());
            points.add(scene.points.get(0).copy());
            points.after(scene.points.get(1).copy());
            points.fixSpinning(scene.pitchMode);
            this.stages.add(new CamRunStage(this, scene.duration, scene.loop > 0 ? scene.loop - 1 : scene.loop, points));
        }
        if (scene.loop > 0) {
            points = new CamPoints(scene.points);
            points.before(scene.points.get(scene.points.size() - 1).copy());
            points.after(scene.points.get(scene.points.size() - 1).copy());
            points.fixSpinning(scene.pitchMode);
            this.stages.add(new CamRunStage(this, scene.duration, 0, points));
        }
        this.currentStage = 0;
        this.timer = MinemaAddon.installed() ? new MinemaTimer() : new RealTimeTimer();
        this.finished = false;
        this.running = true;
    }

    public void renderTick(Level level, float deltaTime) {
        CamRunStage stage = this.stages.get(this.currentStage);
        if (!stage.hasStarted()) {
            stage.start();
        }
        long time = this.position(deltaTime);
        if (!stage.endless() && time >= stage.duration) {
            this.timer.stageCompleted();
            if (stage.looped < stage.loops || stage.loops < 0) {
                ++stage.looped;
            } else {
                ++this.currentStage;
                if (this.currentStage < this.stages.size()) {
                    stage = this.stages.get(this.currentStage);
                    stage.start();
                    time = 0L;
                } else {
                    this.scene.finish(level);
                    return;
                }
            }
        }
        CamRun.mc.f_91066_.f_92062_ = true;
        this.scene.mode.process(stage.calculatePoint(level, time, deltaTime));
    }

    public void gameTick(Level level) {
        this.timer.tick(this.running);
    }

    public CamAttribute[] attributes() {
        return PATH_ATTRIBUTES;
    }

    public void finish() {
        if (MinemaAddon.installed()) {
            MinemaAddon.stopCapture();
        }
    }

    public long position(float partialTick) {
        return this.timer.position(this.running, partialTick);
    }

    public boolean playing() {
        return this.running;
    }

    public boolean done() {
        return this.finished;
    }

    public void pause() {
        this.running = false;
        this.timer.pause();
    }

    public void resume() {
        this.running = true;
        this.timer.resume();
    }

    public void stop() {
        this.finished = true;
        this.running = false;
        if (MinemaAddon.installed()) {
            MinemaAddon.stopCapture();
        }
    }
}

