/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class CamTarget {
    private static HashMap<String, Class<? extends CamTarget>> targetTypes = new HashMap();
    private static HashMap<Class<? extends CamTarget>, String> targetTypesInverted = new HashMap();

    public static void registerTargetType(Class<? extends CamTarget> targetClass, String id) {
        targetTypes.put(id, targetClass);
        targetTypesInverted.put(targetClass, id);
    }

    public static Class<? extends CamTarget> getClassByID(String id) {
        return targetTypes.get(id);
    }

    public static CamTarget readFromNBT(CompoundNBT nbt) {
        Class<? extends CamTarget> targetClass = CamTarget.getClassByID(nbt.func_74779_i("id"));
        if (targetClass != null) {
            try {
                return targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.out.println("Invalid target class " + nbt.func_74779_i("id") + "," + targetClass.getName());
            }
        }
        return null;
    }

    public abstract Vector3d getTargetVec(World var1, float var2);

    protected abstract void write(CompoundNBT var1);

    protected abstract void read(CompoundNBT var1);

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        nbt.func_74778_a("id", targetTypesInverted.get(this.getClass()));
        this.write(nbt);
        return nbt;
    }

    public void start(World world) {
    }

    public void finish() {
    }

    static {
        CamTarget.registerTargetType(BlockTarget.class, "block");
        CamTarget.registerTargetType(EntityTarget.class, "entity");
        CamTarget.registerTargetType(SelfTarget.class, "self");
    }

    public static class SelfTarget
    extends CamTarget {
        @Override
        protected void write(CompoundNBT nbt) {
        }

        @Override
        protected void read(CompoundNBT nbt) {
        }

        @Override
        public Vector3d getTargetVec(World world, float partialTicks) {
            ClientPlayerEntity cachedEntity = Minecraft.func_71410_x().field_71439_g;
            if (cachedEntity instanceof LivingEntity) {
                return ((LivingEntity)cachedEntity).func_174824_e(partialTicks);
            }
            if (cachedEntity != null) {
                return cachedEntity.func_174824_e(partialTicks);
            }
            return null;
        }
    }

    public static class EntityTarget
    extends CamTarget {
        public Entity cachedEntity;
        public String uuid;

        public EntityTarget() {
        }

        public EntityTarget(Entity entity) {
            this.cachedEntity = entity;
            this.uuid = entity.func_189512_bd();
        }

        @Override
        public void start(World world) {
            for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY))) {
                if (!entity.func_189512_bd().equals(this.uuid)) continue;
                this.cachedEntity = entity;
                break;
            }
        }

        @Override
        public void finish() {
            this.cachedEntity = null;
        }

        @Override
        public Vector3d getTargetVec(World world, float partialTicks) {
            if (this.cachedEntity != null && !this.cachedEntity.func_70089_S()) {
                this.cachedEntity = null;
            }
            if (this.cachedEntity instanceof LivingEntity) {
                return ((LivingEntity)this.cachedEntity).func_174824_e(partialTicks);
            }
            if (this.cachedEntity != null) {
                return this.cachedEntity.func_174824_e(partialTicks);
            }
            return null;
        }

        @Override
        protected void write(CompoundNBT nbt) {
            nbt.func_74778_a("uuid", this.uuid);
        }

        @Override
        protected void read(CompoundNBT nbt) {
            this.uuid = nbt.func_74779_i("uuid");
        }
    }

    public static class BlockTarget
    extends CamTarget {
        public BlockPos pos;

        public BlockTarget() {
        }

        public BlockTarget(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public Vector3d getTargetVec(World world, float partialTicks) {
            return new Vector3d((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
        }

        @Override
        protected void write(CompoundNBT nbt) {
            nbt.func_74783_a("data", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        }

        @Override
        protected void read(CompoundNBT nbt) {
            int[] array = nbt.func_74759_k("data");
            if (array == null || array.length != 3) {
                throw new IllegalArgumentException("Invalid block target data=" + array);
            }
            this.pos = new BlockPos(array[0], array[1], array[2]);
        }
    }
}

